/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.differencer;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeFactory;
import com.ibm.pdp.mdl.compare.change.ConflictAttributeChange;
import com.ibm.pdp.mdl.compare.change.ConflictChange;
import com.ibm.pdp.mdl.compare.change.ConflictReferenceChange;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PTChangeAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<ChangeElement> getChanges(Matching matching) {
        ArrayList<ChangeElement> changes = new ArrayList<ChangeElement>();
        if (matching.getLeftObject().eClass() != matching.getRightObject().eClass()) {
            return changes;
        }
        EClass eClass = matching.getLeftObject().eClass();
        EList ls_attributes = eClass.getEAllAttributes();
        EAttribute[] eAttributes = ls_attributes.toArray(new EAttribute[ls_attributes.size()]);
        Arrays.sort(eAttributes, new Comparator<Object>(){

            @Override
            public int compare(Object first, Object second) {
                String name1 = ((EAttribute)first).getName();
                String name2 = ((EAttribute)second).getName();
                return name1.compareTo(name2);
            }
        });
        EList eReferences = eClass.getEAllReferences();
        if (matching instanceof Matching3Way) {
            Matching3Way matching3Way = (Matching3Way)matching;
            if (matching3Way.isUnmatch()) {
                changes.add((ChangeElement)this.createConflictChange(matching3Way));
            }
            EAttribute[] eAttributeArray = eAttributes;
            int n = eAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                EAttribute eAttribute = eAttributeArray[n2];
                this.check3WayAttributeChange(changes, matching3Way, eAttribute);
                ++n2;
            }
            for (EReference eReference : eReferences) {
                this.check3WayReferenceChange(changes, matching3Way, eReference);
            }
        } else {
            EAttribute[] eAttributeArray = eAttributes;
            int n = eAttributes.length;
            int n3 = 0;
            while (n3 < n) {
                EAttribute eAttribute = eAttributeArray[n3];
                this.check2WayAttributeChange(changes, matching, eAttribute);
                ++n3;
            }
            for (EReference eReference : eReferences) {
                this.check2WayReferenceChange(changes, matching, eReference);
            }
        }
        return changes;
    }

    private void check2WayAttributeChange(List<ChangeElement> changes, Matching matching, EAttribute eAttribute) {
        Object rightValue;
        if (!PTLabelFactory.acceptAttribute((EAttribute)eAttribute)) {
            return;
        }
        Object leftValue = matching.getLeftObject().eGet((EStructuralFeature)eAttribute);
        if (!this.isSameAttributeValue(leftValue, rightValue = matching.getRightObject().eGet((EStructuralFeature)eAttribute))) {
            changes.add((ChangeElement)this.createAttributeChange(matching, eAttribute, false));
        }
    }

    private void check3WayAttributeChange(List<ChangeElement> changes, Matching3Way matching3Way, EAttribute eAttribute) {
        if (!PTLabelFactory.acceptAttribute((EAttribute)eAttribute)) {
            return;
        }
        Object leftValue = matching3Way.getLeftObject().eGet((EStructuralFeature)eAttribute);
        Object rightValue = matching3Way.getRightObject().eGet((EStructuralFeature)eAttribute);
        Object ancestorValue = null;
        ancestorValue = matching3Way.getAncestorObject() != null ? matching3Way.getAncestorObject().eGet((EStructuralFeature)eAttribute) : null;
        boolean leftEqualAncestor = this.isSameAttributeValue(leftValue, ancestorValue);
        boolean rightEqualAncestor = this.isSameAttributeValue(rightValue, ancestorValue);
        boolean leftEqualRight = this.isSameAttributeValue(leftValue, rightValue);
        if (!leftEqualAncestor && !rightEqualAncestor) {
            if (!leftEqualRight) {
                changes.add((ChangeElement)this.createConflictAttributeChange(matching3Way, eAttribute));
            }
        } else if (!leftEqualAncestor && rightEqualAncestor) {
            changes.add((ChangeElement)this.createAttributeChange((Matching)matching3Way, eAttribute, false));
        } else if (leftEqualAncestor && !rightEqualAncestor) {
            changes.add((ChangeElement)this.createAttributeChange((Matching)matching3Way, eAttribute, true));
        }
    }

    private void check2WayReferenceChange(List<ChangeElement> changes, Matching matching, EReference eReference) {
        Object rightReference;
        String sourceClass = null;
        if (matching.getLeftObject() instanceof Entity) {
            sourceClass = ((Entity)matching.getLeftObject()).getOwner().eClass().getName();
        }
        if (!PTLabelFactory.acceptReference((EReference)eReference, sourceClass, null)) {
            return;
        }
        Object leftReference = matching.getLeftObject().eGet((EStructuralFeature)eReference);
        if (!this.isSameReference(leftReference, rightReference = matching.getRightObject().eGet((EStructuralFeature)eReference), eReference)) {
            changes.add((ChangeElement)this.createReferenceChange(matching, eReference, false));
        }
    }

    private void check3WayReferenceChange(List<ChangeElement> changes, Matching3Way matching3Way, EReference eReference) {
        String sourceClass = null;
        if (matching3Way.getLeftObject() instanceof Entity) {
            sourceClass = ((Entity)matching3Way.getLeftObject()).getOwner().eClass().getName();
        }
        if (!PTLabelFactory.acceptReference((EReference)eReference, sourceClass, null)) {
            return;
        }
        Object leftValue = matching3Way.getLeftObject().eGet((EStructuralFeature)eReference);
        Object rightValue = matching3Way.getRightObject().eGet((EStructuralFeature)eReference);
        Object ancestorValue = null;
        ancestorValue = matching3Way.getAncestorObject() != null ? matching3Way.getAncestorObject().eGet((EStructuralFeature)eReference) : null;
        boolean leftEqualAncestor = this.isSameReference(leftValue, ancestorValue, eReference);
        boolean rightEqualAncestor = this.isSameReference(rightValue, ancestorValue, eReference);
        boolean leftEqualRight = this.isSameReference(leftValue, rightValue, eReference);
        if (!leftEqualAncestor && !rightEqualAncestor) {
            if (!leftEqualRight) {
                changes.add((ChangeElement)this.createConflictReferenceChange(matching3Way, eReference));
            }
        } else if (!leftEqualAncestor && rightEqualAncestor) {
            changes.add((ChangeElement)this.createReferenceChange((Matching)matching3Way, eReference, false));
        } else if (leftEqualAncestor && !rightEqualAncestor) {
            changes.add((ChangeElement)this.createReferenceChange((Matching)matching3Way, eReference, true));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSameAttributeValue(Object leftValue, Object rightValue) {
        if (leftValue != null && rightValue != null) {
            if (!leftValue.getClass().isArray() || !rightValue.getClass().isArray()) return leftValue.equals(rightValue);
            if (Array.getLength(leftValue) != Array.getLength(rightValue)) return false;
            int i = 0;
            while (i < Array.getLength(leftValue)) {
                if (!this.isSameAttributeValue(Array.get(leftValue, i), Array.get(rightValue, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if ((leftValue == null || rightValue != null) && (leftValue != null || rightValue == null)) return true;
            return false;
        }
    }

    private boolean isSameReference(Object leftReference, Object rightReference, EReference eReference) {
        if (leftReference != null && rightReference != null) {
            if (leftReference instanceof Entity && rightReference instanceof Entity) {
                Entity leftObject = (Entity)leftReference;
                Entity rightObject = (Entity)rightReference;
                if (leftObject instanceof RadicalEntity && rightObject instanceof RadicalEntity) {
                    return leftObject.isSame(rightObject);
                }
                EReference eContainmentFeature = leftObject.eContainmentFeature();
                if (eReference == eContainmentFeature) {
                    return leftObject.isSame(rightObject);
                }
                if (eContainmentFeature.isMany()) {
                    List leftList = (List)leftObject.eContainer().eGet((EStructuralFeature)eContainmentFeature);
                    List rightList = (List)rightObject.eContainer().eGet((EStructuralFeature)eContainmentFeature);
                    return leftList.indexOf(leftObject) == rightList.indexOf(rightObject);
                }
                return true;
            }
            return leftReference.getClass() == rightReference.getClass();
        }
        return (leftReference == null || rightReference != null) && (leftReference != null || rightReference == null);
    }

    private AttributeChange createAttributeChange(Matching matching, EAttribute eAttribute, boolean isRemote) {
        AttributeChange attChange = ChangeFactory.eINSTANCE.createAttributeChange();
        attChange.setLeftObject(matching.getLeftObject());
        attChange.setRightObject(matching.getRightObject());
        attChange.setAttribute(eAttribute);
        attChange.setRemote(isRemote);
        return attChange;
    }

    private ReferenceChange createReferenceChange(Matching matching, EReference eReference, boolean isRemote) {
        ReferenceChange refChange = ChangeFactory.eINSTANCE.createReferenceChange();
        refChange.setLeftObject(matching.getLeftObject());
        refChange.setRightObject(matching.getRightObject());
        refChange.setReference(eReference);
        refChange.setRemote(isRemote);
        return refChange;
    }

    private PendingReference createPendingReference(Matching matching3Way, PTPartSide partSide) {
        if (partSide == PTPartSide.Left) {
            LeftPending leftPending = ChangeFactory.eINSTANCE.createLeftPending();
            leftPending.setLeftObject(matching3Way.getLeftObject());
            EObject rightObject = matching3Way.getRightObject();
            leftPending.setRightContainer(rightObject.eContainer());
            leftPending.setRightAnchor(this.getAnchor(rightObject, rightObject.eContainer()));
            return leftPending;
        }
        if (partSide == PTPartSide.Right) {
            RightPending rightPending = ChangeFactory.eINSTANCE.createRightPending();
            rightPending.setRightObject(matching3Way.getRightObject());
            EObject leftObject = matching3Way.getLeftObject();
            rightPending.setLeftContainer(leftObject.eContainer());
            rightPending.setRemote(true);
            rightPending.setLeftAnchor(this.getAnchor(leftObject, leftObject.eContainer()));
            return rightPending;
        }
        return null;
    }

    private EObject getAnchor(EObject eObject, EObject eContainer) {
        EObject anchor = null;
        EReference eReference = eObject.eContainmentFeature();
        List eList = (List)eContainer.eGet((EStructuralFeature)eReference);
        int index = eList.indexOf(eObject);
        if (index > 0) {
            anchor = (EObject)eList.get(index - 1);
        }
        return anchor;
    }

    private ConflictChange createConflictChange(Matching3Way matching3Way) {
        ConflictChange conflictChange = ChangeFactory.eINSTANCE.createConflictChange();
        conflictChange.setLeftObject(matching3Way.getLeftObject());
        conflictChange.setRightObject(matching3Way.getRightObject());
        conflictChange.setAncestorObject(matching3Way.getAncestorObject());
        return conflictChange;
    }

    private ConflictAttributeChange createConflictAttributeChange(Matching3Way matching3Way, EAttribute eAttribute) {
        ConflictAttributeChange conflictAttChange = ChangeFactory.eINSTANCE.createConflictAttributeChange();
        conflictAttChange.setLeftObject(matching3Way.getLeftObject());
        conflictAttChange.setRightObject(matching3Way.getRightObject());
        conflictAttChange.setAncestorObject(matching3Way.getAncestorObject());
        conflictAttChange.setAttribute(eAttribute);
        return conflictAttChange;
    }

    private ConflictReferenceChange createConflictReferenceChange(Matching3Way matching3Way, EReference eReference) {
        ConflictReferenceChange conflictRefChange = ChangeFactory.eINSTANCE.createConflictReferenceChange();
        conflictRefChange.setLeftObject(matching3Way.getLeftObject());
        conflictRefChange.setRightObject(matching3Way.getRightObject());
        conflictRefChange.setAncestorObject(matching3Way.getAncestorObject());
        conflictRefChange.setReference(eReference);
        return conflictRefChange;
    }
}

