/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.structure;

import com.ibm.pdp.compare.ui.PTCompareUIPlugin;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.viewer.PTAbstractAction;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerLabel;
import com.ibm.pdp.compare.ui.viewer.structure.PTStructureDiffContentProvider;
import com.ibm.pdp.compare.ui.viewer.structure.PTStructureDiffLabelProvider;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PTStructureDiffViewer
extends TreeViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CompareConfiguration _configuration;
    private ConfigurationPropertyListener _propertyListener = new ConfigurationPropertyListener();

    public PTStructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, 2816);
        this._configuration = configuration;
        this.initialize(parent);
        this.createToolItems(CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent()));
        this.setHelp(parent);
    }

    public void setHelp(Composite composite) {
        String contextId = "com.ibm.pdp.doc.cshelp.comparator";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, contextId);
    }

    public CompareConfiguration getConfiguration() {
        return this._configuration;
    }

    private void initialize(Composite parent) {
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)new PTStructureDiffContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PTStructureDiffLabelProvider());
        String title = PTCompareViewerLabel.getString(PTCompareViewerLabel._StructureViewerTitle);
        this.getTree().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
        this.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTStructureDiffViewer.this.getConfiguration().removePropertyChangeListener((IPropertyChangeListener)PTStructureDiffViewer.this._propertyListener);
                PTStructureDiffViewer.this.getConfiguration().setProperty("structure.selection", e.item.getData());
                PTStructureDiffViewer.this.getConfiguration().addPropertyChangeListener((IPropertyChangeListener)PTStructureDiffViewer.this._propertyListener);
            }
        });
        this.getConfiguration().addPropertyChangeListener((IPropertyChangeListener)this._propertyListener);
        IWorkbenchPart part = this.getConfiguration().getContainer().getWorkbenchPart();
        if (part != null) {
            part.getSite().setSelectionProvider((ISelectionProvider)this);
        }
    }

    private void createToolItems(ToolBarManager tbm) {
        ImageDescriptor imageDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("collapse_all");
        String toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._CollapseAll);
        PTAbstractAction collapseAll = new PTAbstractAction(toolTip, imageDesc, 1){

            @Override
            public void run() {
                PTStructureDiffViewer.this.collapseAll();
            }
        };
        imageDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("expand_all");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._ExpandAll);
        PTAbstractAction expandAll = new PTAbstractAction(toolTip, imageDesc, 1){

            @Override
            public void run() {
                PTStructureDiffViewer.this.expandAll();
            }
        };
        tbm.add((IContributionItem)new Separator("Navigation"));
        tbm.appendToGroup("Navigation", (IAction)collapseAll);
        tbm.appendToGroup("Navigation", (IAction)expandAll);
        tbm.update(true);
    }

    protected void fireOpen(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection != null) {
            Object selectedObject = selection.getFirstElement();
            this.getConfiguration().removePropertyChangeListener((IPropertyChangeListener)this._propertyListener);
            this.getConfiguration().setProperty("structure.open", selectedObject);
            this.getConfiguration().addPropertyChangeListener((IPropertyChangeListener)this._propertyListener);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        this.getConfiguration().removePropertyChangeListener((IPropertyChangeListener)this._propertyListener);
        super.handleDispose(event);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input instanceof PTComparisonSnapshot) {
            super.inputChanged(input, oldInput);
        } else if (oldInput instanceof PTComparisonSnapshot) {
            this.setInput(oldInput);
        }
        this.expandAll();
    }

    protected void updateSelection(ISelection selection) {
    }

    private class ConfigurationPropertyListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("composition.input")) {
                if (event.getNewValue() != event.getOldValue()) {
                    PTStructureDiffViewer.this.setInput(event.getNewValue());
                    PTStructureDiffViewer.this.expandToLevel(2);
                }
            } else if (event.getProperty().equals("structure.selection")) {
                if (event.getNewValue() instanceof ChangeElement) {
                    if (event.getNewValue() != event.getOldValue()) {
                        StructuredSelection selection = new StructuredSelection(event.getNewValue());
                        PTStructureDiffViewer.this.setSelection((ISelection)selection);
                    }
                } else {
                    PTStructureDiffViewer.this.setSelection(null);
                }
            } else if (event.getProperty().equals("structure.content")) {
                PTStructureDiffViewer.this.refresh();
            }
        }
    }
}

