/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part.composition;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTAdapterUtils;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerColor;
import com.ibm.pdp.compare.ui.viewer.content.part.IPTPartViewer;
import com.ibm.pdp.compare.ui.viewer.content.part.PTContentMergePart;
import com.ibm.pdp.compare.ui.viewer.content.part.PTGraphicWrapper;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionContentProvider;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionItem;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionLabelProvider;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionSorter;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ConflictAttributeChange;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.compare.change.RightPending;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PTCompositionTreeViewer
extends TreeViewer
implements IPTPartViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTContentMergePart _parentPart;
    private PTCompositionItem _rootItem;
    private Map<Object, PTCompositionItem> _objectToComposition = new IdentityHashMap<Object, PTCompositionItem>();
    private Map<EObject, TreeItem> _dataToTreeItem = new HashMap<EObject, TreeItem>();
    private Map<ChangeElement, PTGraphicWrapper> _changeToWrapper = new HashMap<ChangeElement, PTGraphicWrapper>();
    private List<PTGraphicWrapper> _visibleWrappers = new ArrayList<PTGraphicWrapper>();
    private Map<Item, TreePath> _treeItemToTreePath = new HashMap<Item, TreePath>();

    public PTCompositionTreeViewer(Composite parent, PTContentMergePart parentPart) {
        super(new Tree(parent, 0x20000300));
        this._parentPart = parentPart;
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)new PTCompositionContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PTCompositionLabelProvider(new AdapterFactoryLabelProvider(PTAdapterUtils.getAdapterFactory())));
        this.setComparator(new PTCompositionSorter());
        this.getTree().addPaintListener((PaintListener)new PTPaintListener());
        this.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareConfiguration configuration = PTCompositionTreeViewer.this._parentPart.getParentViewer().getConfiguration();
                configuration.setProperty("composition.selection", e.item.getData());
            }
        });
        this.getTree().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTCompositionTreeViewer.this._parentPart.getParentViewer().getCenterPart().redraw();
            }
        });
        this.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(false);
                e.doit = false;
                PTCompositionTreeViewer.this.redraw(true);
                if (PTCompositionTreeViewer.this._parentPart.getPartSide() != PTPartSide.Ancestor) {
                    PTCompositionTreeViewer.this._parentPart.getParentViewer().getCenterPart().redraw();
                }
            }

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                e.doit = false;
                PTCompositionTreeViewer.this.redraw(true);
                if (PTCompositionTreeViewer.this._parentPart.getPartSide() != PTPartSide.Ancestor) {
                    PTCompositionTreeViewer.this._parentPart.getParentViewer().getCenterPart().redraw();
                }
            }
        });
    }

    public PTPartSide getPartSide() {
        return this._parentPart.getPartSide();
    }

    public void refresh(Object element, boolean updateLabels) {
        this.clearCaches();
        this.initCaches();
        super.refresh(element, updateLabels);
    }

    private void clearCaches() {
        this._dataToTreeItem.clear();
        this._changeToWrapper.clear();
        this._visibleWrappers.clear();
    }

    private void initCaches() {
        if (this._parentPart.getParentViewer().getComparisonSnapshot() != null) {
            this.mapDataToTreeItem();
            this.mapChangeToWrapper();
        }
    }

    private void mapObjectToComposition() {
        this._objectToComposition.clear();
        if (this._rootItem != null) {
            for (PTCompositionItem compositionItem : this._rootItem.getAllChildren()) {
                if (compositionItem.getEObject() != null) {
                    this._objectToComposition.put(compositionItem.getEObject(), compositionItem);
                    continue;
                }
                if (compositionItem.getEList() == null) continue;
                this._objectToComposition.put(compositionItem.getEList(), compositionItem);
            }
        }
    }

    private void mapDataToTreeItem() {
        this._dataToTreeItem.clear();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.collectTreeItems(treeItem);
            ++n2;
        }
    }

    private void collectTreeItems(TreeItem treeItem) {
        if (treeItem.getData() instanceof PTCompositionItem) {
            PTCompositionItem compositionItem = (PTCompositionItem)treeItem.getData();
            if (compositionItem.getEObject() != null) {
                this._dataToTreeItem.put(compositionItem.getEObject(), treeItem);
            } else {
                this._dataToTreeItem.put((EObject)compositionItem.getEReference(), treeItem);
            }
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.collectTreeItems(child);
            ++n2;
        }
    }

    private void mapChangeToWrapper() {
        this._changeToWrapper.clear();
        List<ChangeElement> changes = this._parentPart.getParentViewer().getComparisonSnapshot().getLeafChanges();
        block0: for (ChangeElement change : changes) {
            PTComparisonSnapshot snapshot;
            EObject eObject = null;
            EReference eReference = null;
            EObject eContainer = null;
            if (this.getPartSide() == PTPartSide.Left) {
                eObject = PTObjectUtils.getLeftObject(change);
                if (eObject == null || change instanceof ReferenceChange || change instanceof PendingReference) {
                    eReference = PTObjectUtils.getEReference(change);
                    eContainer = PTObjectUtils.getLeftContainer(change);
                }
            } else if (this.getPartSide() == PTPartSide.Right) {
                eObject = PTObjectUtils.getRightObject(change);
                if (eObject == null || change instanceof ReferenceChange || change instanceof PendingReference) {
                    eReference = PTObjectUtils.getEReference(change);
                    eContainer = PTObjectUtils.getRightContainer(change);
                }
            } else if (this.getPartSide() == PTPartSide.Ancestor && ((eObject = PTObjectUtils.getAncestorObject(snapshot = this._parentPart.getParentViewer().getComparisonSnapshot(), change)) == null || change instanceof ReferenceChange || change instanceof PendingReference)) {
                eReference = PTObjectUtils.getEReference(change);
                eContainer = PTObjectUtils.getAncestorContainer(snapshot, change);
            }
            if (eObject == null && (eReference == null || eContainer == null)) continue;
            List<EObject> hierarchy = PTObjectUtils.getHierarchy(eObject, eReference, eContainer);
            for (EObject eNode : hierarchy) {
                TreeItem treeItem = this._dataToTreeItem.get(eNode);
                if (treeItem == null) continue;
                PTGraphicWrapper wrapper = new PTGraphicWrapper(change, (Item)treeItem);
                this._changeToWrapper.put(change, wrapper);
                continue block0;
            }
        }
    }

    protected Widget doFindInputItem(Object data) {
        TreeItem treeItem = this._dataToTreeItem.get(data);
        if (treeItem != null) {
            if (treeItem.isDisposed()) {
                this.clearCaches();
                this.initCaches();
            } else {
                return treeItem;
            }
        }
        return super.doFindInputItem(data);
    }

    protected TreePath getTreePathFromItem(Item treeItem) {
        TreePath treePath = this._treeItemToTreePath.get(treeItem);
        if (treePath == null) {
            treePath = super.getTreePathFromItem(treeItem);
            this._treeItemToTreePath.put(treeItem, treePath);
        }
        return treePath;
    }

    protected void inputChanged(Object input, Object oldInput) {
        TreePath[] expandedTreePaths = this.getExpandedTreePaths();
        super.inputChanged(input, oldInput);
        this.setExpandedTreePaths(expandedTreePaths);
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        super.setSelectionToWidget(list, reveal);
    }

    private Item getVisibleAncestorOf(Item item) {
        Item result = item;
        TreePath path = this.getTreePathFromItem(item);
        if (path.getSegmentCount() > 1) {
            int i = 0;
            while (i < path.getSegmentCount()) {
                TreeItem ancestor = (TreeItem)this.findItem(path.getSegment(i));
                if (ancestor != null && !ancestor.getExpanded()) {
                    result = ancestor;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private Map<TreeItem, Object> getVisibleTreeItems() {
        IdentityHashMap<TreeItem, Object> visibleItems = new IdentityHashMap<TreeItem, Object>();
        TreeItem topItem = this.getTree().getTopItem();
        if (topItem != null) {
            int treeHeight = this.getTree().getClientArea().height;
            int treeWidth = this.getTree().getBounds().width;
            int itemHeight = topItem.getBounds().height;
            visibleItems.put(topItem, null);
            int startY = topItem.getBounds().y + itemHeight + itemHeight / 2;
            int endY = treeHeight;
            int lineY = startY;
            while (lineY <= endY) {
                TreeItem treeItem = null;
                int lineX = 20;
                while (lineX < treeWidth) {
                    treeItem = this.getTree().getItem(new Point(lineX, lineY));
                    if (treeItem != null) break;
                    lineX += 20;
                }
                if (treeItem == null) break;
                visibleItems.put(treeItem, null);
                lineY += itemHeight;
            }
        }
        return visibleItems;
    }

    public void showItems(List<ChangeElement> changes) {
        ArrayList<PTCompositionItem> compositionItems = new ArrayList<PTCompositionItem>();
        for (ChangeElement change : changes) {
            EObject eRightObject;
            if (this.getPartSide() == PTPartSide.Ancestor && change instanceof ConflictAttributeChange) {
                EObject eObject = ((ConflictAttributeChange)change).getAncestorObject();
                if (eObject == null) continue;
                compositionItems.add(this._objectToComposition.get(eObject));
                continue;
            }
            if (this.getPartSide() == PTPartSide.Left) {
                EObject eLeftObject = PTObjectUtils.getLeftObject(change);
                if (eLeftObject == null) continue;
                compositionItems.add(this._objectToComposition.get(eLeftObject));
                continue;
            }
            if (this.getPartSide() != PTPartSide.Right || (eRightObject = PTObjectUtils.getRightObject(change)) == null) continue;
            compositionItems.add(this._objectToComposition.get(eRightObject));
        }
        for (PTCompositionItem mergeItem : compositionItems) {
            this.reveal(mergeItem);
        }
        this.setSelection((ISelection)new StructuredSelection(compositionItems), true);
        this.redraw(true);
    }

    private void compute(PTGraphicWrapper wrapper) {
        TreeItem anchorItem;
        wrapper.setSelection(false);
        ChangeElement selectedChange = this._parentPart.getParentViewer().getSelectedChange();
        if (wrapper.getChange() == selectedChange) {
            wrapper.setSelection(true);
        } else if (wrapper.getChange() instanceof AttributeChange && selectedChange instanceof AttributeChange && wrapper.getChange().getParent() == selectedChange.getParent()) {
            wrapper.setSelection(true);
        }
        ChangeElement change = wrapper.getChange();
        TreeItem treeItem = (TreeItem)wrapper.getVisibleItem();
        int wrapperY = treeItem.getBounds().y + treeItem.getBounds().height / 2;
        boolean linePattern = false;
        TreeItem lineAnchor = null;
        if (this.getPartSide() == PTPartSide.Left && change instanceof RightPending) {
            wrapper.setLineAnchor((Item)treeItem);
            if (treeItem.getExpanded() || ((PTCompositionItem)treeItem.getData()).getChildren().size() == 0) {
                linePattern = true;
                RightPending rightPending = (RightPending)change;
                if (this._dataToTreeItem.containsKey(rightPending.getLeftAnchor())) {
                    anchorItem = this._dataToTreeItem.get(rightPending.getLeftAnchor());
                    lineAnchor = this.getLastInBranch(anchorItem);
                    wrapperY = lineAnchor.getBounds().y + lineAnchor.getBounds().height;
                } else {
                    wrapperY = treeItem.getBounds().y + treeItem.getBounds().height;
                }
            }
        } else if (this.getPartSide() == PTPartSide.Right && change instanceof LeftPending) {
            wrapper.setLineAnchor((Item)treeItem);
            if (treeItem.getExpanded() || ((PTCompositionItem)treeItem.getData()).getChildren().size() == 0) {
                linePattern = true;
                LeftPending leftPending = (LeftPending)change;
                if (this._dataToTreeItem.containsKey(leftPending.getRightAnchor())) {
                    anchorItem = this._dataToTreeItem.get(leftPending.getRightAnchor());
                    lineAnchor = this.getLastInBranch(anchorItem);
                    wrapperY = lineAnchor.getBounds().y + lineAnchor.getBounds().height;
                } else {
                    wrapperY = treeItem.getBounds().y + treeItem.getBounds().height;
                }
            }
        } else if (this.getPartSide() == PTPartSide.Ancestor && change instanceof PendingReference) {
            wrapper.setLineAnchor((Item)treeItem);
            if (treeItem.getExpanded() || ((PTCompositionItem)treeItem.getData()).getChildren().size() == 0) {
                linePattern = true;
                PendingReference pendingReference = (PendingReference)change;
                if (this._dataToTreeItem.containsKey(pendingReference.getAncestorAnchor())) {
                    anchorItem = this._dataToTreeItem.get(pendingReference.getAncestorAnchor());
                    lineAnchor = this.getLastInBranch(anchorItem);
                    wrapperY = lineAnchor.getBounds().y + lineAnchor.getBounds().height;
                } else {
                    wrapperY = treeItem.getBounds().y + treeItem.getBounds().height;
                }
            }
        }
        wrapper.setY(wrapperY);
        wrapper.setLinePattern(linePattern);
        wrapper.setLineAnchor((Item)lineAnchor);
        Scrollable scrollable = (Scrollable)this.getControl();
        int offset = scrollable.getBounds().y + scrollable.getClientArea().height - (scrollable.getClientArea().y + scrollable.getBounds().height);
        if (scrollable.getClientArea().width < treeItem.getBounds().width) {
            offset += scrollable.getHorizontalBar().getSize().y;
        }
        wrapper.setVerticalOffset(offset);
    }

    @Override
    public void setInput(EObject eObject) {
        this._rootItem = new PTCompositionItem(eObject);
        this._rootItem.setupChildren(this._parentPart.getParentViewer().getComparisonSnapshot());
        this.mapObjectToComposition();
        ArrayList<PTCompositionItem> inputList = new ArrayList<PTCompositionItem>();
        inputList.add(this._rootItem);
        super.setInput(inputList);
        this.initCaches();
        this.expandToLevel(2);
    }

    @Override
    public void select(Object object) {
        PTCompositionItem itemToSelect = this._objectToComposition.get(object);
        if (itemToSelect != null) {
            StructuredSelection selection = new StructuredSelection((Object)itemToSelect);
            this.setSelection((ISelection)selection);
        }
    }

    @Override
    public List<PTGraphicWrapper> getVisibleWrappers() {
        this._visibleWrappers.clear();
        PTComparisonSnapshot snapshot = this._parentPart.getParentViewer().getComparisonSnapshot();
        if (snapshot == null || snapshot.getLeafChanges().size() == 0) {
            return this._visibleWrappers;
        }
        Map<TreeItem, Object> visibleTreeItems = null;
        for (PTGraphicWrapper wrapper : this._changeToWrapper.values()) {
            if (!this.isVisible(wrapper, visibleTreeItems)) continue;
            Item visibleItem = this.getVisibleAncestorOf(wrapper.getVisibleItem());
            if (visibleItem != wrapper.getVisibleItem()) {
                wrapper.setVisibleItem(visibleItem);
            }
            this.compute(wrapper);
            this._visibleWrappers.add(wrapper);
        }
        return this._visibleWrappers;
    }

    private boolean isVisible(PTGraphicWrapper wrapper, Map<TreeItem, Object> visibleTreeItems) {
        return true;
    }

    @Override
    public PTGraphicWrapper getWrapper(ChangeElement change) {
        PTGraphicWrapper wrapper = null;
        PTGraphicWrapper candidate = this._changeToWrapper.get(change);
        if (candidate != null) {
            Item treeItem = this.getVisibleAncestorOf(candidate.getVisibleItem());
            if (treeItem == candidate.getVisibleItem()) {
                wrapper = candidate;
            } else {
                wrapper = new PTGraphicWrapper(change, candidate.getActualItem());
                wrapper.setVisibleItem(treeItem);
            }
            this.compute(wrapper);
        }
        return wrapper;
    }

    @Override
    public void redraw(boolean initCache) {
        if (initCache) {
            this.clearCaches();
            this.initCaches();
        }
        this.getTree().redraw();
    }

    public void updateComposition(EObject eObject, EReference eReference) {
        if (eObject == null) {
            return;
        }
        PTCompositionItem compositionItem = this._objectToComposition.get(eObject);
        if (compositionItem != null) {
            int i = compositionItem.getChildren().size() - 1;
            while (i >= 0) {
                if (compositionItem.getChildren().get(i).getEReference() == eReference) {
                    compositionItem.getChildren().remove(compositionItem.getChildren().get(i));
                }
                --i;
            }
            compositionItem.setupReference(this._parentPart.getParentViewer().getComparisonSnapshot(), eReference, true);
            this.mapObjectToComposition();
            this.clearCaches();
            this.refresh();
            if (eReference != null && eReference.isMany()) {
                this.expandToLevel(this._objectToComposition.get(eObject.eGet((EStructuralFeature)eReference)), 1);
            } else {
                this.expandToLevel(this._objectToComposition.get(eObject), 1);
            }
        }
    }

    @Override
    public void dispose() {
        this._objectToComposition.clear();
        this.clearCaches();
        this._treeItemToTreePath.clear();
        this.getTree().dispose();
    }

    private TreeItem getLastInBranch(TreeItem treeItem) {
        TreeItem[] array;
        if (treeItem.getExpanded() && (array = treeItem.getItems()).length > 0) {
            return this.getLastInBranch(array[array.length - 1]);
        }
        return treeItem;
    }

    public String toString() {
        return this._parentPart.toString();
    }

    public void test() {
    }

    class PTPaintListener
    implements PaintListener {
        private Map<Rectangle, String> _rectangles = new HashMap<Rectangle, String>();

        PTPaintListener() {
        }

        public void paintControl(PaintEvent event) {
            this._rectangles.clear();
            Rectangle drawingBounds = new Rectangle(event.x, event.y, event.width, event.height);
            for (PTGraphicWrapper wrapper : PTCompositionTreeViewer.this.getVisibleWrappers()) {
                String colorId = wrapper.getLineColorId();
                Rectangle rectangle = this.getRectangle(drawingBounds, wrapper);
                if (this._rectangles.containsKey(rectangle)) {
                    if (PTCompareViewerColor.getLineWeight(colorId) <= PTCompareViewerColor.getLineWeight(this._rectangles.get(rectangle))) continue;
                    this._rectangles.put(rectangle, colorId);
                    continue;
                }
                this._rectangles.put(rectangle, colorId);
            }
            int weight = 0;
            while (weight <= 3) {
                HashMap<Rectangle, String> remainings = new HashMap<Rectangle, String>(this._rectangles);
                for (Map.Entry entry : remainings.entrySet()) {
                    if (PTCompareViewerColor.getLineWeight((String)entry.getValue()) != weight) continue;
                    this.drawRectangle(event.gc, (Rectangle)entry.getKey(), (String)entry.getValue());
                    this._rectangles.remove(entry.getKey());
                }
                ++weight;
            }
        }

        private Rectangle getRectangle(Rectangle drawingBounds, PTGraphicWrapper wrapper) {
            Rectangle treeBounds = PTCompositionTreeViewer.this.getTree().getClientArea();
            Rectangle treeItemBounds = ((TreeItem)wrapper.getVisibleItem()).getBounds();
            int marginX = 6;
            int rectY = treeItemBounds.y;
            int rectHeight = treeItemBounds.height - 1;
            Rectangle rectangle = null;
            if (PTCompositionTreeViewer.this.getPartSide() == PTPartSide.Left) {
                rectangle = new Rectangle(marginX, rectY, treeBounds.width, rectHeight);
            } else if (PTCompositionTreeViewer.this.getPartSide() == PTPartSide.Right) {
                rectangle = new Rectangle(-2, rectY, treeBounds.width - marginX, rectHeight);
            } else if (PTCompositionTreeViewer.this.getPartSide() == PTPartSide.Ancestor) {
                int width = treeBounds.width / 2 - 34;
                rectangle = new Rectangle(marginX, rectY, width, rectHeight);
            }
            if (wrapper.isLinePattern()) {
                int lineY = rectangle.y + rectangle.height;
                if (wrapper.getLineAnchor() != null) {
                    lineY = ((TreeItem)wrapper.getLineAnchor()).getBounds().y + rectangle.height;
                }
                rectangle = new Rectangle(rectangle.x, lineY, rectangle.width, 0);
            } else if (rectangle != null) {
                drawingBounds.intersects(rectangle);
            }
            return rectangle;
        }

        private void drawRectangle(GC gc, Rectangle bounds, String colorId) {
            gc.setLineStyle(1);
            gc.setForeground(PTCompareViewerColor.getColor(colorId));
            if (bounds.height > 0) {
                gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 5, 5);
            } else {
                gc.drawLine(bounds.x, bounds.y, bounds.width, bounds.y);
            }
        }
    }
}

