/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part.composition;

import com.ibm.pdp.compare.ui.PTCompareUIPlugin;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionItem;
import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PTCompositionLabelProvider
extends LabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AdapterFactoryLabelProvider _adapterFactoryLabelProvider;

    public PTCompositionLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof PTCompositionItem) {
            PTCompositionItem compositionItem = (PTCompositionItem)element;
            if (compositionItem.getWrappedEObject() != null) {
                EObject eObject = compositionItem.getWrappedEObject();
                if (eObject instanceof RadicalEntity) {
                    RadicalEntity radicalObject = (RadicalEntity)eObject;
                    String type = radicalObject.eClass().getName().toLowerCase();
                    PTFacet facet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
                    if (facet.getLabelProvider(type) != null) {
                        image = facet.getLabelProvider(type).getImage((Object)radicalObject);
                    }
                } else {
                    image = this._adapterFactoryLabelProvider.getImage((Object)eObject);
                }
            } else if (compositionItem.getEList() != null) {
                image = PTCompareUIPlugin.getDefault().getImage("list");
            }
        }
        return image;
    }

    public String getText(Object element) {
        String label = "Unknown";
        if (element instanceof PTCompositionItem) {
            PTCompositionItem compositionItem = (PTCompositionItem)element;
            StringBuilder buffer = new StringBuilder();
            if (compositionItem.getEReference() != null) {
                String ownerClass = this.getOwnerClass(compositionItem);
                if (compositionItem.getEReference().isMany()) {
                    if (compositionItem.getWrappedEObject() != null) {
                        buffer.append(PTLabelFactory.getShortLabel((EObject)compositionItem.getWrappedEObject()));
                    } else {
                        buffer.append(PTLabelFactory.getReferenceLabel((String)compositionItem.getEReference().getName(), (String)ownerClass, null, (boolean)true));
                    }
                } else {
                    buffer.append(PTLabelFactory.getReferenceLabel((String)compositionItem.getEReference().getName(), (String)ownerClass, null, (boolean)true));
                    if (compositionItem.getWrappedEObject() != null) {
                        buffer.append(" -> ");
                        buffer.append(PTLabelFactory.getShortLabel((EObject)compositionItem.getWrappedEObject()));
                    }
                }
            } else if (compositionItem.getWrappedEObject() != null) {
                EObject eObject = compositionItem.getWrappedEObject();
                buffer.append(PTLabelFactory.getShortLabel((EObject)eObject));
            }
            label = buffer.toString();
        }
        return label;
    }

    private String getOwnerClass(PTCompositionItem compositionItem) {
        String ownerClass = null;
        while (compositionItem.getParent() != null) {
            compositionItem = compositionItem.getParent();
        }
        if (compositionItem != null && compositionItem.getWrappedEObject() != null) {
            EObject eObject = compositionItem.getWrappedEObject();
            ownerClass = eObject.eClass().getName();
        }
        return ownerClass;
    }
}

