/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part.composition;

import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTObjectWrapper;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PTCompositionItem {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private EReference _eReference;
    private EObject _eObject;
    private EList<?> _eList;
    private PTCompositionItem _parent;
    private List<PTCompositionItem> _children;

    public PTCompositionItem(EObject eObject) {
        this._eObject = eObject;
    }

    public PTCompositionItem(EReference eReference, EObject eObject) {
        this._eReference = eReference;
        this._eObject = eObject;
    }

    public PTCompositionItem(EReference eReference, EList<?> eList) {
        this._eReference = eReference;
        this._eList = eList;
    }

    public EReference getEReference() {
        return this._eReference;
    }

    public EObject getEObject() {
        return this._eObject;
    }

    public EObject getWrappedEObject() {
        EObject eObject = this.getEObject();
        if (eObject instanceof PTObjectWrapper) {
            eObject = ((PTObjectWrapper)eObject).getWrappedEObject();
        }
        return eObject;
    }

    public EList<?> getEList() {
        return this._eList;
    }

    public PTCompositionItem getParent() {
        return this._parent;
    }

    public List<PTCompositionItem> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<PTCompositionItem>();
        }
        return this._children;
    }

    public List<PTCompositionItem> getAllChildren() {
        ArrayList<PTCompositionItem> mergeItems = new ArrayList<PTCompositionItem>();
        this.collectChildren(mergeItems);
        return mergeItems;
    }

    private void collectChildren(List<PTCompositionItem> mergeItems) {
        mergeItems.add(this);
        for (PTCompositionItem mergeItem : this.getChildren()) {
            mergeItem.collectChildren(mergeItems);
        }
    }

    public void setupChildren(PTComparisonSnapshot snapshot) {
        block9: {
            block8: {
                if (this.getEObject() == null) break block8;
                if (this.getEReference() != null && !this.getEReference().isContainment()) {
                    if (this.getEObject() instanceof RadicalEntity) {
                        PTCompositionItem rootItem = this;
                        while (rootItem.getParent() != null) {
                            rootItem = rootItem.getParent();
                        }
                        if (this.getEObject() == rootItem.getEObject()) {
                            PTObjectWrapper wrapper = new PTObjectWrapper(this.getEObject());
                            this._eObject = wrapper;
                        }
                    } else {
                        PTObjectWrapper wrapper = new PTObjectWrapper(this.getEObject());
                        this._eObject = wrapper;
                    }
                    return;
                }
                for (EReference eReference : this.getEObject().eClass().getEAllReferences()) {
                    String sourceClass = null;
                    if (this.getEObject() instanceof Entity) {
                        sourceClass = ((Entity)this.getEObject()).getOwner().eClass().getName();
                    }
                    if (!PTLabelFactory.acceptReference((EReference)eReference, sourceClass, null)) continue;
                    this.setupReference(snapshot, eReference, false);
                }
                break block9;
            }
            if (this.getEList() == null) break block9;
            for (Object object : this.getEList()) {
                EObject eObject;
                if (!(object instanceof EObject) || !PTLabelFactory.accept((EObject)(eObject = (EObject)object))) continue;
                PTCompositionItem compositionItem = new PTCompositionItem(this.getEReference(), eObject);
                compositionItem._parent = this;
                this.getChildren().add(compositionItem);
                compositionItem.setupChildren(snapshot);
            }
        }
    }

    public void setupReference(PTComparisonSnapshot snapshot, EReference eReference, boolean keepList) {
        Object object = this.getEObject().eGet((EStructuralFeature)eReference);
        PTCompositionItem childItem = null;
        if (object instanceof EList) {
            EList eList = (EList)object;
            if (keepList || !this.isMatchingListEmpty(this.getEObject(), eReference, snapshot)) {
                childItem = new PTCompositionItem(eReference, eList);
            }
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            childItem = new PTCompositionItem(eReference, eObject);
        }
        if (childItem != null) {
            childItem._parent = this;
            this.getChildren().add(childItem);
            childItem.setupChildren(snapshot);
        }
    }

    private boolean isListEmpty(EList<?> eList) {
        for (Object object : eList) {
            if (!(object instanceof EObject) || !PTLabelFactory.accept((EObject)((EObject)object))) continue;
            return false;
        }
        return true;
    }

    private boolean isMatchingListEmpty(EObject eContainer, EReference eReference, PTComparisonSnapshot snapshot) {
        Object object = snapshot.getMatching(eContainer);
        if (object instanceof Matching) {
            Object ancestorList;
            EObject eAncestorContainer;
            Object rightList;
            Object leftList;
            Matching matching = (Matching)object;
            if (matching.getLeftObject() != null && (leftList = matching.getLeftObject().eGet((EStructuralFeature)eReference)) instanceof EList && !this.isListEmpty((EList)leftList)) {
                return false;
            }
            if (matching.getRightObject() != null && (rightList = matching.getRightObject().eGet((EStructuralFeature)eReference)) instanceof EList && !this.isListEmpty((EList)rightList)) {
                return false;
            }
            if (matching instanceof Matching3Way && (eAncestorContainer = ((Matching3Way)matching).getAncestorObject()) != null && (ancestorList = eAncestorContainer.eGet((EStructuralFeature)eReference)) instanceof EList && !this.isListEmpty((EList)ancestorList)) {
                return false;
            }
        } else {
            Object list = eContainer.eGet((EStructuralFeature)eReference);
            if (list instanceof EList && !this.isListEmpty((EList)list)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getEReference() != null) {
            buffer.append(this.getEReference().getName());
            if (this.getEObject() != null) {
                buffer.append("->").append(this.getEObject().eClass().getName());
            }
        } else if (this.getEObject() != null) {
            buffer.append(this.getEObject().eClass().getName());
        }
        return buffer.toString();
    }
}

