/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part.attribute;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTAdapterUtils;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerColor;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerLabel;
import com.ibm.pdp.compare.ui.viewer.content.part.IPTPartViewer;
import com.ibm.pdp.compare.ui.viewer.content.part.PTContentMergePart;
import com.ibm.pdp.compare.ui.viewer.content.part.PTGraphicWrapper;
import com.ibm.pdp.compare.ui.viewer.content.part.attribute.PTAttributeTableContentProvider;
import com.ibm.pdp.compare.ui.viewer.content.part.attribute.PTAttributeTableLabelProvider;
import com.ibm.pdp.compare.ui.viewer.content.part.attribute.PTProxyWrapper;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class PTAttributeTableViewer
extends TableViewer
implements IPTPartViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTContentMergePart _parentPart;
    private Map<EAttribute, TableItem> _dataToTableItem = new HashMap<EAttribute, TableItem>();
    private Map<AttributeChange, PTGraphicWrapper> _changeToWrapper = new HashMap<AttributeChange, PTGraphicWrapper>();

    public PTAttributeTableViewer(Composite parent, PTContentMergePart parentPart) {
        super(parent, 0);
        this._parentPart = parentPart;
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)new PTAttributeTableContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PTAttributeTableLabelProvider(PTAdapterUtils.getAdapterFactory()));
        this.getTable().addPaintListener((PaintListener)new PTPaintListener());
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        GC gc = new GC((Drawable)this.getTable());
        gc.setFont(this.getTable().getFont());
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        TableColumn nameColumn = new TableColumn(this.getTable(), 16384);
        nameColumn.setText(PTCompareViewerLabel.getString(PTCompareViewerLabel._AttributePartNameColumn));
        nameColumn.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)(nameColumn.getText().length() * 3)));
        TableColumn valueColumn = new TableColumn(this.getTable(), 131072);
        valueColumn.setText(PTCompareViewerLabel.getString(PTCompareViewerLabel._AttributePartValueColumn));
        valueColumn.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)(valueColumn.getText().length() * 6)));
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject eObject = (EObject)PTAttributeTableViewer.this.getInput();
                EAttribute eAttribute = null;
                Object data = e.item.getData();
                if (data instanceof List && ((List)data).size() > 0 && ((List)data).get(0) instanceof EAttribute) {
                    eAttribute = (EAttribute)((List)data).get(0);
                }
                if (eAttribute != null) {
                    CompareConfiguration configuration = PTAttributeTableViewer.this._parentPart.getParentViewer().getConfiguration();
                    EObject[] array = new EObject[]{eObject, eAttribute};
                    configuration.setProperty("attribute.selection", (Object)array);
                }
            }
        });
        this.getTable().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAttributeTableViewer.this._parentPart.getParentViewer().getCenterPart().redraw();
            }
        });
    }

    public PTPartSide getPartSide() {
        return this._parentPart.getPartSide();
    }

    public void refresh(Object element, boolean updateLabels) {
        this.clearCaches();
        super.refresh(element, updateLabels);
        this.initCaches();
    }

    private void clearCaches() {
        this._dataToTableItem.clear();
        this._changeToWrapper.clear();
    }

    private void initCaches() {
        if (this._parentPart.getParentViewer().getComparisonSnapshot() != null) {
            this.mapDataToTableItem();
            this.mapChangeToWrapper();
        }
    }

    private void mapDataToTableItem() {
        this._dataToTableItem.clear();
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            List list;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() instanceof List && (list = (List)tableItem.getData()).size() > 0 && list.get(0) instanceof EAttribute) {
                this._dataToTableItem.put((EAttribute)list.get(0), tableItem);
            }
            ++n2;
        }
    }

    private void mapChangeToWrapper() {
        this._changeToWrapper.clear();
        List<ChangeElement> changes = this._parentPart.getParentViewer().getComparisonSnapshot().getLeafChanges();
        for (ChangeElement change : changes) {
            if (!(change instanceof AttributeChange)) continue;
            AttributeChange attChange = (AttributeChange)change;
            EObject eInputObject = (EObject)this.getInput();
            EObject eObject = null;
            if (this.getPartSide() == PTPartSide.Left) {
                eObject = attChange.getLeftObject();
            } else if (this.getPartSide() == PTPartSide.Right) {
                eObject = attChange.getRightObject();
            } else if (this.getPartSide() == PTPartSide.Ancestor) {
                PTComparisonSnapshot snapshot = this._parentPart.getParentViewer().getComparisonSnapshot();
                eObject = PTObjectUtils.getAncestorObject(snapshot, change);
            }
            if (eInputObject != eObject) continue;
            TableItem tableItem = this._dataToTableItem.get(attChange.getAttribute());
            PTGraphicWrapper wrapper = new PTGraphicWrapper(change, (Item)tableItem);
            this._changeToWrapper.put(attChange, wrapper);
        }
    }

    private void compute(PTGraphicWrapper wrapper) {
        wrapper.setSelection(false);
        if (wrapper.getChange() == this._parentPart.getParentViewer().getSelectedChange()) {
            wrapper.setSelection(true);
        }
        TableItem tableItem = (TableItem)wrapper.getVisibleItem();
        int wrapperY = tableItem.getBounds().y + tableItem.getBounds().height / 2;
        wrapper.setY(wrapperY);
        Scrollable scrollable = (Scrollable)this.getControl();
        int offset = scrollable.getBounds().y + scrollable.getClientArea().height - (scrollable.getClientArea().y + scrollable.getBounds().height);
        if (scrollable.getClientArea().width < tableItem.getBounds().width) {
            offset += scrollable.getHorizontalBar().getSize().y;
        }
        wrapper.setVerticalOffset(offset);
    }

    @Override
    public void setInput(EObject eObject) {
        if (eObject instanceof RadicalEntity && this.isProxy((RadicalEntity)eObject)) {
            PTProxyWrapper proxyWrapper = new PTProxyWrapper((RadicalEntity)eObject);
            super.setInput((Object)proxyWrapper);
        } else {
            super.setInput((Object)eObject);
        }
        this.initCaches();
    }

    private boolean isProxy(RadicalEntity radicalObject) {
        boolean isProxy = false;
        PTComparisonSnapshot snapshot = this._parentPart.getParentViewer().getComparisonSnapshot();
        MatchModel matchModel = snapshot.getMatchModel();
        if (this.getPartSide() == PTPartSide.Left) {
            isProxy = radicalObject != matchModel.getLeftRoot();
        } else if (this.getPartSide() == PTPartSide.Right) {
            isProxy = radicalObject != matchModel.getRightRoot();
        } else if (this.getPartSide() == PTPartSide.Ancestor) {
            isProxy = radicalObject != matchModel.getAncestorRoot();
        }
        return isProxy;
    }

    @Override
    public void select(Object object) {
        List itemToSelect = null;
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            List data;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() instanceof List && (data = (List)tableItem.getData()).size() > 0 && data.get(0) == object) {
                itemToSelect = data;
                break;
            }
            ++n2;
        }
        if (itemToSelect != null) {
            StructuredSelection selection = new StructuredSelection(itemToSelect);
            this.setSelection((ISelection)selection);
        }
    }

    @Override
    public List<PTGraphicWrapper> getVisibleWrappers() {
        ArrayList<PTGraphicWrapper> visibles = new ArrayList<PTGraphicWrapper>();
        PTComparisonSnapshot snapshot = this._parentPart.getParentViewer().getComparisonSnapshot();
        if (snapshot == null || snapshot.getLeafChanges().size() == 0) {
            return visibles;
        }
        for (Map.Entry<AttributeChange, PTGraphicWrapper> entry : this._changeToWrapper.entrySet()) {
            AttributeChange attChange = entry.getKey();
            PTGraphicWrapper wrapper = entry.getValue();
            this.compute(wrapper);
            TableItem tableItem = this._dataToTableItem.get(attChange.getAttribute());
            if (tableItem == null || tableItem.getBounds().y < this.getTable().getClientArea().y || tableItem.getBounds().y > this.getTable().getClientArea().y + this.getTable().getClientArea().height) continue;
            visibles.add(wrapper);
        }
        return visibles;
    }

    @Override
    public PTGraphicWrapper getWrapper(ChangeElement change) {
        PTGraphicWrapper wrapper = this._changeToWrapper.get(change);
        return wrapper;
    }

    @Override
    public void redraw(boolean initCache) {
        if (initCache) {
            this.clearCaches();
            this.initCaches();
        }
        this.refresh();
        this.getTable().redraw();
    }

    @Override
    public void dispose() {
        this.clearCaches();
        this.getTable().dispose();
    }

    public String toString() {
        return this._parentPart.toString();
    }

    public void test() {
        List<PTGraphicWrapper> wrappers = this.getVisibleWrappers();
        wrappers.size();
    }

    class PTPaintListener
    implements PaintListener {
        PTPaintListener() {
        }

        public void paintControl(PaintEvent event) {
            for (PTGraphicWrapper wrapper : PTAttributeTableViewer.this.getVisibleWrappers()) {
                this.drawRectangle(event.gc, wrapper);
            }
        }

        private void drawRectangle(GC gc, PTGraphicWrapper wrapper) {
            Rectangle tableBounds = PTAttributeTableViewer.this.getTable().getClientArea();
            Rectangle tableItemBounds = ((TableItem)wrapper.getActualItem()).getBounds();
            gc.setLineStyle(1);
            gc.setForeground(PTCompareViewerColor.getColor(wrapper.getLineColorId()));
            int marginX = 4;
            Rectangle bounds = null;
            if (PTAttributeTableViewer.this.getPartSide() == PTPartSide.Left) {
                bounds = new Rectangle(marginX, tableItemBounds.y, tableBounds.width, tableItemBounds.height);
            } else if (PTAttributeTableViewer.this.getPartSide() == PTPartSide.Right) {
                bounds = new Rectangle(-2, tableItemBounds.y, tableBounds.width - marginX, tableItemBounds.height);
            } else if (PTAttributeTableViewer.this.getPartSide() == PTPartSide.Ancestor) {
                int width = tableBounds.width / 2 - 34;
                bounds = new Rectangle(marginX, tableItemBounds.y, width, tableItemBounds.height);
            }
            if (bounds != null) {
                gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 5, 5);
            }
        }
    }
}

