/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part;

import com.ibm.pdp.mdl.compare.change.ChangeElement;
import org.eclipse.swt.widgets.Item;

public class PTGraphicWrapper {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ChangeElement _change;
    private Item _actualItem;
    private Item _visibleItem;
    private boolean _selection;
    private boolean _linePattern;
    private int _y;
    private Item _lineAnchor;
    private int _verticalOffset;

    public PTGraphicWrapper(ChangeElement change, Item actualItem) {
        this._change = change;
        this._actualItem = actualItem;
    }

    public ChangeElement getChange() {
        return this._change;
    }

    public Item getActualItem() {
        return this._actualItem;
    }

    public boolean isConflicting() {
        return this.getChange().isConflicting();
    }

    public Item getVisibleItem() {
        if (this._visibleItem == null) {
            return this.getActualItem();
        }
        return this._visibleItem;
    }

    public void setVisibleItem(Item visibleItem) {
        this._visibleItem = visibleItem;
    }

    public boolean getSelection() {
        return this._selection;
    }

    public void setSelection(boolean selection) {
        this._selection = selection;
    }

    public boolean isLinePattern() {
        return this._linePattern;
    }

    public void setLinePattern(boolean linePattern) {
        this._linePattern = linePattern;
    }

    public int getY() {
        return this._y;
    }

    public void setY(int y) {
        this._y = y;
    }

    public Item getLineAnchor() {
        return this._lineAnchor;
    }

    public void setLineAnchor(Item lineAnchor) {
        this._lineAnchor = lineAnchor;
    }

    public int getVerticalOffset() {
        return this._verticalOffset;
    }

    public void setVerticalOffset(int offset) {
        this._verticalOffset = offset;
    }

    public String getLineColorId() {
        String colorId = "line.light";
        if (this.isConflicting()) {
            colorId = "line.conflict.light";
            if (this.getSelection()) {
                colorId = "line.conflict.solid";
            }
        } else if (this.getSelection()) {
            colorId = "line.solid";
        }
        return colorId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("wrapped: ").append(this.getActualItem());
        buffer.append(", change: ").append(this.getChange().toString());
        buffer.append(", Y: ").append(this.getY());
        return buffer.toString();
    }
}

