/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.PTDisplayMode;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.compare.ui.viewer.content.PTContentMergeViewer;
import com.ibm.pdp.compare.ui.viewer.content.part.PTGraphicWrapper;
import com.ibm.pdp.compare.ui.viewer.content.part.attribute.PTAttributeTableViewer;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionItem;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionTreeViewer;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.kernel.Entity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.PageBook;

public class PTContentMergePart {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTContentMergeViewer _parentViewer;
    public PTPartSide _partSide;
    private PageBook _pageBook;
    private PTCompositionTreeViewer _compositionTree;
    private PTAttributeTableViewer _attributeTable;

    public PTContentMergePart(PTContentMergeViewer viewer, Composite parent, PTPartSide partSide) {
        this._parentViewer = viewer;
        this._partSide = partSide;
        this.createControls(parent);
    }

    public PTContentMergeViewer getParentViewer() {
        return this._parentViewer;
    }

    public PTPartSide getPartSide() {
        return this._partSide;
    }

    private void createControls(Composite parent) {
        this._pageBook = new PageBook(parent, 2048);
        this.createCompositionTreeViewer();
        this.createAttributeTableViewer();
        this.getPageBook().showPage(this._compositionTree.getControl());
    }

    private void createCompositionTreeViewer() {
        this._compositionTree = new PTCompositionTreeViewer((Composite)this.getPageBook(), this);
    }

    private void createAttributeTableViewer() {
        this._attributeTable = new PTAttributeTableViewer((Composite)this.getPageBook(), this);
    }

    public PageBook getPageBook() {
        return this._pageBook;
    }

    public PTCompositionTreeViewer getCompositionViewer() {
        return this._compositionTree;
    }

    public PTAttributeTableViewer getAttributeViewer() {
        return this._attributeTable;
    }

    public List<PTGraphicWrapper> getVisibleWrappers() {
        List<Object> visibles = new ArrayList();
        if (this.getParentViewer().getDisplayMode() == PTDisplayMode.Composition) {
            visibles = this.getCompositionViewer().getVisibleWrappers();
        } else if (this.getParentViewer().getDisplayMode() == PTDisplayMode.Attribute) {
            visibles = this.getAttributeViewer().getVisibleWrappers();
        }
        return visibles;
    }

    public PTGraphicWrapper getWrapper(ChangeElement change) {
        PTGraphicWrapper wrapper = null;
        if (this.getParentViewer().getDisplayMode() == PTDisplayMode.Composition) {
            wrapper = this.getCompositionViewer().getWrapper(change);
        } else if (this.getParentViewer().getDisplayMode() == PTDisplayMode.Attribute) {
            wrapper = this.getAttributeViewer().getWrapper(change);
        }
        return wrapper;
    }

    public void setInput(EObject eObject) {
        this.getCompositionViewer().setInput(eObject);
        this.getAttributeViewer().setInput(eObject);
    }

    public void setSelection(ChangeElement change) {
        if (this._partSide == PTPartSide.Ancestor) {
            PTComparisonSnapshot snapshot = this.getParentViewer().getComparisonSnapshot();
            EObject ancestorObject = PTObjectUtils.getAncestorObject(snapshot, change);
            if (ancestorObject == null) {
                EObject eContainer = PTObjectUtils.getAncestorContainer(snapshot, change);
                if (eContainer != null) {
                    EReference eReference = PTObjectUtils.getEReference(change);
                    Object value = eContainer.eGet((EStructuralFeature)eReference);
                    if (value instanceof EObject) {
                        if (value instanceof EList) {
                            EList eList = (EList)value;
                            if (eList.size() > 0) {
                                this.doSelect((EObject)eList.get(0), null);
                            }
                            this.doSelect(eList);
                        } else {
                            this.doSelect((EObject)value, null);
                        }
                    } else {
                        this.doSelect(eContainer, null);
                    }
                }
            } else {
                EAttribute eAttribute = null;
                if (change instanceof AttributeChange) {
                    eAttribute = ((AttributeChange)change).getAttribute();
                }
                this.doSelect(ancestorObject, eAttribute);
            }
            this.getCompositionViewer().redraw(false);
        } else if (this._partSide == PTPartSide.Left) {
            EObject leftObject = PTObjectUtils.getLeftObject(change);
            if (leftObject == null) {
                if (change instanceof RightPending) {
                    EObject eContainer = PTObjectUtils.getLeftContainer(change);
                    EReference eReference = PTObjectUtils.getEReference(change);
                    if (eContainer != null && eReference != null) {
                        EList eList = (EList)eContainer.eGet((EStructuralFeature)eReference);
                        if (eList.size() > 0) {
                            this.doSelect((EObject)eList.get(0), null);
                        }
                        this.doSelect(eList);
                    }
                }
            } else {
                EAttribute eAttribute = null;
                if (change instanceof AttributeChange) {
                    eAttribute = ((AttributeChange)change).getAttribute();
                }
                this.doSelect(leftObject, eAttribute);
            }
            this.getCompositionViewer().redraw(false);
        } else if (this._partSide == PTPartSide.Right) {
            EObject rightObject = PTObjectUtils.getRightObject(change);
            if (rightObject == null) {
                if (change instanceof LeftPending) {
                    EObject eContainer = PTObjectUtils.getRightContainer(change);
                    EReference eReference = PTObjectUtils.getEReference(change);
                    if (eContainer != null && eReference != null) {
                        EList eList = (EList)eContainer.eGet((EStructuralFeature)eReference);
                        if (eList.size() > 0) {
                            this.doSelect((EObject)eList.get(0), null);
                        }
                        this.doSelect(eList);
                    }
                }
            } else if (rightObject instanceof EObject) {
                EAttribute eAttribute = null;
                if (change instanceof AttributeChange) {
                    eAttribute = ((AttributeChange)change).getAttribute();
                }
                this.doSelect(rightObject, eAttribute);
            }
            this.getCompositionViewer().redraw(false);
        }
    }

    public void setSelection(PTCompositionItem compositionItem) {
        EObject eObject = compositionItem.getEObject();
        PTComparisonSnapshot snapshot = this.getParentViewer().getComparisonSnapshot();
        if (eObject != null) {
            Object object = snapshot.getMatching(eObject);
            if (object instanceof Matching) {
                EObject eMatched = snapshot.getMatchedObject(eObject, this.getPartSide());
                this.doSelect(eMatched, null);
            } else {
                EReference eReference = eObject.eContainmentFeature();
                EObject eContainer = eObject.eContainer();
                EObject eMatchedContainer = snapshot.getMatchedObject(eContainer, this.getPartSide());
                if (eMatchedContainer != null && eMatchedContainer != eContainer) {
                    EObject eMatched = null;
                    if (eObject instanceof Entity) {
                        eMatched = this.findSimilar((Entity)eObject, eMatchedContainer, eReference);
                    }
                    if (eMatched != null) {
                        this.doSelect(eMatched, null);
                    } else {
                        this.doSelect((EList)eMatchedContainer.eGet((EStructuralFeature)eReference));
                    }
                }
            }
        } else if (compositionItem.getEList() != null) {
            EReference eReference = compositionItem.getEReference();
            EObject eContainer = compositionItem.getParent().getEObject();
            EObject eMatchedContainer = snapshot.getMatchedObject(eContainer, this.getPartSide());
            if (eMatchedContainer != null) {
                this.doSelect((EList)eMatchedContainer.eGet((EStructuralFeature)eReference));
            }
        }
    }

    private EObject findSimilar(Entity eObject, EObject eContainer, EReference eReference) {
        Object object = eContainer.eGet((EStructuralFeature)eReference);
        if (object instanceof List) {
            List list = (List)object;
            for (Object eContained : list) {
                if (!(eContained instanceof Entity) || !((Entity)eContained).isSame(eObject)) continue;
                return (Entity)eContained;
            }
        }
        return null;
    }

    public void setSelection(EAttribute eAttribute) {
        this.doSelect(eAttribute);
        this.getAttributeViewer().redraw(false);
    }

    private void doSelect(EList<?> eList) {
        this.getCompositionViewer().select(eList);
        this.getAttributeViewer().setInput(null);
    }

    private void doSelect(EObject eObject, EAttribute eAttribute) {
        this.getCompositionViewer().select(eObject);
        if (eObject != null) {
            this.getAttributeViewer().setInput(eObject);
        }
        this.getAttributeViewer().select(eAttribute);
    }

    private void doSelect(EAttribute eAttribute) {
        this.getAttributeViewer().select(eAttribute);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.getPageBook().setBounds(x, y, width, height);
        this.getCompositionViewer().getControl().setBounds(this._pageBook.getClientArea());
        this.getAttributeViewer().getControl().setBounds(this._pageBook.getClientArea());
    }

    public void redraw(boolean initCache) {
        this.getPageBook().redraw();
        this.getCompositionViewer().redraw(initCache);
        this.getAttributeViewer().redraw(initCache);
    }

    public void dispose() {
        this.getCompositionViewer().dispose();
        this.getAttributeViewer().dispose();
        this.getPageBook().dispose();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this._partSide.toString());
        return buffer.toString();
    }
}

