/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content.part;

import com.ibm.pdp.compare.ui.viewer.PTCompareViewerColor;
import com.ibm.pdp.compare.ui.viewer.content.part.PTContentMergePart;
import com.ibm.pdp.compare.ui.viewer.content.part.PTGraphicWrapper;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class PTCenterCanvas
extends Canvas {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2014. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<Point, String> _points = new HashMap<Point, String>();
    private PTContentMergePart _leftPart;
    private PTContentMergePart _rightPart;
    private double[] _centerCurve;

    public PTCenterCanvas(Composite parent, PTContentMergePart leftPart, PTContentMergePart rightPart) {
        super(parent, 0x340000);
        this._leftPart = leftPart;
        this._rightPart = rightPart;
        PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                PTCenterCanvas.this.doPaint(event.gc);
            }
        };
        this.addPaintListener(paintListener);
        this.moveAbove(null);
    }

    private void doPaint(GC gc) {
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        this._points.clear();
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawLine(0, 0, 0, this.getBounds().height);
        gc.drawLine(this.getBounds().width - 1, 0, this.getBounds().width - 1, this.getBounds().height);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, size.x, size.y);
        HashSet<ChangeElement> visibleChanges = new HashSet<ChangeElement>();
        for (PTGraphicWrapper left : this._leftPart.getVisibleWrappers()) {
            visibleChanges.add(left.getChange());
        }
        for (PTGraphicWrapper right : this._rightPart.getVisibleWrappers()) {
            visibleChanges.add(right.getChange());
        }
        HashSet<Integer> leftArrows = new HashSet<Integer>();
        HashSet<Integer> rightArrows = new HashSet<Integer>();
        for (ChangeElement change : visibleChanges) {
            String rightColorId;
            String leftColorId;
            if (change instanceof ChangeGroup) continue;
            PTGraphicWrapper leftWrapper = this._leftPart.getWrapper(change);
            PTGraphicWrapper rightWrapper = this._rightPart.getWrapper(change);
            if (leftWrapper == null || rightWrapper == null || !(leftColorId = leftWrapper.getLineColorId()).equals(rightColorId = rightWrapper.getLineColorId())) continue;
            Point point = new Point(leftWrapper.getY(), rightWrapper.getY());
            if (this._points.containsKey(point)) {
                if (PTCompareViewerColor.getLineWeight(leftColorId) <= PTCompareViewerColor.getLineWeight(this._points.get(point))) continue;
                this._points.put(point, leftColorId);
                if (leftWrapper.isLinePattern()) {
                    leftArrows.add(point.x);
                }
                if (!rightWrapper.isLinePattern()) continue;
                rightArrows.add(point.y);
                continue;
            }
            this._points.put(point, leftColorId);
            if (leftWrapper.isLinePattern()) {
                leftArrows.add(point.x);
            }
            if (!rightWrapper.isLinePattern()) continue;
            rightArrows.add(point.y);
        }
        int weight = 0;
        while (weight <= 3) {
            HashMap<Point, String> remainings = new HashMap<Point, String>(this._points);
            for (Map.Entry entry : remainings.entrySet()) {
                if (PTCompareViewerColor.getLineWeight((String)entry.getValue()) != weight) continue;
                boolean leftArrow = leftArrows.contains(((Point)entry.getKey()).x);
                boolean rightArrow = rightArrows.contains(((Point)entry.getKey()).y);
                this.drawCurveLine(gc, (Point)entry.getKey(), (String)entry.getValue(), leftArrow, rightArrow);
                this._points.remove(entry.getKey());
            }
            ++weight;
        }
    }

    private void drawCurveLine(GC gc, Point point, String colorId, boolean leftArrow, boolean rightArrow) {
        int[] points;
        int y;
        int x;
        Rectangle canvasBounds = this.getBounds();
        int startX = 0;
        int startY = point.x + 1;
        int endX = canvasBounds.width;
        int endY = point.y + 1;
        Point rtgl = new Point(2, 17);
        Point trgl = new Point(3, 3);
        gc.setLineStyle(1);
        gc.setForeground(PTCompareViewerColor.getColor(colorId));
        if (leftArrow) {
            x = 0;
            y = startY;
            points = new int[]{x, y, x + trgl.x, y - trgl.y, x + trgl.x, y + trgl.y};
            gc.drawPolygon(points);
            startX += trgl.x;
        } else {
            gc.drawRoundRectangle(-1, startY - rtgl.y / 2, rtgl.x, rtgl.y, 5, 5);
            startX += rtgl.x;
        }
        if (rightArrow) {
            x = endX - rtgl.x;
            y = endY;
            points = new int[]{x, y, x - trgl.x, y - trgl.y, x - trgl.x, y + trgl.y};
            gc.drawPolygon(points);
            endX -= trgl.x + 1;
        } else {
            gc.drawRoundRectangle(endX - rtgl.x, endY - rtgl.y / 2, 4, rtgl.y, 5, 5);
            endX -= rtgl.x + 1;
        }
        int[] points2 = this.getCenterCurvePoints(startX, startY, endX, endY);
        int i = 1;
        while (i < points2.length) {
            gc.drawLine(startX + i - 1, points2[i - 1], startX + i, points2[i]);
            ++i;
        }
    }

    private int[] getCenterCurvePoints(int startX, int startY, int endX, int endY) {
        if (this._centerCurve == null) {
            this.buildBaseCenterCurve(endX - startX);
        }
        double height = endY - startY;
        height /= 2.0;
        int width = endX - startX;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this._centerCurve[i] + height + (double)startY);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this._centerCurve = new double[34];
        int i = 0;
        while (i < 34) {
            double r = (double)i / width;
            this._centerCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }
}

