/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content;

import com.ibm.pdp.compare.PTComparePlugin;
import com.ibm.pdp.compare.ui.editor.PTWrapperInput;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class PTTextMergeViewerContentProvider
extends MergeViewerContentProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String charset = "UTF-8";
    protected CompareElement _leftElement;
    protected CompareElement _rightElement;

    public PTTextMergeViewerContentProvider(CompareConfiguration config) {
        super(config);
    }

    public Object getLeftContent(Object element) {
        EObject eObject;
        PTComparisonSnapshot snapshot;
        if (element instanceof PTWrapperInput && (snapshot = ((PTWrapperInput)element).getSnapshot()).getMatchModel() != null && (eObject = snapshot.getMatchModel().getLeftRoot()) instanceof PacMacro) {
            this._leftElement = new CompareElement(((PacMacro)eObject).getSource());
            return this._leftElement;
        }
        return null;
    }

    public Object getRightContent(Object element) {
        EObject eObject;
        PTComparisonSnapshot snapshot;
        if (element instanceof PTWrapperInput && (snapshot = ((PTWrapperInput)element).getSnapshot()).getMatchModel() != null && (eObject = snapshot.getMatchModel().getRightRoot()) instanceof PacMacro) {
            this._rightElement = new CompareElement(((PacMacro)eObject).getSource());
            return this._rightElement;
        }
        return null;
    }

    public Object getAncestorContent(Object element) {
        EObject eObject;
        PTComparisonSnapshot snapshot;
        if (element instanceof PTWrapperInput && (snapshot = ((PTWrapperInput)element).getSnapshot()).getMatchModel() != null && (eObject = snapshot.getMatchModel().getAncestorRoot()) instanceof PacMacro) {
            return new CompareElement(((PacMacro)eObject).getSource());
        }
        return null;
    }

    public boolean isLeftEditable(Object element) {
        ITypedElement left;
        if (element instanceof PTWrapperInput && (left = ((PTWrapperInput)element).getLeft()) instanceof IEditableContent) {
            return ((IEditableContent)left).isEditable();
        }
        return false;
    }

    public boolean isRightEditable(Object element) {
        ITypedElement right;
        if (element instanceof PTWrapperInput && (right = ((PTWrapperInput)element).getRight()) instanceof IEditableContent) {
            return ((IEditableContent)right).isEditable();
        }
        return false;
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        PTWrapperInput compareInput;
        EObject eLeft;
        if (element instanceof PTWrapperInput && (eLeft = (compareInput = (PTWrapperInput)element).getSnapshot().getMatchModel().getLeftRoot()) instanceof PacMacro && compareInput.getLeft() instanceof IResourceProvider) {
            PacMacro pacMacro = (PacMacro)eLeft;
            try {
                pacMacro.setSource(new String(bytes, charset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                pacMacro.setSource(new String(bytes));
            }
            IResourceProvider leftProvider = (IResourceProvider)compareInput.getLeft();
            try {
                pacMacro.save();
                PTEditorService.dirty((IPath)leftProvider.getResource().getFullPath(), (boolean)false);
            }
            catch (IOException e) {
                PTComparePlugin.logError((String)e.getMessage());
            }
        }
    }

    public void saveRightContent(Object element, byte[] bytes) {
        PTWrapperInput compareInput;
        EObject eRight;
        if (element instanceof PTWrapperInput && (eRight = (compareInput = (PTWrapperInput)element).getSnapshot().getMatchModel().getRightRoot()) instanceof RadicalEntity && compareInput.getRight() instanceof IResourceProvider) {
            PacMacro pacMacro = (PacMacro)eRight;
            try {
                pacMacro.setSource(new String(bytes, charset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                pacMacro.setSource(new String(bytes));
            }
            IResourceProvider rightProvider = (IResourceProvider)compareInput.getRight();
            try {
                pacMacro.save();
                PTEditorService.dirty((IPath)rightProvider.getResource().getFullPath(), (boolean)false);
            }
            catch (IOException e) {
                PTComparePlugin.logError((String)e.getMessage());
            }
        }
    }

    public IDocument getLeftDocument() {
        if (this._leftElement != null) {
            return DocumentManager.get((Object)this._leftElement);
        }
        return null;
    }

    public IDocument getRightDocument() {
        if (this._rightElement != null) {
            return DocumentManager.get((Object)this._rightElement);
        }
        return null;
    }

    protected static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String _content;

        public CompareElement(String content) {
            this._content = content;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            try {
                return new ByteArrayInputStream(this._content.getBytes(this.getCharset()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this._content.getBytes());
            }
        }

        public String getCharset() {
            return PTTextMergeViewerContentProvider.charset;
        }
    }
}

