/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.editor.PTWrapperInput;
import com.ibm.pdp.compare.ui.engine.PTCompareEngine;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTTextMerger;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerLabel;
import com.ibm.pdp.compare.ui.viewer.content.PTTextMergeViewerContentProvider;
import com.ibm.pdp.explorer.editor.service.IPTEditor;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PTTextMergeViewer
extends TextMergeViewer
implements IDocumentListener,
IPTEditor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTComparisonSnapshot _snapshot;
    private IPath _leftPath;
    private IPath _rightPath;
    private NotifyChangeListener _notifyChangeListener;
    private PTTextMerger _merger;
    private boolean _isDisposed = false;

    public PTTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)this.newTextMergeViewerContentProvider(configuration));
    }

    protected PTTextMergeViewerContentProvider newTextMergeViewerContentProvider(CompareConfiguration configuration) {
        return new PTTextMergeViewerContentProvider(configuration);
    }

    public void setHelp(Composite composite) {
        String contextId = "com.ibm.pdp.doc.cshelp.comparator";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, contextId);
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        String title = this.newTitle();
        composite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
        this.setHelp(composite);
    }

    protected String newTitle() {
        return PTCompareViewerLabel.getString(PTCompareViewerLabel._MacroSourceCompareTitle);
    }

    public PTTextMerger getMerger() {
        return this._merger;
    }

    public CompareConfiguration getConfiguration() {
        return this.getCompareConfiguration();
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof ISourceViewer) {
            SourceViewerConfiguration config = new SourceViewerConfiguration();
            ((ISourceViewer)textViewer).configure(config);
        }
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            PTWrapperInput compareInput;
            ICompareInput nativeInput = (ICompareInput)input;
            if (nativeInput instanceof PTWrapperInput) {
                compareInput = (PTWrapperInput)nativeInput;
                this._snapshot = compareInput.getSnapshot();
                if (compareInput.getSnapshot() == null) {
                    PTCompareEngine compareEngine = PTCompareEngine.getInstance();
                    this._snapshot = compareEngine.doCompare(compareInput);
                    compareEngine.clear();
                    compareInput.setSnapshot(this.getComparisonSnapshot());
                } else {
                    this._snapshot = compareInput.getSnapshot();
                }
            } else {
                compareInput = new PTWrapperInput(nativeInput);
                PTCompareEngine compareEngine = PTCompareEngine.getInstance();
                this._snapshot = compareEngine.doCompare(nativeInput);
                compareEngine.clear();
                compareInput.setSnapshot(this.getComparisonSnapshot());
            }
            super.setInput((Object)compareInput);
            this.getConfiguration().setProperty("composition.input", (Object)this.getComparisonSnapshot());
            PTEditorService.registerEditor((IPath)this.getResourcePath(PTPartSide.Left), (IPTEditor)this);
            PTEditorService.addNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getLeftRoot());
            PTEditorService.registerEditor((IPath)this.getResourcePath(PTPartSide.Right), (IPTEditor)this);
            PTEditorService.addNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getRightRoot());
            this._merger = this.newTextMerger();
        } else {
            super.setInput(input);
        }
    }

    protected PTTextMerger newTextMerger() {
        return new PTTextMerger(this.getComparisonSnapshot());
    }

    public PTComparisonSnapshot getComparisonSnapshot() {
        return this._snapshot;
    }

    private NotifyChangeListener getNotifyChangeListener() {
        if (this._notifyChangeListener == null) {
            this._notifyChangeListener = new NotifyChangeListener();
        }
        return this._notifyChangeListener;
    }

    public IPath getResourcePath(PTPartSide partSide) {
        IPath resourcePath = null;
        if (partSide == PTPartSide.Left) {
            ITypedElement typedElement;
            if (this.getInput() instanceof ICompareInput && (typedElement = ((ICompareInput)this.getInput()).getLeft()) instanceof IResourceProvider) {
                IResourceProvider resourceProvider = (IResourceProvider)typedElement;
                this._leftPath = resourceProvider.getResource().getFullPath();
            }
            resourcePath = this._leftPath;
        } else if (partSide == PTPartSide.Right) {
            ITypedElement typedElement;
            if (this.getInput() instanceof ICompareInput && (typedElement = ((ICompareInput)this.getInput()).getRight()) instanceof IResourceProvider) {
                IResourceProvider resourceProvider = (IResourceProvider)typedElement;
                this._rightPath = resourceProvider.getResource().getFullPath();
            }
            resourcePath = this._rightPath;
        }
        return resourcePath;
    }

    public RadicalEntity getAncestorRoot() {
        RadicalEntity ancestorObject = null;
        if (this.getComparisonSnapshot().getMatchModel() != null) {
            ancestorObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getAncestorRoot();
        }
        return ancestorObject;
    }

    public RadicalEntity getLeftRoot() {
        RadicalEntity leftObject = null;
        if (this.getComparisonSnapshot() != null && this.getComparisonSnapshot().getMatchModel() != null) {
            leftObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getLeftRoot();
        }
        return leftObject;
    }

    public RadicalEntity getRightRoot() {
        RadicalEntity rightObject = null;
        if (this.getComparisonSnapshot() != null && this.getComparisonSnapshot().getMatchModel() != null) {
            rightObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getRightRoot();
        }
        return rightObject;
    }

    private void copyCurrent(IDocument leftDocument, IDocument rightDocument, boolean leftToRight) {
        this.getMerger().copyChange(leftDocument, rightDocument, leftToRight);
        boolean isUpdated = false;
        isUpdated = leftDocument.get().equals(rightDocument.get()) ? this.getMerger().removeAttributeChange() : this.getMerger().addAttributeChange();
        if (isUpdated) {
            this.getComparisonSnapshot().resetCache();
            this.getConfiguration().setProperty("structure.content", null);
        }
    }

    protected void copy(boolean leftToRight) {
        if (this.getComparisonSnapshot().getChangeModel() == null) {
            return;
        }
        super.copy(leftToRight);
        PTTextMergeViewerContentProvider provider = (PTTextMergeViewerContentProvider)this.getContentProvider();
        this.copyCurrent(provider.getLeftDocument(), provider.getRightDocument(), leftToRight);
    }

    protected void handleDispose(DisposeEvent event) {
        IDocument rightDocument;
        PTEditorService.removeNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getLeftRoot());
        PTEditorService.unregisterEditor((IPath)this.getResourcePath(PTPartSide.Left), (IPTEditor)this);
        PTEditorService.removeNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getRightRoot());
        PTEditorService.unregisterEditor((IPath)this.getResourcePath(PTPartSide.Right), (IPTEditor)this);
        PTTextMergeViewerContentProvider provider = (PTTextMergeViewerContentProvider)this.getContentProvider();
        IDocument leftDocument = provider.getLeftDocument();
        if (leftDocument != null) {
            leftDocument.removeDocumentListener((IDocumentListener)this);
        }
        if ((rightDocument = provider.getRightDocument()) != null) {
            rightDocument.removeDocumentListener((IDocumentListener)this);
        }
        this._snapshot = null;
        super.handleDispose(event);
        this._isDisposed = true;
    }

    protected void setupDocument(IDocument document) {
        super.setupDocument(document);
        document.addDocumentListener((IDocumentListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        IDocument document = event.getDocument();
        PTTextMergeViewerContentProvider provider = (PTTextMergeViewerContentProvider)this.getContentProvider();
        IDocument leftDocument = provider.getLeftDocument();
        IDocument rightDocument = provider.getRightDocument();
        if (document == leftDocument) {
            this.copyCurrent(leftDocument, rightDocument, false);
        } else if (document == provider.getRightDocument()) {
            this.copyCurrent(leftDocument, rightDocument, true);
        }
    }

    public IPTEditor.PTPartKind getPartKind() {
        return IPTEditor.PTPartKind.Editor;
    }

    public boolean isDirty(IPath relativePath) {
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Left))) {
            return this.isLeftDirty();
        }
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Right))) {
            return this.isRightDirty();
        }
        return false;
    }

    public void dirty(IPath relativePath, boolean dirty) {
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Left))) {
            this.setLeftDirty(dirty);
        } else if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Right))) {
            this.setRightDirty(dirty);
        }
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public void synchronize(IPath relativePath) {
        System.out.println("synchronize: " + relativePath);
    }

    private class NotifyChangeListener
    implements INotifyChangedListener {
        public void notifyChanged(Notification notification) {
            RadicalEntity notifier;
            if (notification.getEventType() != 1 && notification.getEventType() != 3 && notification.getEventType() != 4 && notification.getEventType() != 5 && notification.getEventType() != 6 && notification.getEventType() != 7) {
                return;
            }
            if (notification.getNotifier() instanceof Entity && (notifier = ((Entity)notification.getNotifier()).getOwner()) != null && notifier != PTTextMergeViewer.this.getLeftRoot()) {
                PTTextMergeViewer.this.getRightRoot();
            }
        }
    }
}

