/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content;

import com.ibm.pdp.compare.PTComparePlugin;
import com.ibm.pdp.compare.ui.editor.PTMasterInput;
import com.ibm.pdp.compare.ui.editor.PTWrapperInput;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerLabel;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.marker.PTMarkerManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PTContentMergeViewerContentProvider
implements IMergeViewerContentProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CompareConfiguration _configuration;
    private PTWrapperInput _compareInput;

    public PTContentMergeViewerContentProvider(CompareConfiguration configuration) {
        this._configuration = configuration;
    }

    public void dispose() {
    }

    public Object getAncestorContent(Object element) {
        ITypedElement content = null;
        if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getAncestor();
        }
        return content;
    }

    public Image getAncestorImage(Object element) {
        return this._configuration.getAncestorImage(element);
    }

    public String getAncestorLabel(Object element) {
        return this._configuration.getAncestorLabel(element);
    }

    public Object getLeftContent(Object element) {
        ITypedElement content = null;
        if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getLeft();
        }
        return content;
    }

    public Image getLeftImage(Object element) {
        return this._configuration.getLeftImage(element);
    }

    public String getLeftLabel(Object element) {
        if (this._compareInput != null && this._compareInput.isSwapped()) {
            return this._configuration.getRightLabel(element);
        }
        return this._configuration.getLeftLabel(element);
    }

    public Object getRightContent(Object element) {
        ITypedElement content = null;
        if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getRight();
        }
        return content;
    }

    public Image getRightImage(Object element) {
        return this._configuration.getRightImage(element);
    }

    public String getRightLabel(Object element) {
        if (this._compareInput != null && this._compareInput.isSwapped()) {
            return this._configuration.getLeftLabel(element);
        }
        return this._configuration.getRightLabel(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._compareInput = newInput instanceof PTWrapperInput ? (PTWrapperInput)newInput : null;
    }

    public boolean isLeftEditable(Object element) {
        ITypedElement left;
        if (element instanceof PTWrapperInput && (left = ((PTWrapperInput)element).getLeft()) instanceof IEditableContent) {
            return ((IEditableContent)left).isEditable();
        }
        return false;
    }

    public boolean isRightEditable(Object element) {
        ITypedElement right;
        if (element instanceof PTWrapperInput && (right = ((PTWrapperInput)element).getRight()) instanceof IEditableContent) {
            return ((IEditableContent)right).isEditable();
        }
        return false;
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        PTWrapperInput compareInput;
        EObject eLeft;
        if (element instanceof PTWrapperInput && (eLeft = (compareInput = (PTWrapperInput)element).getSnapshot().getMatchModel().getLeftRoot()) instanceof RadicalEntity && compareInput.getLeft() instanceof IResourceProvider) {
            RadicalEntity leftObject = (RadicalEntity)eLeft;
            IResourceProvider leftProvider = (IResourceProvider)compareInput.getLeft();
            IPath leftPath = leftProvider.getResource().getFullPath();
            try {
                leftObject.save();
                PTEditorService.dirty((IPath)leftPath, (boolean)false);
            }
            catch (IOException e) {
                PTComparePlugin.logError((String)e.getMessage());
            }
        }
    }

    public void saveRightContent(Object element, byte[] bytes) {
        PTWrapperInput compareInput;
        EObject eRight;
        if (element instanceof PTWrapperInput && (eRight = (compareInput = (PTWrapperInput)element).getSnapshot().getMatchModel().getRightRoot()) instanceof RadicalEntity && compareInput.getRight() instanceof IResourceProvider) {
            Object[] array;
            String message;
            String title;
            Shell shell;
            RadicalEntity rightObject = (RadicalEntity)eRight;
            IResourceProvider rightProvider = (IResourceProvider)compareInput.getRight();
            IPath rightPath = rightProvider.getResource().getFullPath();
            if (compareInput.getNativeInput() instanceof PTMasterInput && MessageDialog.openQuestion((Shell)(shell = Display.getCurrent().getActiveShell()), (String)(title = PTCompareViewerLabel.getString(PTCompareViewerLabel._Synchronize_Title)), (String)(message = PTCompareViewerLabel.getString(PTCompareViewerLabel._Synchronize_Msg, array = new String[]{rightPath.makeRelative().toString()})))) {
                IPath masterPath = PTModelService.getMaster((IPath)rightPath);
                rightObject.setMasterStateId(PTModelService.getStateId((IPath)masterPath));
                PTMarkerManager.deleteSyncMarker((IPath)rightPath);
            }
            try {
                rightObject.save();
                PTEditorService.dirty((IPath)rightPath, (boolean)false);
            }
            catch (IOException e) {
                PTComparePlugin.logError((String)e.getMessage());
            }
        }
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }
}

