/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.viewer.content;

import com.ibm.pdp.compare.PTComparisonKind;
import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.PTCompareUIPlugin;
import com.ibm.pdp.compare.ui.PTDisplayMode;
import com.ibm.pdp.compare.ui.editor.PTWrapperInput;
import com.ibm.pdp.compare.ui.engine.PTCompareEngine;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTContentMerger;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.compare.ui.viewer.PTAbstractAction;
import com.ibm.pdp.compare.ui.viewer.PTCompareViewerLabel;
import com.ibm.pdp.compare.ui.viewer.content.PTContentMergeViewerContentProvider;
import com.ibm.pdp.compare.ui.viewer.content.part.PTCenterCanvas;
import com.ibm.pdp.compare.ui.viewer.content.part.PTContentMergePart;
import com.ibm.pdp.compare.ui.viewer.content.part.composition.PTCompositionItem;
import com.ibm.pdp.explorer.editor.service.IPTEditor;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeModel;
import com.ibm.pdp.mdl.compare.change.ConflictChange;
import com.ibm.pdp.mdl.compare.change.FeatureChange;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class PTContentMergeViewer
extends ContentMergeViewer
implements IPTEditor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    public static final int _CENTER_WIDTH = 34;
    private static final String _SWAPPED = "org.eclipse.compare.Swapped";
    private ConfigurationPropertyListener _propertyListener = new ConfigurationPropertyListener();
    private PreferencesPropertyListener _preferencesListener = new PreferencesPropertyListener();
    private PTComparisonSnapshot _snapshot;
    private IPath _leftPath;
    private IPath _rightPath;
    private PTComparisonKind _comparisonKind = PTComparisonKind.TwoWay;
    private PTDisplayMode _displayMode = PTDisplayMode.Composition;
    private ChangeElement _selectedChange;
    private PTContentMergePart _ancestorPart;
    private PTContentMergePart _leftPart;
    private PTCenterCanvas _centerPart;
    private PTContentMergePart _rightPart;
    private PTContentMergePart[] _parts;
    private Action _displayComposition;
    private Action _displayAttribute;
    private Action _copyLeftToRight;
    private Action _copyRightToLeft;
    private ActionContributionItem _copySelLeftToRightItem;
    private ActionContributionItem _copySelRightToLeftItem;
    private NotifyChangeListener _notifyChangeListener;
    private PTContentMerger _merger;
    private boolean _isDisposed = false;

    public PTContentMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(0, ResourceBundle.getBundle(_BUNDLE_NAME), configuration);
        this.buildControl(parent);
        this.setHelp(parent);
        this.setContentProvider((IContentProvider)new PTContentMergeViewerContentProvider(this.getConfiguration()));
        this.getConfiguration().addPropertyChangeListener((IPropertyChangeListener)this._propertyListener);
        this.getConfiguration().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this._preferencesListener);
    }

    public void setHelp(Composite composite) {
        String contextId = "com.ibm.pdp.doc.cshelp.comparator";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, contextId);
    }

    public String getTitle() {
        return PTCompareViewerLabel.getString(PTCompareViewerLabel._ContentMergeViewerTitle);
    }

    private PTContentMerger getMerger() {
        return this._merger;
    }

    public CompareConfiguration getConfiguration() {
        return this.getCompareConfiguration();
    }

    public PTDisplayMode getDisplayMode() {
        return this._displayMode;
    }

    public ChangeElement getSelectedChange() {
        return this._selectedChange;
    }

    public void setSelectedChange(ChangeElement change) {
        this._selectedChange = change;
    }

    public PTCenterCanvas getCenterPart() {
        return this._centerPart;
    }

    public PTContentMergePart[] getParts() {
        if (this._parts == null) {
            this._parts = new PTContentMergePart[]{this._ancestorPart, this._leftPart, this._rightPart};
        }
        return this._parts;
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            PTWrapperInput compareInput;
            ICompareInput nativeInput = (ICompareInput)input;
            this._comparisonKind = nativeInput.getAncestor() != null ? PTComparisonKind.ThreeWay : PTComparisonKind.TwoWay;
            if (nativeInput instanceof PTWrapperInput) {
                compareInput = (PTWrapperInput)nativeInput;
                if (compareInput.getSnapshot() == null) {
                    PTCompareEngine compareEngine = PTCompareEngine.getInstance();
                    this._snapshot = compareEngine.doCompare(compareInput);
                    compareEngine.clear();
                    compareInput.setSnapshot(this.getComparisonSnapshot());
                } else {
                    this._snapshot = compareInput.getSnapshot();
                }
            } else {
                compareInput = new PTWrapperInput(nativeInput);
                PTCompareEngine compareEngine = PTCompareEngine.getInstance();
                this._snapshot = compareEngine.doCompare(nativeInput);
                compareEngine.clear();
                compareInput.setSnapshot(this.getComparisonSnapshot());
            }
            if (this._comparisonKind == PTComparisonKind.ThreeWay) {
                this._ancestorPart.setInput((EObject)this.getAncestorRoot());
                this._ancestorPart.redraw(true);
            }
            this._leftPart.setInput((EObject)this.getLeftRoot());
            this._leftPart.redraw(true);
            this._rightPart.setInput((EObject)this.getRightRoot());
            this._rightPart.redraw(true);
            super.setInput((Object)compareInput);
            this.getConfiguration().setProperty("composition.input", (Object)this.getComparisonSnapshot());
            PTEditorService.registerEditor((IPath)this.getResourcePath(PTPartSide.Left), (IPTEditor)this);
            PTEditorService.addNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getLeftRoot());
            PTEditorService.registerEditor((IPath)this.getResourcePath(PTPartSide.Right), (IPTEditor)this);
            PTEditorService.addNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getRightRoot());
            this._merger = new PTContentMerger(this.getComparisonSnapshot());
            this.updateCopyState();
        } else {
            super.setInput(input);
        }
    }

    public PTComparisonSnapshot getComparisonSnapshot() {
        return this._snapshot;
    }

    private NotifyChangeListener getNotifyChangeListener() {
        if (this._notifyChangeListener == null) {
            this._notifyChangeListener = new NotifyChangeListener();
        }
        return this._notifyChangeListener;
    }

    public IPath getResourcePath(PTPartSide partSide) {
        IPath resourcePath = null;
        if (partSide == PTPartSide.Left) {
            ITypedElement typedElement;
            if (this.getInput() instanceof ICompareInput && (typedElement = ((ICompareInput)this.getInput()).getLeft()) instanceof IResourceProvider) {
                IResourceProvider resourceProvider = (IResourceProvider)typedElement;
                this._leftPath = resourceProvider.getResource().getFullPath();
            }
            resourcePath = this._leftPath;
        } else if (partSide == PTPartSide.Right) {
            ITypedElement typedElement;
            if (this.getInput() instanceof ICompareInput && (typedElement = ((ICompareInput)this.getInput()).getRight()) instanceof IResourceProvider) {
                IResourceProvider resourceProvider = (IResourceProvider)typedElement;
                this._rightPath = resourceProvider.getResource().getFullPath();
            }
            resourcePath = this._rightPath;
        }
        return resourcePath;
    }

    public RadicalEntity getAncestorRoot() {
        RadicalEntity ancestorObject = null;
        if (this.getComparisonSnapshot().getMatchModel() != null) {
            ancestorObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getAncestorRoot();
        }
        return ancestorObject;
    }

    public RadicalEntity getLeftRoot() {
        RadicalEntity leftObject = null;
        if (this.getComparisonSnapshot() != null && this.getComparisonSnapshot().getMatchModel() != null) {
            leftObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getLeftRoot();
        }
        return leftObject;
    }

    public RadicalEntity getRightRoot() {
        RadicalEntity rightObject = null;
        if (this.getComparisonSnapshot() != null && this.getComparisonSnapshot().getMatchModel() != null) {
            rightObject = (RadicalEntity)this.getComparisonSnapshot().getMatchModel().getRightRoot();
        }
        return rightObject;
    }

    protected void createToolItems(ToolBarManager tbm) {
        tbm.insertBefore("modes", (IContributionItem)new Separator("display"));
        ImageDescriptor imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("composition");
        String toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._ShowComposition);
        this._displayComposition = new PTAbstractAction(toolTip, imgDesc, 8){

            @Override
            public void run() {
                if (PTContentMergeViewer.this.getDisplayMode() == PTDisplayMode.Attribute && this.isChecked()) {
                    PTContentMergeViewer.this.switchDisplayMode();
                }
            }
        };
        this._displayComposition.setChecked(true);
        tbm.appendToGroup("display", (IAction)this._displayComposition);
        imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("attribute");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._ShowAttributes);
        this._displayAttribute = new PTAbstractAction(toolTip, imgDesc, 8){

            @Override
            public void run() {
                if (PTContentMergeViewer.this.getDisplayMode() == PTDisplayMode.Composition && this.isChecked()) {
                    PTContentMergeViewer.this.switchDisplayMode();
                }
            }
        };
        tbm.appendToGroup("display", (IAction)this._displayAttribute);
        imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("copy_sel_right");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._CopySelectionToRight);
        this._copyLeftToRight = new PTAbstractAction(toolTip, imgDesc, 1){

            @Override
            public void run() {
                PTContentMergeViewer.this.copyCurrent(true);
            }
        };
        this._copySelLeftToRightItem = new ActionContributionItem((IAction)this._copyLeftToRight);
        tbm.appendToGroup("merge", (IContributionItem)this._copySelLeftToRightItem);
        imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("copy_sel_left");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._CopySelectionToLeft);
        this._copyRightToLeft = new PTAbstractAction(toolTip, imgDesc, 1){

            @Override
            public void run() {
                PTContentMergeViewer.this.copyCurrent(false);
            }
        };
        this._copySelRightToLeftItem = new ActionContributionItem((IAction)this._copyRightToLeft);
        tbm.appendToGroup("merge", (IContributionItem)this._copySelRightToLeftItem);
        imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("next_diff");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._NextDifference);
        PTAbstractAction nextDifference = new PTAbstractAction(toolTip, imgDesc, 1){

            @Override
            public void run() {
                PTContentMergeViewer.this.navigate(true);
            }
        };
        tbm.appendToGroup("merge", (IAction)nextDifference);
        imgDesc = PTCompareUIPlugin.getDefault().getImageDescriptor("previous_diff");
        toolTip = PTCompareViewerLabel.getString(PTCompareViewerLabel._PreviousDifference);
        PTAbstractAction previousDifference = new PTAbstractAction(toolTip, imgDesc, 1){

            @Override
            public void run() {
                PTContentMergeViewer.this.navigate(false);
            }
        };
        tbm.appendToGroup("merge", (IAction)previousDifference);
    }

    public void redraw(boolean initCache) {
        if (this._comparisonKind == PTComparisonKind.ThreeWay) {
            this._ancestorPart.redraw(initCache);
        }
        this._leftPart.redraw(initCache);
        this._centerPart.redraw();
        this._rightPart.redraw(initCache);
    }

    protected void createControls(Composite parent) {
        this._ancestorPart = new PTContentMergePart(this, parent, PTPartSide.Ancestor);
        this._leftPart = new PTContentMergePart(this, parent, PTPartSide.Left);
        this._rightPart = new PTContentMergePart(this, parent, PTPartSide.Right);
        this._centerPart = new PTCenterCanvas(parent, this._leftPart, this._rightPart);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("line.light") || event.getProperty().equals("line.solid") || event.getProperty().equals("line.conflict.light") || event.getProperty().equals("line.conflict.solid")) {
                    PTContentMergeViewer.this.redraw(false);
                }
            }
        });
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        this._ancestorPart.setBounds(x, y, width, height);
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this._leftPart.setBounds(x, y, leftWidth - 17, height);
        this._centerPart.setBounds(leftWidth - 17, y, 34, height);
        this._rightPart.setBounds(x + leftWidth + 17, y, rightWidth - 17, height);
        this._leftPart.redraw(true);
        this._centerPart.redraw();
        this._rightPart.redraw(true);
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        _SWAPPED.equals(event.getProperty());
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        if (this.getComparisonSnapshot() == null) {
            return;
        }
    }

    protected void updateToolItems() {
        boolean rightEditable = this.getConfiguration().isRightEditable();
        boolean leftEditable = this.getConfiguration().isLeftEditable();
        this._copySelLeftToRightItem.setVisible(rightEditable);
        this._copySelLeftToRightItem.getAction().setEnabled(rightEditable);
        this._copySelRightToLeftItem.setVisible(leftEditable);
        this._copySelRightToLeftItem.getAction().setEnabled(leftEditable);
        super.updateToolItems();
    }

    protected void copy(boolean leftToRight) {
        if (this.getComparisonSnapshot().getChangeModel() == null) {
            return;
        }
        List allChanges = this.getComparisonSnapshot().getChangeModel().getContents();
        if (allChanges.size() == 0) {
            return;
        }
        List<ChangeElement> leafChanges = this.getComparisonSnapshot().getLeafChanges();
        int i = leafChanges.size() - 1;
        while (i >= 0) {
            ChangeElement change = leafChanges.get(i);
            if (!change.isConflicting()) {
                this.getMerger().copyChange(change, leftToRight);
            }
            --i;
        }
        this.getMerger().updateMatchModel();
        this.getMerger().updateChangeModel();
        this.getComparisonSnapshot().resetCache();
        this.getConfiguration().setProperty("structure.content", null);
        this.setSelectedChange(null);
        if (this._comparisonKind == PTComparisonKind.ThreeWay) {
            this._ancestorPart.setInput((EObject)this.getAncestorRoot());
            this._ancestorPart.redraw(true);
        }
        this._leftPart.setInput((EObject)this.getLeftRoot());
        this._leftPart.redraw(true);
        this._rightPart.setInput((EObject)this.getRightRoot());
        this._rightPart.redraw(true);
        this._centerPart.redraw();
        this.updateCopyState();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    private void select(ChangeElement change) {
        this._selectedChange = change;
        if (this._comparisonKind == PTComparisonKind.ThreeWay && this._ancestorPart != null) {
            this._ancestorPart.setSelection(this._selectedChange);
        }
        if (this._leftPart != null) {
            this._leftPart.setSelection(this._selectedChange);
        }
        if (this._rightPart != null) {
            this._rightPart.setSelection(this._selectedChange);
        }
        if (this.getCenterPart() != null) {
            this.getCenterPart().redraw();
        }
    }

    private void select(PTCompositionItem compositionItem) {
        if (this._comparisonKind == PTComparisonKind.ThreeWay && this._ancestorPart != null) {
            this._ancestorPart.setSelection(compositionItem);
        }
        if (this._leftPart != null) {
            this._leftPart.setSelection(compositionItem);
        }
        if (this._rightPart != null) {
            this._rightPart.setSelection(compositionItem);
        }
        if (this.getCenterPart() != null) {
            this.getCenterPart().redraw();
        }
    }

    private void select(EObject eObject, EAttribute eAttribute) {
        if (this._comparisonKind == PTComparisonKind.ThreeWay && this._ancestorPart != null) {
            this._ancestorPart.setSelection(eAttribute);
        }
        if (this._leftPart != null) {
            this._leftPart.setSelection(eAttribute);
        }
        if (this._rightPart != null) {
            this._rightPart.setSelection(eAttribute);
        }
        if (this.getCenterPart() != null) {
            this.getCenterPart().redraw();
        }
    }

    private void openChange(ChangeElement change) {
        if (change instanceof AttributeChange || change instanceof ReferenceChange) {
            if (this.getDisplayMode() == PTDisplayMode.Composition) {
                this.switchDisplayMode();
            }
        } else if (this.getDisplayMode() == PTDisplayMode.Attribute) {
            this.switchDisplayMode();
        }
        this._displayComposition.setChecked(this.getDisplayMode() == PTDisplayMode.Composition);
        this._displayAttribute.setChecked(this.getDisplayMode() == PTDisplayMode.Attribute);
    }

    private void switchDisplayMode() {
        PTContentMergePart[] pTContentMergePartArray = this.getParts();
        int n = pTContentMergePartArray.length;
        int n2 = 0;
        while (n2 < n) {
            PTContentMergePart part = pTContentMergePartArray[n2];
            if (this.getDisplayMode() == PTDisplayMode.Composition) {
                part.getPageBook().showPage(part.getAttributeViewer().getControl());
            } else if (this.getDisplayMode() == PTDisplayMode.Attribute) {
                part.getPageBook().showPage(part.getCompositionViewer().getControl());
            }
            ++n2;
        }
        if (this.getDisplayMode() == PTDisplayMode.Composition) {
            this._displayMode = PTDisplayMode.Attribute;
        } else if (this.getDisplayMode() == PTDisplayMode.Attribute) {
            this._displayMode = PTDisplayMode.Composition;
        }
        this.getCenterPart().redraw();
    }

    private void swapLeftRight() {
        if (this.getInput() instanceof PTWrapperInput) {
            PTWrapperInput compareInput = (PTWrapperInput)this.getInput();
            compareInput.swapLeftRight();
            this.setInput(compareInput);
            this.refresh();
            this.getCenterPart().redraw();
        }
    }

    private void copyCurrent(boolean leftToRight) {
        ChangeElement change = this.getSelectedChange();
        EObject eContainer = PTObjectUtils.getLeftContainer(change);
        if (leftToRight) {
            eContainer = PTObjectUtils.getRightContainer(change);
        }
        EReference eReference = PTObjectUtils.getEReference(change);
        boolean done = this.getMerger().copyChange(change, leftToRight);
        if (done) {
            if (eReference != null && (change instanceof ReferenceChange || change instanceof PendingReference)) {
                boolean threeWay = this._comparisonKind == PTComparisonKind.ThreeWay;
                this.getMerger().updateMatchModel(eContainer, eReference, threeWay);
            }
            this.getMerger().updateChangeModel(change);
        }
        this.getComparisonSnapshot().resetCache();
        this.getConfiguration().setProperty("structure.content", null);
        this.setSelectedChange(null);
        if (eReference != null && (change instanceof AttributeChange || change instanceof ReferenceChange || change instanceof ConflictChange || change instanceof PendingReference)) {
            if (leftToRight) {
                this._rightPart.getCompositionViewer().updateComposition(eContainer, eReference);
            } else {
                this._leftPart.getCompositionViewer().updateComposition(eContainer, eReference);
            }
        }
        this.redraw(true);
        this.updateCopyState();
    }

    private void navigate(boolean next) {
        ChangeModel changeModel = this.getComparisonSnapshot().getChangeModel();
        if (changeModel == null || changeModel.nbAllChanges() == 0) {
            return;
        }
        List allChanges = changeModel.getContents();
        if (allChanges.size() == 0) {
            return;
        }
        int anchorIndex = -1;
        anchorIndex = this.getSelectedChange() == null ? (next ? -1 : allChanges.size()) : allChanges.indexOf(this.getSelectedChange());
        if (next) {
            int i = anchorIndex + 1;
            while (i != anchorIndex) {
                ChangeElement change;
                if (i >= allChanges.size()) {
                    i = 0;
                }
                if ((change = (ChangeElement)allChanges.get(i)) instanceof FeatureChange || change instanceof PendingReference) {
                    this.getConfiguration().setProperty("structure.selection", (Object)change);
                    break;
                }
                ++i;
            }
        } else {
            int i = anchorIndex - 1;
            while (i != anchorIndex) {
                ChangeElement change;
                if (i < 0) {
                    i = allChanges.size() - 1;
                }
                if ((change = (ChangeElement)allChanges.get(i)) instanceof FeatureChange || change instanceof PendingReference) {
                    this.getConfiguration().setProperty("structure.selection", (Object)change);
                    break;
                }
                --i;
            }
        }
    }

    private void updateCopyState() {
        boolean enabled = false;
        ChangeElement change = this.getSelectedChange();
        if (change instanceof AttributeChange && !PTLabelFactory.isLockedFeature((EStructuralFeature)((AttributeChange)change).getAttribute())) {
            enabled = true;
        } else if (change instanceof ReferenceChange && !PTLabelFactory.isLockedFeature((EStructuralFeature)((ReferenceChange)change).getReference())) {
            enabled = true;
        } else if (change instanceof ConflictChange) {
            enabled = true;
        } else if (change instanceof PendingReference) {
            enabled = true;
        }
        if (this._copyLeftToRight != null) {
            this._copyLeftToRight.setEnabled(enabled);
        }
        if (this._copyRightToLeft != null) {
            this._copyRightToLeft.setEnabled(enabled);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        this.getConfiguration().removePropertyChangeListener((IPropertyChangeListener)this._propertyListener);
        this.getConfiguration().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this._preferencesListener);
        this.clearConfiguration();
        PTEditorService.removeNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getLeftRoot());
        PTEditorService.unregisterEditor((IPath)this.getResourcePath(PTPartSide.Left), (IPTEditor)this);
        PTEditorService.removeNotifyChangedListener((INotifyChangedListener)this.getNotifyChangeListener(), (RadicalEntity)this.getRightRoot());
        PTEditorService.unregisterEditor((IPath)this.getResourcePath(PTPartSide.Right), (IPTEditor)this);
        this._snapshot = null;
        this._leftPart.dispose();
        this._leftPart = null;
        this._rightPart.dispose();
        this._rightPart = null;
        this._ancestorPart.dispose();
        this._ancestorPart = null;
        this._centerPart.dispose();
        this._centerPart = null;
        super.handleDispose(event);
        this._isDisposed = true;
    }

    private void clearConfiguration() {
    }

    public IPTEditor.PTPartKind getPartKind() {
        return IPTEditor.PTPartKind.Editor;
    }

    public boolean isDirty(IPath relativePath) {
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Left))) {
            return this.isLeftDirty();
        }
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Right))) {
            return this.isRightDirty();
        }
        return false;
    }

    public void dirty(IPath relativePath, boolean dirty) {
        if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Left))) {
            this.setLeftDirty(dirty);
        } else if (relativePath.equals((Object)this.getResourcePath(PTPartSide.Right))) {
            this.setRightDirty(dirty);
        }
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public void synchronize(IPath relativePath) {
        System.out.println("synchronize: " + relativePath);
    }

    private class ConfigurationPropertyListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("structure.selection")) {
                if (event.getNewValue() instanceof ChangeElement) {
                    if (event.getNewValue() != event.getOldValue()) {
                        PTContentMergeViewer.this.select((ChangeElement)event.getNewValue());
                    }
                } else {
                    PTContentMergeViewer.this.select(null);
                }
                PTContentMergeViewer.this.updateCopyState();
            } else if (event.getProperty().equals("structure.open")) {
                if (event.getNewValue() instanceof ChangeElement) {
                    PTContentMergeViewer.this.openChange((ChangeElement)event.getNewValue());
                }
            } else if (event.getProperty().equals("composition.selection")) {
                if (event.getNewValue() instanceof PTCompositionItem) {
                    if (event.getNewValue() != event.getOldValue()) {
                        PTCompositionItem compositionItem = (PTCompositionItem)event.getNewValue();
                        ChangeElement change = PTContentMergeViewer.this.getComparisonSnapshot().getChange(compositionItem.getEObject(), null);
                        PTContentMergeViewer.this.getConfiguration().setProperty("structure.selection", (Object)change);
                        if (change == null) {
                            PTContentMergeViewer.this.select(compositionItem);
                        }
                    }
                } else {
                    PTContentMergeViewer.this.select(null);
                }
                PTContentMergeViewer.this.updateCopyState();
            } else if (event.getProperty().equals("attribute.selection")) {
                if (event.getNewValue() instanceof EObject[]) {
                    if (event.getNewValue() != event.getOldValue()) {
                        EObject[] array = (EObject[])event.getNewValue();
                        EObject eObject = array[0];
                        EAttribute eAttribute = (EAttribute)array[1];
                        ChangeElement change = PTContentMergeViewer.this.getComparisonSnapshot().getChange(eObject, eAttribute);
                        PTContentMergeViewer.this.getConfiguration().setProperty("structure.selection", (Object)change);
                        if (change == null) {
                            PTContentMergeViewer.this.select(eObject, eAttribute);
                        }
                    }
                } else {
                    PTContentMergeViewer.this.select(null, null);
                }
                PTContentMergeViewer.this.updateCopyState();
            }
        }
    }

    private class NotifyChangeListener
    implements INotifyChangedListener {
        public void notifyChanged(Notification notification) {
            PTContentMerger merger = new PTContentMerger(PTContentMergeViewer.this.getComparisonSnapshot());
            merger.merge(notification);
        }
    }

    private class PreferencesPropertyListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            PTContentMergeViewer.this.handlePropertyChangeEvent(event);
        }
    }
}

