/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.internal;

import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeFactory;
import com.ibm.pdp.mdl.compare.change.ChangeGroup;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.text.IDocument;

public final class PTTextMerger {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTComparisonSnapshot _snapshot;
    private ChangeGroup _changeGroup;
    private AdapterFactoryEditingDomain _leftEditingDomain;
    private AdapterFactoryEditingDomain _rightEditingDomain;
    EAttribute _eAttribute = PacbasePackage.eINSTANCE.getPacMacro_Source();

    public PTTextMerger(PTComparisonSnapshot snapshot) {
        this._snapshot = snapshot;
    }

    private AdapterFactoryEditingDomain getLeftEditingDomain() {
        if (this._leftEditingDomain == null) {
            RadicalEntity radicalObject = (RadicalEntity)this._snapshot.getMatchModel().getLeftRoot();
            IPath path = radicalObject.getPath(radicalObject.getProject());
            this._leftEditingDomain = PTEditorService.getEditingDomain((IPath)path);
        }
        return this._leftEditingDomain;
    }

    private AdapterFactoryEditingDomain getRightEditingDomain() {
        if (this._rightEditingDomain == null) {
            RadicalEntity radicalObject = (RadicalEntity)this._snapshot.getMatchModel().getRightRoot();
            IPath path = radicalObject.getPath(radicalObject.getProject());
            this._rightEditingDomain = PTEditorService.getEditingDomain((IPath)path);
        }
        return this._rightEditingDomain;
    }

    public void copyChange(IDocument leftDocument, IDocument rightDocument, boolean leftToRight) {
        AdapterFactoryEditingDomain editingDomain = this.getLeftEditingDomain();
        if (leftToRight) {
            editingDomain = this.getRightEditingDomain();
        }
        if (editingDomain == null) {
            return;
        }
        AttributeChange attChange = this.getAttributeChange();
        if (attChange == null) {
            return;
        }
        EObject eTarget = attChange.getLeftObject();
        String value = leftDocument.get();
        if (leftToRight) {
            eTarget = attChange.getRightObject();
            value = rightDocument.get();
        }
        this.setCommand(editingDomain, eTarget, (EStructuralFeature)attChange.getAttribute(), value);
    }

    private AttributeChange getAttributeChange() {
        ChangeGroup changeGroup = this.getChangeGroup();
        int i = 0;
        while (i < changeGroup.getChangeElements().size()) {
            AttributeChange attChange;
            ChangeElement change = (ChangeElement)changeGroup.getChangeElements().get(i);
            if (change instanceof AttributeChange && (attChange = (AttributeChange)change).getAttribute() == this._eAttribute) {
                return attChange;
            }
            ++i;
        }
        return null;
    }

    public void setAttribute(EAttribute eAttribute) {
        this._eAttribute = eAttribute;
    }

    public void setChangeGroup(ChangeGroup changeGroup) {
        this._changeGroup = changeGroup;
    }

    public boolean removeAttributeChange() {
        AttributeChange attChange = this.getAttributeChange();
        if (attChange != null) {
            ChangeGroup changeGroup = this._snapshot.getChangeModel().getChangeGroup();
            changeGroup.getChangeElements().remove(attChange);
            return true;
        }
        return false;
    }

    public boolean addAttributeChange() {
        AttributeChange attChange = this.getAttributeChange();
        if (attChange == null) {
            MatchModel matchModel = this._snapshot.getMatchModel();
            attChange = ChangeFactory.eINSTANCE.createAttributeChange();
            attChange.setLeftObject(matchModel.getLeftRoot());
            attChange.setRightObject(matchModel.getRightRoot());
            attChange.setAttribute(this._eAttribute);
            attChange.setRemote(false);
            ChangeGroup changeGroup = this.getChangeGroup();
            attChange.setParent((ChangeElement)changeGroup);
            changeGroup.getChangeElements().add(attChange);
            return true;
        }
        return false;
    }

    public void merge(Notification notification) {
    }

    private void setCommand(AdapterFactoryEditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature != null) {
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value);
            editingDomain.getCommandStack().execute(command);
        }
    }

    private ChangeGroup getChangeGroup() {
        return this._changeGroup == null ? this._snapshot.getChangeModel().getChangeGroup() : this._changeGroup;
    }
}

