/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.internal;

import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ConflictAttributeChange;
import com.ibm.pdp.mdl.compare.change.ConflictChange;
import com.ibm.pdp.mdl.compare.change.ConflictReferenceChange;
import com.ibm.pdp.mdl.compare.change.FeatureChange;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class PTObjectUtils {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private PTObjectUtils() {
    }

    public static EObject getAncestorObject(PTComparisonSnapshot snapshot, ChangeElement change) {
        EObject eObject = null;
        if (change instanceof AttributeChange) {
            if (change instanceof ConflictAttributeChange) {
                eObject = ((ConflictAttributeChange)change).getAncestorObject();
            } else {
                EObject eLeftObject = ((AttributeChange)change).getLeftObject();
                Object matching = snapshot.getMatching(eLeftObject);
                if (matching instanceof Matching3Way) {
                    eObject = ((Matching3Way)matching).getAncestorObject();
                }
            }
        } else if (change instanceof ReferenceChange) {
            if (change instanceof ConflictReferenceChange) {
                EObject eContainer = ((ConflictReferenceChange)change).getAncestorObject();
                eObject = (EObject)eContainer.eGet((EStructuralFeature)((ConflictReferenceChange)change).getReference());
            } else {
                EObject eLeftObject = ((ReferenceChange)change).getLeftObject();
                Object matching = snapshot.getMatching(eLeftObject);
                if (matching instanceof Matching3Way) {
                    EObject eContainer = ((Matching3Way)matching).getAncestorObject();
                    eObject = (EObject)eContainer.eGet((EStructuralFeature)((ReferenceChange)change).getReference());
                }
            }
        } else if (change instanceof ConflictChange) {
            eObject = ((ConflictChange)change).getAncestorObject();
        }
        return eObject;
    }

    public static EObject getAncestorContainer(PTComparisonSnapshot snapshot, ChangeElement change) {
        EObject eContainer = null;
        Object matching = null;
        if (change instanceof AttributeChange) {
            EObject eLeftObject = ((AttributeChange)change).getLeftObject();
            matching = snapshot.getMatching(eLeftObject.eContainer());
        } else if (change instanceof ReferenceChange) {
            EObject eLeftObject = ((ReferenceChange)change).getLeftObject();
            matching = snapshot.getMatching(eLeftObject);
        } else if (change instanceof ConflictChange) {
            EObject eLeftObject = ((ConflictChange)change).getLeftObject();
            matching = snapshot.getMatching(eLeftObject.eContainer());
        } else if (change instanceof LeftPending) {
            EObject eLeftObject = ((LeftPending)change).getLeftObject();
            matching = snapshot.getMatching(eLeftObject.eContainer());
        } else if (change instanceof RightPending) {
            EObject eRightObject = ((RightPending)change).getRightObject();
            matching = snapshot.getMatching(eRightObject.eContainer());
        }
        if (matching instanceof Matching3Way) {
            eContainer = ((Matching3Way)matching).getAncestorObject();
        }
        return eContainer;
    }

    public static EObject getLeftObject(ChangeElement change) {
        EObject eObject = null;
        if (change instanceof FeatureChange) {
            EObject calledObject;
            eObject = ((FeatureChange)change).getLeftObject();
            if (change instanceof ReferenceChange && (calledObject = (EObject)eObject.eGet((EStructuralFeature)((ReferenceChange)change).getReference())) instanceof RadicalEntity) {
                eObject = calledObject;
            }
        } else if (change instanceof LeftPending) {
            eObject = ((LeftPending)change).getLeftObject();
        }
        return eObject;
    }

    public static EObject getLeftContainer(ChangeElement change) {
        EObject eContainer = null;
        if (change instanceof ReferenceChange) {
            eContainer = ((ReferenceChange)change).getLeftObject();
        } else if (change instanceof PendingReference) {
            eContainer = ((PendingReference)change).getLeftContainer();
        } else {
            EObject eObject = PTObjectUtils.getLeftObject(change);
            if (eObject != null) {
                eContainer = eObject.eContainer();
            }
        }
        return eContainer;
    }

    public static EObject getRightObject(ChangeElement change) {
        EObject eObject = null;
        if (change instanceof FeatureChange) {
            EObject calledObject;
            eObject = ((FeatureChange)change).getRightObject();
            if (change instanceof ReferenceChange && (calledObject = (EObject)eObject.eGet((EStructuralFeature)((ReferenceChange)change).getReference())) instanceof RadicalEntity) {
                eObject = calledObject;
            }
        } else if (change instanceof RightPending) {
            eObject = ((RightPending)change).getRightObject();
        }
        return eObject;
    }

    public static EObject getRightContainer(ChangeElement change) {
        EObject eContainer = null;
        if (change instanceof ReferenceChange) {
            eContainer = ((ReferenceChange)change).getRightObject();
        } else if (change instanceof PendingReference) {
            eContainer = ((PendingReference)change).getRightContainer();
        } else {
            EObject eObject = PTObjectUtils.getRightObject(change);
            if (eObject != null) {
                eContainer = eObject.eContainer();
            }
        }
        return eContainer;
    }

    public static EReference getEReference(ChangeElement change) {
        EReference eReference = null;
        if (change instanceof AttributeChange) {
            EObject eLeftObject = ((AttributeChange)change).getLeftObject();
            eReference = eLeftObject.eContainmentFeature();
        } else if (change instanceof ReferenceChange) {
            eReference = ((ReferenceChange)change).getReference();
        } else if (change instanceof ConflictChange) {
            EObject eLeftObject = ((ConflictChange)change).getLeftObject();
            eReference = eLeftObject.eContainmentFeature();
        } else if (change instanceof PendingReference) {
            eReference = ((PendingReference)change).getReference();
        }
        return eReference;
    }

    public static EObject getLeftAnchor(ChangeElement change) {
        EObject eAnchor = null;
        if (change instanceof FeatureChange) {
            eAnchor = ((FeatureChange)change).getLeftObject();
        } else if (change instanceof LeftPending) {
            eAnchor = ((LeftPending)change).getLeftObject();
        } else if (change instanceof RightPending) {
            eAnchor = ((RightPending)change).getLeftAnchor();
        }
        return eAnchor;
    }

    public static EObject getRightAnchor(ChangeElement change) {
        EObject eAnchor = null;
        if (change instanceof FeatureChange) {
            eAnchor = ((FeatureChange)change).getRightObject();
        } else if (change instanceof LeftPending) {
            eAnchor = ((LeftPending)change).getRightAnchor();
        } else if (change instanceof RightPending) {
            eAnchor = ((RightPending)change).getRightObject();
        }
        return eAnchor;
    }

    public static EObject getAncestorAnchor(ChangeElement change) {
        EObject eAnchor = null;
        if (change instanceof ConflictAttributeChange) {
            eAnchor = ((ConflictAttributeChange)change).getAncestorObject();
        } else if (change instanceof LeftPending) {
            eAnchor = ((LeftPending)change).getAncestorAnchor();
        } else if (change instanceof RightPending) {
            eAnchor = ((RightPending)change).getAncestorAnchor();
        }
        return eAnchor;
    }

    public static List<EObject> getHierarchy(EObject eObject, EReference eReference, EObject eContainer) {
        ArrayList<EObject> hierarchy = new ArrayList<EObject>();
        if (eObject != null) {
            hierarchy.add(eObject);
        }
        if (eReference != null && eContainer != null) {
            hierarchy.add((EObject)eReference);
            hierarchy.add(eContainer);
            eObject = eContainer;
        }
        eContainer = eObject.eContainer();
        while (eContainer != null) {
            eReference = eObject.eContainmentFeature();
            Object containment = eContainer.eGet((EStructuralFeature)eReference);
            if (containment instanceof EList) {
                hierarchy.add((EObject)eReference);
            }
            hierarchy.add(eContainer);
            eObject = eContainer;
            eContainer = eObject.eContainer();
        }
        return hierarchy;
    }
}

