/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.internal;

import com.ibm.pdp.compare.differencer.PTDifferencer;
import com.ibm.pdp.compare.matcher.PTMatcher;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeModel;
import com.ibm.pdp.mdl.compare.change.ConflictChange;
import com.ibm.pdp.mdl.compare.change.FeatureChange;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class PTContentMerger {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTComparisonSnapshot _snapshot;
    private AdapterFactoryEditingDomain _leftEditingDomain;
    private AdapterFactoryEditingDomain _rightEditingDomain;

    private static EObject duplicate(EObject eSource) {
        if (eSource == null || eSource instanceof RadicalEntity) {
            return eSource;
        }
        EObject eTarget = null;
        EClass eClass = eSource.eClass();
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        eTarget = eFactory.create(eClass);
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            Object sourceValue = eSource.eGet((EStructuralFeature)eAttribute);
            eTarget.eSet((EStructuralFeature)eAttribute, sourceValue);
        }
        for (EReference eReference : eClass.getEAllReferences()) {
            if (!eReference.isChangeable()) continue;
            Object sourceObject = eSource.eGet((EStructuralFeature)eReference);
            Object targetObject = eTarget.eGet((EStructuralFeature)eReference);
            if (sourceObject instanceof List && targetObject instanceof List) {
                List sourceList = (List)sourceObject;
                List targetList = (List)targetObject;
                Iterator iterator = sourceList.iterator();
                while (iterator.hasNext()) {
                    Object sourceItem;
                    Object targetItem = sourceItem = iterator.next();
                    if (sourceItem instanceof EObject && !(sourceItem instanceof RadicalEntity)) {
                        targetItem = PTContentMerger.duplicate((EObject)sourceItem);
                    }
                    targetList.add(targetItem);
                }
                continue;
            }
            targetObject = sourceObject;
            if (sourceObject instanceof EObject && !(sourceObject instanceof RadicalEntity)) {
                targetObject = PTContentMerger.duplicate((EObject)sourceObject);
            }
            eTarget.eSet((EStructuralFeature)eReference, targetObject);
        }
        return eTarget;
    }

    public PTContentMerger(PTComparisonSnapshot snapshot) {
        this._snapshot = snapshot;
    }

    private AdapterFactoryEditingDomain getLeftEditingDomain() {
        if (this._leftEditingDomain == null) {
            RadicalEntity radicalObject = (RadicalEntity)this._snapshot.getMatchModel().getLeftRoot();
            IPath path = radicalObject.getPath(radicalObject.getProject());
            this._leftEditingDomain = PTEditorService.getEditingDomain((IPath)path);
        }
        return this._leftEditingDomain;
    }

    private AdapterFactoryEditingDomain getRightEditingDomain() {
        if (this._rightEditingDomain == null) {
            RadicalEntity radicalObject = (RadicalEntity)this._snapshot.getMatchModel().getRightRoot();
            IPath path = radicalObject.getPath(radicalObject.getProject());
            this._rightEditingDomain = PTEditorService.getEditingDomain((IPath)path);
        }
        return this._rightEditingDomain;
    }

    public boolean copyChange(ChangeElement change, boolean leftToRight) {
        AdapterFactoryEditingDomain editingDomain = this.getLeftEditingDomain();
        if (leftToRight) {
            editingDomain = this.getRightEditingDomain();
        }
        if (editingDomain == null) {
            return false;
        }
        if (change instanceof FeatureChange) {
            if (change instanceof ConflictChange) {
                ConflictChange conflictChange = (ConflictChange)change;
                EObject leftObject = conflictChange.getLeftObject();
                List leftList = (List)leftObject.eContainer().eGet((EStructuralFeature)leftObject.eContainmentFeature());
                int leftIndex = leftList.indexOf(leftObject);
                EObject rightObject = conflictChange.getRightObject();
                List rightList = (List)rightObject.eContainer().eGet((EStructuralFeature)rightObject.eContainmentFeature());
                int rightIndex = rightList.indexOf(rightObject);
                if (leftIndex >= 0 && rightIndex >= 0 && leftIndex != rightIndex) {
                    EReference eReference = conflictChange.getLeftObject().eContainmentFeature();
                    EObject eTarget = conflictChange.getLeftObject().eContainer();
                    EObject value = conflictChange.getLeftObject();
                    int rank = rightIndex;
                    if (leftToRight) {
                        eTarget = conflictChange.getRightObject().eContainer();
                        value = conflictChange.getRightObject();
                        rank = leftIndex;
                    }
                    this.moveCommand(editingDomain, eTarget, (EStructuralFeature)eReference, value, rank);
                }
            } else if (change instanceof AttributeChange) {
                AttributeChange attChange = (AttributeChange)change;
                if (PTLabelFactory.isLockedFeature((EStructuralFeature)attChange.getAttribute())) {
                    return false;
                }
                EObject eTarget = attChange.getLeftObject();
                Object value = attChange.getRightObject().eGet((EStructuralFeature)attChange.getAttribute());
                if (leftToRight) {
                    eTarget = attChange.getRightObject();
                    value = attChange.getLeftObject().eGet((EStructuralFeature)attChange.getAttribute());
                }
                this.setCommand(editingDomain, eTarget, (EStructuralFeature)attChange.getAttribute(), value);
            } else if (change instanceof ReferenceChange) {
                ReferenceChange refChange = (ReferenceChange)change;
                if (PTLabelFactory.isLockedFeature((EStructuralFeature)refChange.getReference())) {
                    return false;
                }
                EObject eTarget = refChange.getLeftObject();
                Object value = refChange.getRightObject().eGet((EStructuralFeature)refChange.getReference());
                if (leftToRight) {
                    eTarget = refChange.getRightObject();
                    value = refChange.getLeftObject().eGet((EStructuralFeature)refChange.getReference());
                }
                if (value instanceof EObject) {
                    value = PTContentMerger.duplicate((EObject)value);
                }
                this.setCommand(editingDomain, eTarget, (EStructuralFeature)refChange.getReference(), value);
            }
        } else if (change instanceof PendingReference) {
            PendingReference pendingReference = (PendingReference)change;
            EReference eReference = PTObjectUtils.getEReference(change);
            if (pendingReference instanceof LeftPending) {
                LeftPending leftPending = (LeftPending)pendingReference;
                if (leftToRight) {
                    EObject eTarget = leftPending.getRightContainer();
                    EObject eValue = leftPending.getLeftObject();
                    List targetList = (List)eTarget.eGet((EStructuralFeature)eReference);
                    int index = Math.max(-1, targetList.indexOf(leftPending.getRightAnchor()));
                    this.addCommand(editingDomain, eTarget, (EStructuralFeature)eReference, PTContentMerger.duplicate(eValue), index + 1);
                } else {
                    EObject eTarget = leftPending.getLeftContainer();
                    this.removeCommand(editingDomain, eTarget, (EStructuralFeature)eReference, leftPending.getLeftObject());
                }
            } else if (pendingReference instanceof RightPending) {
                RightPending rightPending = (RightPending)pendingReference;
                if (leftToRight) {
                    EObject eTarget = rightPending.getRightContainer();
                    this.removeCommand(editingDomain, eTarget, (EStructuralFeature)eReference, rightPending.getRightObject());
                } else {
                    EObject eTarget = rightPending.getLeftContainer();
                    EObject eValue = rightPending.getRightObject();
                    List targetList = (List)eTarget.eGet((EStructuralFeature)eReference);
                    int index = Math.max(-1, targetList.indexOf(rightPending.getLeftAnchor()));
                    this.addCommand(editingDomain, eTarget, (EStructuralFeature)eReference, PTContentMerger.duplicate(eValue), index + 1);
                }
            }
        }
        return true;
    }

    public void updateMatchModel() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            MatchModel matchModel = this._snapshot.getMatchModel();
            PTMatcher matcher = new PTMatcher();
            matchModel = matchModel.getAncestorRoot() == null ? matcher.doMatch(matchModel.getLeftRoot(), matchModel.getRightRoot(), (IProgressMonitor)monitor) : matcher.doMatch(matchModel.getLeftRoot(), matchModel.getRightRoot(), matchModel.getAncestorRoot(), (IProgressMonitor)monitor);
            this._snapshot.setMatchModel(matchModel);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void updateChangeModel() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            MatchModel matchModel = this._snapshot.getMatchModel();
            if (matchModel != null) {
                PTDifferencer differencer = new PTDifferencer();
                boolean threeWay = matchModel.getAncestorRoot() != null;
                ChangeModel changeModel = differencer.doDiff(matchModel, threeWay, (IProgressMonitor)monitor);
                this._snapshot.setChangeModel(changeModel);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void updateMatchModel(EObject eObject, EReference eReference, boolean threeWay) {
        PTMatcher matcher = new PTMatcher();
        Object object = this._snapshot.getMatching(eObject);
        if (object instanceof Matching) {
            matcher.mergeMatch(this._snapshot.getMatchModel(), (Matching)object, eReference, threeWay);
        }
    }

    public void updateChangeModel(ChangeElement change) {
        if (change instanceof PendingReference) {
            PendingReference pendingChange = (PendingReference)change;
            Object object = this._snapshot.getMatching(pendingChange.getLeftContainer());
            if (object instanceof Matching) {
                PTDifferencer differencer = new PTDifferencer();
                Matching matching = (Matching)object;
                differencer.mergeDiff(this._snapshot.getMatchModel(), this._snapshot.getChangeModel(), matching, pendingChange);
            }
        } else {
            ChangeElement parent = change.getParent();
            while (parent != null) {
                parent.getChangeElements().remove(change);
                if (parent.getChangeElements().size() > 0) break;
                change = parent;
                parent = change.getParent();
            }
        }
    }

    public void merge(Notification notification) {
    }

    private void setCommand(AdapterFactoryEditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature != null) {
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value);
            editingDomain.getCommandStack().execute(command);
        }
    }

    private void addCommand(AdapterFactoryEditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value, int index) {
        if (feature != null) {
            Command command = AddCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value, (int)index);
            editingDomain.getCommandStack().execute(command);
        }
    }

    private void removeCommand(AdapterFactoryEditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature != null) {
            Command command = RemoveCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value);
            editingDomain.getCommandStack().execute(command);
        }
    }

    public void moveCommand(AdapterFactoryEditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value, int rank) {
        if (feature != null) {
            Command command = MoveCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value, (int)rank);
            editingDomain.getCommandStack().execute(command);
        }
    }
}

