/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public final class PTAdapterUtils {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ComposedAdapterFactory _FACTORY;

    private PTAdapterUtils() {
    }

    public static AdapterFactory getAdapterFactory() {
        if (_FACTORY == null) {
            ArrayList<Object> factories = new ArrayList<Object>();
            factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            factories.add(new ReflectiveItemProviderAdapterFactory());
            _FACTORY = new ComposedAdapterFactory(factories);
        }
        return _FACTORY;
    }

    public static <T> T adapt(EObject eObj, Class<? extends T> type) {
        return (T)PTAdapterUtils.getAdapterFactory().adapt((Notifier)eObj, type);
    }

    public static Object getItemProviderImage(EObject eObj) {
        IItemLabelProvider labelProvider = PTAdapterUtils.adapt(eObj, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getImage((Object)eObj);
        }
        return null;
    }

    public static String getItemProviderText(EObject eObj) {
        IItemLabelProvider labelProvider = PTAdapterUtils.adapt(eObj, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText((Object)eObj);
        }
        return "?";
    }
}

