/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.engine;

import com.ibm.pdp.compare.PTPartSide;
import com.ibm.pdp.compare.ui.internal.PTObjectUtils;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeModel;
import com.ibm.pdp.mdl.compare.change.FeatureChange;
import com.ibm.pdp.mdl.compare.change.PendingReference;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.compare.match.Matching;
import com.ibm.pdp.mdl.compare.match.Matching3Way;
import com.ibm.pdp.mdl.compare.match.Unmatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;

public final class PTComparisonSnapshot {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date _date;
    private MatchModel _matchModel;
    private ChangeModel _changeModel;
    private Map<EObject, Object> _cachedMatchings;
    private List<ChangeElement> _leafChanges;

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public MatchModel getMatchModel() {
        return this._matchModel;
    }

    public void setMatchModel(MatchModel matchModel) {
        this._matchModel = matchModel;
    }

    public ChangeModel getChangeModel() {
        return this._changeModel;
    }

    public void setChangeModel(ChangeModel value) {
        this._changeModel = value;
    }

    public Object getMatching(EObject eObject) {
        if (this.getMatchModel() == null || this.getMatchModel().getMatching() == null) {
            return null;
        }
        return this.getCachedMatchings().get(eObject);
    }

    public EObject getMatchedObject(EObject eObject, PTPartSide partSide) {
        EObject eMatchedObject = null;
        Object object = this.getMatching(eObject);
        if (object instanceof Matching) {
            if (partSide == PTPartSide.Ancestor) {
                if (object instanceof Matching3Way) {
                    eMatchedObject = ((Matching3Way)object).getAncestorObject();
                }
            } else if (partSide == PTPartSide.Left) {
                eMatchedObject = ((Matching)object).getLeftObject();
            } else if (partSide == PTPartSide.Right) {
                eMatchedObject = ((Matching)object).getRightObject();
            }
        }
        return eMatchedObject;
    }

    private Map<EObject, Object> getCachedMatchings() {
        if (this._cachedMatchings == null) {
            this._cachedMatchings = new HashMap<EObject, Object>();
            ArrayList<Matching> matchings = new ArrayList<Matching>(1);
            matchings.add(this.getMatchModel().getMatching());
            this.doRecursiveMatchingCache(matchings);
            List unmatches = this.getMatchModel().getUnmatches();
            Unmatch[] unmatchArray = unmatches.toArray(new Unmatch[unmatches.size()]);
            int n = unmatchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unmatch unmatch = unmatchArray[n2];
                if (this._cachedMatchings.containsKey(unmatch.getObject())) {
                    unmatches.remove(unmatch);
                } else {
                    this._cachedMatchings.put(unmatch.getObject(), unmatch);
                }
                ++n2;
            }
        }
        return this._cachedMatchings;
    }

    public ChangeElement getChange(EObject eObject, EAttribute eAttribute) {
        if (eObject == null) {
            return null;
        }
        ChangeElement change = null;
        for (ChangeElement leafChange : this.getLeafChanges()) {
            if (PTObjectUtils.getAncestorObject(this, leafChange) == eObject) {
                if (eAttribute != null && leafChange instanceof AttributeChange) {
                    if (((AttributeChange)leafChange).getAttribute() == eAttribute) {
                        change = leafChange;
                    }
                } else {
                    change = leafChange;
                }
            } else if (PTObjectUtils.getLeftObject(leafChange) == eObject) {
                if (eAttribute != null && leafChange instanceof AttributeChange) {
                    if (((AttributeChange)leafChange).getAttribute() == eAttribute) {
                        change = leafChange;
                    }
                } else {
                    change = leafChange;
                }
            } else if (PTObjectUtils.getRightObject(leafChange) == eObject) {
                if (eAttribute != null && leafChange instanceof AttributeChange) {
                    if (((AttributeChange)leafChange).getAttribute() == eAttribute) {
                        change = leafChange;
                    }
                } else {
                    change = leafChange;
                }
            }
            if (change != null) break;
        }
        return change;
    }

    private void doRecursiveMatchingCache(List<Matching> matchings) {
        for (Matching matching : matchings) {
            this._cachedMatchings.put(matching.getLeftObject(), matching);
            this._cachedMatchings.put(matching.getRightObject(), matching);
            if (matching instanceof Matching3Way) {
                Matching3Way matching3Way = (Matching3Way)matching;
                this._cachedMatchings.put(matching3Way.getAncestorObject(), matching);
            }
            this.doRecursiveMatchingCache(matching.getMatchings());
        }
    }

    public List<ChangeElement> getLeafChanges() {
        if (this._leafChanges == null) {
            this._leafChanges = new ArrayList<ChangeElement>();
            if (this.getChangeModel() == null) {
                return this._leafChanges;
            }
            List allChanges = this.getChangeModel().getContents();
            for (ChangeElement changeElement : allChanges) {
                if (!(changeElement instanceof FeatureChange) && !(changeElement instanceof PendingReference)) continue;
                this._leafChanges.add(changeElement);
            }
        }
        return this._leafChanges;
    }

    public void resetCache() {
        this._cachedMatchings = null;
        this._leafChanges = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("date: ");
        buffer.append(this.getDate());
        return buffer.toString();
    }
}

