/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.engine;

import com.ibm.pdp.compare.differencer.PTDifferencer;
import com.ibm.pdp.compare.matcher.PTMatcher;
import com.ibm.pdp.compare.ui.engine.PTComparisonSnapshot;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.mdl.compare.change.ChangeModel;
import com.ibm.pdp.mdl.compare.match.MatchModel;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public final class PTCompareEngine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static PTCompareEngine _INSTANCE;
    private PTComparisonSnapshot _snapshot;
    private ITypedElement _leftElement;
    private ITypedElement _rightElement;
    private ITypedElement _ancestorElement;
    private EObject _eLeftObject;
    private EObject _eRightObject;
    private EObject _eAncestorObject;

    public static PTCompareEngine getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new PTCompareEngine();
        }
        return _INSTANCE;
    }

    private PTCompareEngine() {
    }

    public PTComparisonSnapshot doCompare(final ICompareInput compareInput) {
        this._snapshot = new PTComparisonSnapshot();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    PTCompareEngine.this.loadResources(compareInput);
                    MatchModel matchModel = null;
                    PTMatcher matcher = new PTMatcher();
                    matchModel = PTCompareEngine.this._eAncestorObject == null ? matcher.doMatch(PTCompareEngine.this._eLeftObject, PTCompareEngine.this._eRightObject, monitor) : matcher.doMatch(PTCompareEngine.this._eLeftObject, PTCompareEngine.this._eRightObject, PTCompareEngine.this._eAncestorObject, monitor);
                    PTCompareEngine.this._snapshot.setMatchModel(matchModel);
                    ChangeModel changeModel = null;
                    if (matchModel != null && matchModel.getMatching() != null) {
                        PTDifferencer differencer = new PTDifferencer();
                        boolean threeWay = PTCompareEngine.this._eAncestorObject != null;
                        changeModel = differencer.doDiff(matchModel, threeWay, monitor);
                        PTCompareEngine.this._snapshot.setChangeModel(changeModel);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PTMessageManager.handleStackTrace((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        Date end = Calendar.getInstance().getTime();
        this._snapshot.setDate(end);
        return this._snapshot;
    }

    public void clear() {
        this._snapshot = null;
        this._leftElement = null;
        this._rightElement = null;
        this._ancestorElement = null;
        this._eLeftObject = null;
        this._eRightObject = null;
        this._eAncestorObject = null;
    }

    private void loadResources(ICompareInput compareInput) {
        if (this._leftElement != compareInput.getLeft() || this._rightElement != compareInput.getRight() || this._ancestorElement != compareInput.getAncestor()) {
            if (this._leftElement != compareInput.getLeft()) {
                this._leftElement = compareInput.getLeft();
                try {
                    this._eLeftObject = this.loadResource(this._leftElement);
                }
                catch (Exception exception) {}
            }
            if (this._rightElement != compareInput.getRight()) {
                this._rightElement = compareInput.getRight();
                try {
                    this._eRightObject = this.loadResource(this._rightElement);
                }
                catch (Exception exception) {}
            }
            if (this._ancestorElement != compareInput.getAncestor()) {
                this._ancestorElement = compareInput.getAncestor();
                try {
                    this._eAncestorObject = this.loadResource(this._ancestorElement);
                }
                catch (Exception exception) {}
            }
        }
    }

    private EObject loadResource(ITypedElement typedElement) throws IOException, CoreException {
        RadicalEntity eObject = null;
        if (typedElement instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)typedElement;
            IResource resource = resourceProvider.getResource();
            eObject = PTEditorService.getSharedResource((IPath)resource.getFullPath());
            if (eObject == null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toOSString(), (boolean)true);
                Resource modelResource = resourceSet.createResource(uri);
                Util.addRppSpecificEmfOptions((Map)((XMIResource)resource).getDefaultLoadOptions());
                modelResource.load(Collections.emptyMap());
                if (modelResource.getContents().size() > 0) {
                    eObject = (EObject)modelResource.getContents().get(0);
                }
            }
        } else if (typedElement instanceof IStreamContentAccessor) {
            IStreamContentAccessor accessor = (IStreamContentAccessor)typedElement;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createURI((String)typedElement.getName());
            Resource resource = resourceSet.createResource(uri);
            Util.addRppSpecificEmfOptions((Map)((XMIResource)resource).getDefaultLoadOptions());
            resource.load(accessor.getContents(), Collections.emptyMap());
            if (resource.getContents().size() > 0) {
                eObject = (EObject)resource.getContents().get(0);
            }
        }
        return eObject;
    }
}

