/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.editor;

import com.ibm.pdp.compare.ui.editor.PTCompareEditorLabel;
import com.ibm.pdp.compare.ui.editor.PTMasterInput;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class PTCompareEditorInput2
extends SaveableCompareEditorInput {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFile _leftFile;
    private IFile _rightFile;

    public PTCompareEditorInput2(IWorkbenchPage page, IFile leftFile, IFile rightFile) {
        super(new CompareConfiguration(), page);
        this._leftFile = leftFile;
        this._rightFile = rightFile;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ITypedElement left = PTCompareEditorInput2.createFileElement((IFile)this._leftFile);
        ITypedElement right = PTCompareEditorInput2.createFileElement((IFile)this._rightFile);
        PTMasterInput compareInput = new PTMasterInput(left, right);
        this.getCompareConfiguration().setLeftEditable(false);
        this.getCompareConfiguration().setRightEditable(true);
        this.initLabels();
        return compareInput;
    }

    private void initLabels() {
        Object[] left = new String[]{this._leftFile.getFullPath().makeRelative().toString()};
        String leftLabel = PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorLeftTitle, left);
        Object[] right = new String[]{this._rightFile.getFullPath().makeRelative().toString()};
        String rightLabel = PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorRightTitle, right);
        this.getCompareConfiguration().setLeftLabel(leftLabel);
        this.getCompareConfiguration().setRightLabel(rightLabel);
    }

    protected void fireInputChange() {
    }

    public String getTitle() {
        return PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorTitle, this.getLabels());
    }

    private String[] getLabels() {
        String[] labels = new String[]{"null", "null"};
        if (this._leftFile != null) {
            labels[0] = this._leftFile.getFullPath().makeRelative().toString();
        }
        if (this._rightFile != null) {
            labels[1] = this._rightFile.getFullPath().makeRelative().toString();
        }
        return labels;
    }
}

