/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.editor;

import com.ibm.pdp.compare.ui.PTCompareUIPlugin;
import com.ibm.pdp.compare.ui.editor.PTCompareEditorLabel;
import com.ibm.pdp.compare.ui.editor.PTMasterInput;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;

public class PTCompareEditorInput
extends CompareEditorInput
implements ISaveablesSource {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFile _leftFile;
    private IFile _rightFile;
    private SaveableComparison _saveable;
    private IPropertyListener _propertyListener;

    public PTCompareEditorInput(IFile leftFile, IFile rightFile) {
        super(new CompareConfiguration());
        this._leftFile = leftFile;
        this._rightFile = rightFile;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this._propertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 257) {
                    PTCompareEditorInput.this.setDirty(PTCompareEditorInput.this.getSaveable().isDirty());
                }
            }
        };
        this.getSaveable().addPropertyListener(this._propertyListener);
        this.setDirty(this.getSaveable().isDirty());
    }

    protected ICompareInput prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        InternalTypedElement left = new InternalTypedElement(this._leftFile);
        InternalTypedElement right = new InternalTypedElement(this._rightFile);
        PTMasterInput compareInput = new PTMasterInput(left, right);
        this.getCompareConfiguration().setLeftEditable(false);
        this.getCompareConfiguration().setRightEditable(true);
        this.initLabels();
        return compareInput;
    }

    private void initLabels() {
        Object[] left = new String[]{this._leftFile.getFullPath().makeRelative().toString()};
        String leftLabel = PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorLeftTitle, left);
        Object[] right = new String[]{this._rightFile.getFullPath().makeRelative().toString()};
        String rightLabel = PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorRightTitle, right);
        this.getCompareConfiguration().setLeftLabel(leftLabel);
        this.getCompareConfiguration().setRightLabel(rightLabel);
    }

    protected void fireInputChange() {
    }

    public String getTitle() {
        return PTCompareEditorLabel.getString(PTCompareEditorLabel._CompareEditorTitle, this.getLabels());
    }

    public Image getTitleImage() {
        return PTCompareUIPlugin.getDefault().getImage("synchronize");
    }

    public ImageDescriptor getImageDescriptor() {
        return PTCompareUIPlugin.getDefault().getImageDescriptor("synchronize");
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier && this.getSaveable() instanceof IPropertyChangeListener) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            final IPropertyChangeListener pcl = (IPropertyChangeListener)this.getSaveable();
            dsp.addPropertyChangeListener(pcl);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(pcl);
                }
            });
        }
        return newViewer;
    }

    private String[] getLabels() {
        String[] labels = new String[]{"null", "null"};
        if (this._leftFile != null) {
            labels[0] = this._leftFile.getFullPath().makeRelative().toString();
        }
        if (this._rightFile != null) {
            labels[1] = this._rightFile.getFullPath().makeRelative().toString();
        }
        return labels;
    }

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public boolean isDirty() {
        if (this._saveable != null) {
            return this._saveable.isDirty();
        }
        return super.isDirty();
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }

    public Saveable[] getActiveSaveables() {
        if (this.getCompareResult() == null) {
            return new Saveable[0];
        }
        return new Saveable[]{this.getSaveable()};
    }

    private SaveableComparison getSaveable() {
        if (this._saveable == null) {
            this._saveable = new InternalSaveable(this);
        }
        return this._saveable;
    }

    private class InternalSaveable
    extends SaveableComparison
    implements IPropertyChangeListener {
        PTCompareEditorInput _editorInput;

        public InternalSaveable(PTCompareEditorInput editorInput) {
            this._editorInput = editorInput;
        }

        protected void performSave(IProgressMonitor monitor) throws CoreException {
            PTCompareEditorInput.this.flushViewers(monitor);
        }

        protected void performRevert(IProgressMonitor monitor) {
        }

        public String getName() {
            return this._editorInput.getLabels()[1];
        }

        public String getToolTipText() {
            return this._editorInput.getToolTipText();
        }

        public ImageDescriptor getImageDescriptor() {
            return PTCompareUIPlugin.getDefault().getImageDescriptor("synchronize");
        }

        public boolean equals(Object object) {
            if (object instanceof InternalSaveable) {
                InternalSaveable saveable = (InternalSaveable)((Object)object);
                return this._editorInput == saveable._editorInput;
            }
            return false;
        }

        public int hashCode() {
            return ((Object)((Object)this._editorInput)).hashCode();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getProperty();
            if ("DIRTY_STATE".equals(propertyName)) {
                boolean changed = false;
                Object newValue = e.getNewValue();
                if (newValue instanceof Boolean) {
                    changed = (Boolean)newValue;
                }
                this.setDirty(changed);
            }
        }

        public boolean isDirty() {
            return this._editorInput.isSaveNeeded();
        }

        protected void setDirty(boolean dirty) {
            this._editorInput.setDirty(dirty);
        }
    }

    private class InternalTypedElement
    implements IResourceProvider,
    ITypedElement,
    IStreamContentAccessor,
    IEditableContent {
        IFile _file;

        public InternalTypedElement(IFile file) {
            this._file = file;
        }

        public IResource getResource() {
            return this._file;
        }

        public String getName() {
            return this._file.getFullPath().makeAbsolute().toString();
        }

        public Image getImage() {
            return CompareUI.getImage((IAdaptable)this._file);
        }

        public String getType() {
            return this._file.getFileExtension();
        }

        public InputStream getContents() throws CoreException {
            return this._file.getContents();
        }

        public boolean isEditable() {
            return true;
        }

        public void setContent(byte[] newContent) {
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return dest;
        }
    }
}

