/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.ui.action;

import com.ibm.pdp.compare.ui.editor.PTCompareEditorInput;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.service.PTModelService;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public final class PTMasterCompareAction
implements IObjectActionDelegate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPath _subordinatePath;
    private IPath _masterPath;
    private IWorkbenchPage _workbenchPage;

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSel = (IStructuredSelection)selection;
        if (action != null) {
            Object object;
            action.setEnabled(false);
            if (structuredSel.size() == 1 && (object = structuredSel.getFirstElement()) instanceof PTElement) {
                this._subordinatePath = ((PTElement)object).getPath();
                this._masterPath = PTModelService.getMaster((IPath)this._subordinatePath);
                if (this._masterPath != null) {
                    action.setEnabled(true);
                }
            }
        }
    }

    public void run(IAction action) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile leftFile = (IFile)root.findMember(this._masterPath);
        IFile rightFile = (IFile)root.findMember(this._subordinatePath);
        PTCompareEditorInput compareEditorInput = new PTCompareEditorInput(leftFile, rightFile);
        CompareUI.openCompareEditorOnPage((CompareEditorInput)compareEditorInput, (IWorkbenchPage)this._workbenchPage);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._workbenchPage = targetPart.getSite().getPage();
    }
}

