/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WordReplacement
extends WordDifference {
    protected int hash;
    protected Word[] deletedWords;
    protected Word[] addedWords;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WordReplacement(int hash, Word[] deletedWords, Word[] addedWords) {
        this.hash = hash;
        this.deletedWords = deletedWords;
        this.addedWords = addedWords;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Replacement;
    }

    @Override
    public int deletedWordsCount() {
        return this.deletedWords.length;
    }

    @Override
    public Word[] deletedWords() {
        return this.deletedWords;
    }

    @Override
    public int addedWordsCount() {
        return this.addedWords.length;
    }

    @Override
    public Word[] addedWords() {
        return this.addedWords;
    }

    @Override
    public boolean sameAs(TextToken[] refTokens, DiffCursor cursor, TextToken[] modTokens) {
        if (cursor.getReferenceEndIndex() - cursor.getReferenceBeginIndex() != this.deletedWords.length) {
            return false;
        }
        if (cursor.getModifiedEndIndex() - cursor.getModifiedBeginIndex() != this.addedWords.length) {
            return false;
        }
        int tokenRank = cursor.getReferenceBeginIndex();
        int wordRank = 0;
        while (wordRank < this.deletedWords.length) {
            if (!this.deletedWords[wordRank].sameText(refTokens[tokenRank])) {
                return false;
            }
            ++tokenRank;
            ++wordRank;
        }
        tokenRank = cursor.getModifiedBeginIndex();
        wordRank = 0;
        while (wordRank < this.addedWords.length) {
            if (!this.addedWords[wordRank].sameText(modTokens[tokenRank])) {
                return false;
            }
            ++tokenRank;
            ++wordRank;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        Word word;
        StringBuilder builder = new StringBuilder();
        super.dumpTo(builder);
        builder.append("\n -: ");
        Word[] wordArray = this.deletedWords;
        int n = this.deletedWords.length;
        int n2 = 0;
        while (n2 < n) {
            word = wordArray[n2];
            builder.append(word).append(' ');
            ++n2;
        }
        builder.append("\n +: ");
        wordArray = this.addedWords;
        n = this.addedWords.length;
        n2 = 0;
        while (n2 < n) {
            word = wordArray[n2];
            builder.append(word).append(' ');
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "WORD_REPLACEMENT", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("HASH", "" + this.hash);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }
}

