/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.serialization.DifferenceBankSerializer;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class WordDifference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Word[] EMPTY_WORDS = new Word[0];
    protected WordDifference next;
    protected int occurrenceCount;
    protected int rank;

    public int getRank() {
        return this.rank;
    }

    public int getOccurrenceCount() {
        return this.occurrenceCount;
    }

    public abstract DifferenceNature getDifferenceNature();

    public abstract int deletedWordsCount();

    public abstract Word[] deletedWords();

    public abstract int addedWordsCount();

    public abstract Word[] addedWords();

    public abstract boolean sameAs(TextToken[] var1, DiffCursor var2, TextToken[] var3);

    public boolean sameDifference(WordDifference otherDifference) {
        if (otherDifference == null) {
            return false;
        }
        if (!this.getDifferenceNature().equals((Object)otherDifference.getDifferenceNature())) {
            return false;
        }
        if (this.addedWordsCount() != otherDifference.addedWordsCount()) {
            return false;
        }
        if (this.deletedWordsCount() != otherDifference.deletedWordsCount()) {
            return false;
        }
        if (!Arrays.equals(this.addedWords(), otherDifference.addedWords())) {
            return false;
        }
        return Arrays.equals(this.deletedWords(), otherDifference.deletedWords());
    }

    protected void dumpTo(StringBuilder builder) {
        builder.append("Template#").append(this.rank).append(" Occurs=").append(this.occurrenceCount);
    }

    protected void serializeDifferences(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        Word[] insertedWords;
        writer.writeAttribute("OCCURENCE_COUNT", "" + this.getOccurrenceCount());
        writer.writeAttribute("RANK", "" + this.getRank());
        writer.writeAttribute("POS", String.valueOf(posArray) + "," + posList);
        Word[] deletedWords = this.deletedWords();
        if (deletedWords != EMPTY_WORDS) {
            writer.writeStartElement("DELETED_WORDS");
            int i = 0;
            while (i < this.deletedWordsCount()) {
                DifferenceBankSerializer.serializeWordReference(writer, deletedWords[i]);
                ++i;
            }
            writer.writeEndElement();
        }
        if ((insertedWords = this.addedWords()) != EMPTY_WORDS) {
            writer.writeStartElement("INSERTED_WORDS");
            int i = 0;
            while (i < this.addedWordsCount()) {
                DifferenceBankSerializer.serializeWordReference(writer, insertedWords[i]);
                ++i;
            }
            writer.writeEndElement();
        }
    }

    protected void serializeNext(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        if (this.next != null) {
            this.next.serialize(writer, posArray, posList + 1);
        }
    }

    public abstract void serialize(XMLStreamWriter var1, int var2, int var3) throws XMLStreamException;

    public int getHashCode() {
        Word word;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDifferenceNature());
        builder.append('#');
        Word[] wordArray = this.deletedWords();
        int n = wordArray.length;
        int n2 = 0;
        while (n2 < n) {
            word = wordArray[n2];
            builder.append(word);
            ++n2;
        }
        builder.append('#');
        wordArray = this.addedWords();
        n = wordArray.length;
        n2 = 0;
        while (n2 < n) {
            word = wordArray[n2];
            builder.append(word);
            ++n2;
        }
        return builder.toString().hashCode();
    }

    public void changeAddedWord(int i, Word word) {
        this.addedWords()[i] = word;
    }

    public void changeDeletedWord(int i, Word word) {
        this.deletedWords()[i] = word;
    }
}

