/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.CaseDualCharWord;
import com.ibm.pdp.compare.text.CaseSingleCharWord;
import com.ibm.pdp.compare.text.CaseWord;
import com.ibm.pdp.compare.text.DualCharWord;
import com.ibm.pdp.compare.text.IgnoreCaseDualCharWord;
import com.ibm.pdp.compare.text.IgnoreCaseSingleCharWord;
import com.ibm.pdp.compare.text.IgnoreCaseWord;
import com.ibm.pdp.compare.text.QuotedDualCharWord;
import com.ibm.pdp.compare.text.QuotedSingleCharWord;
import com.ibm.pdp.compare.text.QuotedWord;
import com.ibm.pdp.compare.text.RegularWord;
import com.ibm.pdp.compare.text.SingleCharWord;
import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.util.XmlSerializationTool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class WordBank {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int nbWords;
    protected Word[] words;
    private boolean ignoreCase = true;

    private WordBank() {
        this.words = new Word[12];
    }

    public WordBank(int nbWords, int arraySize, boolean ignoreCase) {
        this.nbWords = nbWords;
        this.words = new Word[arraySize];
        this.ignoreCase = ignoreCase;
    }

    public WordBank(boolean ignoreCase) {
        this();
        this.ignoreCase = ignoreCase;
    }

    public int size() {
        return this.nbWords;
    }

    public Word getWord(TextToken token) {
        int index = WordBank.indexFromHash(token.hash, this.words.length);
        Word word = this.words[index];
        while (word != null) {
            if (word.sameText(token)) {
                return word;
            }
            word = word.next;
        }
        return null;
    }

    public boolean addWord(TextToken token) {
        int index = WordBank.indexFromHash(token.hash, this.words.length);
        Word word = this.words[index];
        while (word != null) {
            if (word.sameText(token)) {
                return false;
            }
            word = word.next;
        }
        if (WordBank.tooMuchWords(this.nbWords, this.words.length)) {
            this.resizeWordTable(WordBank.grow(this.words.length));
            index = WordBank.indexFromHash(token.hash, this.words.length);
        }
        Word newWord = this.newWord(token);
        newWord.next = this.words[index];
        this.words[index] = newWord;
        ++this.nbWords;
        return true;
    }

    private boolean addWord(Word newWord) {
        int index = WordBank.indexFromHash(newWord.hashCode(), this.words.length);
        Word word = this.words[index];
        while (word != null) {
            if (word.sameWord(newWord)) {
                return false;
            }
            word = word.next;
        }
        if (WordBank.tooMuchWords(this.nbWords, this.words.length)) {
            this.resizeWordTable(WordBank.grow(this.words.length));
            index = WordBank.indexFromHash(newWord.hashCode(), this.words.length);
        }
        newWord.next = this.words[index];
        this.words[index] = newWord;
        ++this.nbWords;
        return true;
    }

    Word getSameWord(Word wordFromOtherBank) {
        int index = WordBank.indexFromHash(wordFromOtherBank.hashCode(), this.words.length);
        Word word = this.words[index];
        while (word != null) {
            if (word.sameWord(wordFromOtherBank)) {
                return word;
            }
            word = word.next;
        }
        return null;
    }

    public Word putWord(TextToken token) {
        int index = WordBank.indexFromHash(token.hash, this.words.length);
        Word word = this.words[index];
        while (word != null) {
            if (word.sameText(token)) {
                return word;
            }
            word = word.next;
        }
        if (WordBank.tooMuchWords(this.nbWords, this.words.length)) {
            this.resizeWordTable(WordBank.grow(this.words.length));
            index = WordBank.indexFromHash(token.hash, this.words.length);
        }
        Word newWord = this.newWord(token);
        newWord.next = this.words[index];
        this.words[index] = newWord;
        ++this.nbWords;
        return newWord;
    }

    private static final int indexFromHash(int hash, int tableLength) {
        return (hash & Integer.MAX_VALUE) % tableLength;
    }

    private static final boolean tooMuchWords(int wordCount, int tableLength) {
        return wordCount * 3 > tableLength << 1;
    }

    private static final int grow(int tableLength) {
        return 1 + tableLength << 1;
    }

    protected void resizeWordTable(int newLength) {
        Word[] table = this.words;
        int length = table.length;
        Word[] newTable = new Word[newLength];
        int idx = 0;
        while (idx < length) {
            Word word = table[idx];
            while (word != null) {
                Word nextWord = word.next;
                int newIdx = WordBank.indexFromHash(word.hashCode(), newLength);
                word.next = newTable[newIdx];
                newTable[newIdx] = word;
                word = nextWord;
            }
            ++idx;
        }
        this.words = newTable;
    }

    protected Word newWord(TextToken token) {
        switch (token.category) {
            case 0: {
                return this.newSpecialWord(token);
            }
            case 1: {
                return this.ignoreCase ? this.newIgnoreCaseRegularWord(token) : this.newRegularWord(token);
            }
            case 2: {
                return this.newQuotedWord(token);
            }
        }
        return this.newQuotedSpecialWord(token);
    }

    protected Word newSpecialWord(TextToken token) {
        int length = token.endIdx - token.beginIdx;
        if (length == 1) {
            return new SingleCharWord(token.text.charAt(token.beginIdx));
        }
        if (length == 2) {
            return new DualCharWord(token.text.charAt(token.beginIdx), token.text.charAt(token.beginIdx + 1));
        }
        char[] chars = new char[length];
        int idx = length - 1;
        while (idx >= 0) {
            chars[idx] = token.text.charAt(token.beginIdx + idx);
            --idx;
        }
        return new RegularWord(token.hash, chars);
    }

    protected Word newRegularWord(TextToken token) {
        int length = token.endIdx - token.beginIdx;
        if (length == 1) {
            return new CaseSingleCharWord(token.text.charAt(token.beginIdx));
        }
        if (length == 2) {
            return new CaseDualCharWord(token.text.charAt(token.beginIdx), token.text.charAt(token.beginIdx + 1));
        }
        char[] chars = new char[length];
        int idx = length - 1;
        while (idx >= 0) {
            chars[idx] = token.text.charAt(token.beginIdx + idx);
            --idx;
        }
        return new CaseWord(token.hash, chars);
    }

    protected Word newIgnoreCaseRegularWord(TextToken token) {
        int length = token.endIdx - token.beginIdx;
        if (length == 1) {
            return new IgnoreCaseSingleCharWord(this.uppercase(token.text.charAt(token.beginIdx)));
        }
        if (length == 2) {
            return new IgnoreCaseDualCharWord(this.uppercase(token.text.charAt(token.beginIdx)), this.uppercase(token.text.charAt(token.beginIdx + 1)));
        }
        char[] chars = new char[length];
        int idx = length - 1;
        while (idx >= 0) {
            chars[idx] = this.uppercase(token.text.charAt(token.beginIdx + idx));
            --idx;
        }
        return new IgnoreCaseWord(token.hash, chars);
    }

    protected Word newQuotedWord(TextToken token) {
        int length = token.endIdx - token.beginIdx;
        if (length == 1) {
            return new QuotedSingleCharWord(token.text.charAt(token.beginIdx));
        }
        if (length == 2) {
            return new QuotedDualCharWord(token.text.charAt(token.beginIdx), token.text.charAt(token.beginIdx + 1));
        }
        char[] chars = new char[length];
        int idx = length - 1;
        while (idx >= 0) {
            chars[idx] = token.text.charAt(token.beginIdx + idx);
            --idx;
        }
        return new QuotedWord(token.hash, chars);
    }

    protected Word newQuotedSpecialWord(TextToken token) {
        int length = token.text.length();
        if (length == 1) {
            return new QuotedSingleCharWord(token.text.charAt(0));
        }
        if (length == 2) {
            return new QuotedDualCharWord(token.text.charAt(0), token.text.charAt(1));
        }
        char[] chars = new char[length];
        int idx = length - 1;
        while (idx >= 0) {
            chars[idx] = token.text.charAt(idx);
            --idx;
        }
        return new QuotedWord(token.hash, chars);
    }

    protected char uppercase(char chr) {
        if (!this.ignoreCase) {
            return chr;
        }
        return chr >= 'a' && chr <= 'z' ? (char)(chr - 97 + 65) : chr;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("WORD_BANK");
        writer.writeAttribute("NB_WORD", "" + this.nbWords);
        writer.writeAttribute("HASH_ARRAY_SIZE", "" + this.words.length);
        if (this.words != null) {
            int i = 0;
            while (i < this.words.length) {
                Word word = this.words[i];
                if (word != null) {
                    word.serialize(writer, i, 0);
                }
                ++i;
            }
        }
        writer.writeEndElement();
    }

    public void deserialize(XMLStreamReader xmlReader, String differenceBankVersion) throws NumberFormatException, XMLStreamException {
        String localName = "";
        StringBuilder sb = null;
        int posArray = 0;
        int posLinked = 0;
        int hash = 0;
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType == 1) {
                sb = new StringBuilder();
                localName = xmlReader.getLocalName();
                if (!localName.equalsIgnoreCase("DUAL_CHAR_WORD") && !localName.equalsIgnoreCase("IGNORE_CASE_DUAL_CHAR_WORD") && !localName.equalsIgnoreCase("QUOTED_DUAL_CHAR_WORD") && !localName.equalsIgnoreCase("SINGLE_CHAR_WORD") && !localName.equalsIgnoreCase("IGNORE_CASE_SINGLE_CHAR_WORD") && !localName.equalsIgnoreCase("QUOTED_SINGLE_CHAR_WORD") && !localName.equalsIgnoreCase("REGULAR_WORD") && !localName.equalsIgnoreCase("IGNORE_CASE_WORD") && !localName.equalsIgnoreCase("QUOTED_WORD")) continue;
                int nbOfAtt = xmlReader.getAttributeCount();
                int i = 0;
                while (i < nbOfAtt) {
                    String name = xmlReader.getAttributeLocalName(i);
                    String value = xmlReader.getAttributeValue(i);
                    if (name.equalsIgnoreCase("HASH")) {
                        hash = Integer.parseInt(value);
                    } else if (name.equalsIgnoreCase("POS")) {
                        int separatorIndex = value.indexOf(44);
                        posArray = Integer.parseInt(value.substring(0, separatorIndex));
                        posLinked = Integer.parseInt(value.substring(separatorIndex + 1));
                    }
                    ++i;
                }
                continue;
            }
            if (eventType == 4) {
                String txt = xmlReader.getText();
                if (differenceBankVersion.equals("1.1")) {
                    txt = XmlSerializationTool.decode((String)txt);
                }
                sb.append(txt);
                continue;
            }
            if (eventType != 2) continue;
            String qname = xmlReader.getName().getLocalPart();
            if (qname.equalsIgnoreCase("WORD_BANK")) {
                return;
            }
            Word word = null;
            char[] str = sb.toString().toCharArray();
            if (localName.equalsIgnoreCase("DUAL_CHAR_WORD")) {
                word = new DualCharWord(str[0], str[1]);
            } else if (localName.equalsIgnoreCase("IGNORE_CASE_DUAL_CHAR_WORD")) {
                word = new IgnoreCaseDualCharWord(str[0], str[1]);
            } else if (localName.equalsIgnoreCase("QUOTED_DUAL_CHAR_WORD")) {
                word = new QuotedDualCharWord(str[0], str[1]);
            } else if (localName.equalsIgnoreCase("SINGLE_CHAR_WORD")) {
                word = new SingleCharWord(XmlSerializationTool.decode((char[])str));
            } else if (localName.equalsIgnoreCase("IGNORE_CASE_SINGLE_CHAR_WORD")) {
                word = new IgnoreCaseSingleCharWord(XmlSerializationTool.decode((char[])str));
            } else if (localName.equalsIgnoreCase("QUOTED_SINGLE_CHAR_WORD")) {
                word = new QuotedSingleCharWord(XmlSerializationTool.decode((char[])str));
            } else if (localName.equalsIgnoreCase("REGULAR_WORD")) {
                word = new RegularWord(hash, str);
            } else if (localName.equalsIgnoreCase("IGNORE_CASE_WORD")) {
                word = new IgnoreCaseWord(hash, str);
            } else if (localName.equalsIgnoreCase("QUOTED_WORD")) {
                word = new QuotedWord(hash, str);
            }
            if (posLinked == 0) {
                this.words[posArray] = word;
                continue;
            }
            Word reference = this.words[posArray];
            while (posLinked > 1) {
                reference = reference.next;
                --posLinked;
            }
            reference.next = word;
        }
    }

    public void mergeWith(WordBank otherWordBank) {
        if (otherWordBank.words != null) {
            int i = 0;
            while (i < otherWordBank.words.length) {
                Word word = otherWordBank.words[i];
                while (word != null) {
                    Word nextWord = word.next;
                    this.addWord(word);
                    word = nextWord;
                }
                ++i;
            }
        }
    }
}

