/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;

public class TextTokenizer {
    public static int indicatorColumn = 0;
    public static int defaultMaxLineLength = 999;
    public static boolean onlySpecialChars = false;
    public static boolean fullLinePartitionnerWithFormatControl = false;
    protected static final byte OTHER_CHR = 0;
    protected static final byte WORD_CHR = 1;
    protected static final byte WHITE_CHR = 2;
    protected static final byte EOL_CHR = 3;
    protected static final byte QUOTE_CHR = 4;
    protected static final byte SINGLE_CHR = 5;
    protected static final char[] wordChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    protected static final char[] whites = new char[]{' '};
    protected static final char[] eols = new char[]{'\n', '\r'};
    protected static final char[] quotes = new char[]{'\"', '\''};
    protected static byte[] charCategory;
    protected static char minRegisteredChar;
    protected static char maxRegisteredChar;
    protected static char[] commentsChars;
    public static final int SPECIAL = 0;
    public static final int SINGLE = 0;
    public static final int WORD = 1;
    public static final int LINE = 1;
    public static final int QUOTED = 2;
    public static final int QUOTED_SPECIAL = 3;
    protected CharSequence text;
    protected int lastTokenEndIdx = -1;
    protected int column;
    protected char[] line;
    protected int lineBeginIdx;
    protected int lineLength;
    protected boolean blankLine;
    protected int maximumLineLength;
    private boolean ignoreCase = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        commentsChars = null;
        TextTokenizer.initialize(new char[0]);
    }

    public static void initialize(char[] singles) {
        minRegisteredChar = (char)65535;
        maxRegisteredChar = '\u0000';
        TextTokenizer.updateMinMaxChar(wordChars);
        TextTokenizer.updateMinMaxChar(whites);
        TextTokenizer.updateMinMaxChar(eols);
        TextTokenizer.updateMinMaxChar(quotes);
        if (singles != null) {
            TextTokenizer.updateMinMaxChar(singles);
        }
        charCategory = new byte[maxRegisteredChar - minRegisteredChar + 1];
        TextTokenizer.setCategory(wordChars, (byte)1);
        TextTokenizer.setCategory(whites, (byte)2);
        TextTokenizer.setCategory(eols, (byte)3);
        TextTokenizer.setCategory(quotes, (byte)4);
        if (singles != null) {
            TextTokenizer.setCategory(singles, (byte)5);
        }
    }

    public static void setCommentsChars(char[] _commentsChars) {
        commentsChars = _commentsChars;
    }

    protected static void updateMinMaxChar(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < minRegisteredChar) {
                minRegisteredChar = c;
            } else if (c > maxRegisteredChar) {
                maxRegisteredChar = c;
            }
            ++n2;
        }
    }

    protected static void setCategory(char[] chars, byte category) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            TextTokenizer.charCategory[c - TextTokenizer.minRegisteredChar] = category;
            ++n2;
        }
    }

    public TextTokenizer(CharSequence text, int maxLineLength, boolean ignoreCase) {
        this.text = text;
        this.ignoreCase = ignoreCase;
        this.maximumLineLength = maxLineLength <= 0 ? defaultMaxLineLength : maxLineLength;
        this.line = new char[this.maximumLineLength];
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.lastTokenEndIdx = -1;
        this.column = 0;
        this.lineBeginIdx = 0;
        this.lineLength = 0;
        this.blankLine = true;
    }

    public TextToken newToken() {
        return new TextToken(this.ignoreCase);
    }

    /*
     * Unable to fully structure code
     */
    public boolean nextToken(TextToken token) {
        if (this.lastTokenEndIdx == token.endIdx || this.startFrom(token.endIdx)) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            if (TextTokenizer.fullLinePartitionnerWithFormatControl) {
                return this.lineToken(token);
            }
            switch (TextTokenizer.category(this.line[this.column])) {
                case 1: {
                    return this.wordToken(token);
                }
                case 4: {
                    return this.quotedToken(token);
                }
                case 2: 
                case 3: {
                    break;
                }
                case 5: {
                    return this.singleCharToken(token);
                }
                default: {
                    return this.specialToken(token);
                }
            }
lbl16:
            // 2 sources

            ** while (this.searchNextToken())
        }
lbl17:
        // 1 sources

        return false;
    }

    protected boolean startFrom(int startIdx) {
        if (startIdx == 0) {
            return this.firstSignificantLine();
        }
        throw new RuntimeException("Not yet implemented");
    }

    protected boolean firstSignificantLine() {
        if (!this.findFirstLine()) {
            return false;
        }
        if (this.significantLine()) {
            this.column = indicatorColumn;
            return true;
        }
        return this.nextSignificantLine();
    }

    protected boolean nextSignificantLine() {
        while (this.findNextLine()) {
            if (!this.significantLine()) continue;
            this.column = indicatorColumn;
            return true;
        }
        return false;
    }

    protected boolean significantLine() {
        return !this.blankLine && !TextTokenizer.isCommentChar(this.line[indicatorColumn]);
    }

    protected static boolean isCommentChar(char chr) {
        if (commentsChars != null) {
            char[] cArray = commentsChars;
            int n = commentsChars.length;
            int n2 = 0;
            while (n2 < n) {
                char aChr = cArray[n2];
                if (aChr == chr) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean searchNextToken() {
        if (!fullLinePartitionnerWithFormatControl && this.nextSignificantCharOnCurrentLine()) {
            return true;
        }
        if (!this.nextSignificantLine()) {
            return false;
        }
        if (!fullLinePartitionnerWithFormatControl) {
            this.nextSignificantCharOnCurrentLine();
        }
        return true;
    }

    protected boolean nextSignificantCharOnCurrentLine() {
        while (this.column < this.lineLength) {
            if (this.line[this.column] != ' ') {
                return true;
            }
            ++this.column;
        }
        return false;
    }

    protected boolean findFirstLine() {
        int length = this.text.length();
        int index = 0;
        while (index < length) {
            if (!TextTokenizer.isEol(this.text.charAt(index))) {
                this.lineBeginIdx = index;
                this.lineLength = this.fillLine(index);
                return true;
            }
            ++index;
        }
        this.lineBeginIdx = length;
        this.lineLength = 0;
        this.blankLine = true;
        return false;
    }

    protected boolean findNextLine() {
        int length = this.text.length();
        int index = this.lineBeginIdx + this.lineLength;
        while (index < length) {
            if (TextTokenizer.isEol(this.text.charAt(index))) {
                while (++index != length) {
                    if (TextTokenizer.isEol(this.text.charAt(index))) continue;
                    this.lineBeginIdx = index;
                    this.lineLength = this.fillLine(index);
                    return true;
                }
                break;
            }
            ++index;
        }
        this.lineBeginIdx = length;
        this.lineLength = 0;
        this.blankLine = true;
        return false;
    }

    protected static boolean isEol(char chr) {
        return chr == '\r' || chr == '\n';
    }

    protected int fillLine(int index) {
        int col = 0;
        int length = this.text.length();
        while (index < length && col < indicatorColumn) {
            char chr;
            if (TextTokenizer.isEol(chr = this.text.charAt(index++))) {
                this.blankLine = true;
                return col;
            }
            this.line[col++] = chr;
        }
        boolean blank = true;
        while (index < length && col < this.maximumLineLength) {
            char chr;
            if (TextTokenizer.isEol(chr = this.text.charAt(index++))) break;
            this.line[col++] = chr;
            if (chr == ' ') continue;
            blank = false;
        }
        this.blankLine = blank;
        return col;
    }

    protected boolean specialToken(TextToken token) {
        if (onlySpecialChars) {
            return this.singleCharToken(token);
        }
        token.text = this.text;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 0;
        int hash = 0;
        int multiplier = 1;
        char previousChr = this.line[this.column];
        while (++this.column < this.lineLength) {
            char chr = this.line[this.column];
            int charCategory = TextTokenizer.category(chr);
            if (!fullLinePartitionnerWithFormatControl && (chr == ' ' || charCategory == 2 || charCategory == 3 || charCategory == 4)) break;
            hash += this.ignoreCaseHash(previousChr) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            previousChr = chr;
        }
        token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
        token.hash = hash += this.ignoreCaseHash(previousChr) * multiplier;
        return true;
    }

    protected boolean singleCharToken(TextToken token) {
        token.text = this.text;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 0;
        token.endIdx = this.lastTokenEndIdx = token.beginIdx + 1;
        token.hash = this.line[this.column++];
        return true;
    }

    protected boolean lineToken(TextToken token) {
        token.text = this.text;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 1;
        int hash = 0;
        int multiplier = 1;
        char previousChr = this.line[this.column];
        while (++this.column < this.lineLength) {
            char chr = this.line[this.column];
            hash += previousChr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            previousChr = chr;
        }
        token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
        token.hash = hash += previousChr * multiplier;
        return true;
    }

    protected boolean wordToken(TextToken token) {
        token.text = this.text;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 1;
        int hash = 0;
        int multiplier = 1;
        char previousChr = this.line[this.column];
        while (++this.column < this.lineLength) {
            char chr = this.line[this.column];
            int charCategory = TextTokenizer.category(chr);
            if (!fullLinePartitionnerWithFormatControl && charCategory != 1) break;
            hash += this.ignoreCaseHash(previousChr) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            previousChr = chr;
        }
        token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
        token.hash = hash += this.ignoreCaseHash(previousChr) * multiplier;
        return true;
    }

    protected int ignoreCaseHash(char c) {
        if (!this.ignoreCase) {
            return c;
        }
        return c >= 97 ? c - 97 + 65 : c;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean quotedToken(TextToken token) {
        quoteChar = this.line[this.column++];
        cursor = this.column;
        hasMoreQuote = false;
        while (cursor < this.lineLength) {
            if ((chr = this.line[cursor++]) != quoteChar) continue;
            hasMoreQuote = true;
            break;
        }
        if (!hasMoreQuote) {
            --this.column;
            return this.singleCharToken(token);
        }
        token.text = this.text;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 2;
        hash = 0;
        multiplier = 1;
        chars = null;
        while (this.column < this.lineLength) {
            if ((chr = this.line[this.column++]) == quoteChar) {
                if (this.column == this.lineLength || this.line[this.column] != quoteChar) {
                    token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column - 1;
                    token.hash = hash;
                    if (chars != null) {
                        token.category = 3;
                        token.text = chars.toString();
                    }
                    return true;
                }
                if (chars == null) {
                    chars = new StringBuilder();
                    chars.append(this.text, token.beginIdx, this.lineBeginIdx + this.column);
                } else {
                    chars.append(chr);
                }
                ++this.column;
            } else if (chars != null) {
                chars.append(chr);
            }
            hash += chr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
        }
        if (chars == null) {
            chars = new StringBuilder();
            chars.append(this.text, token.beginIdx, this.lineBeginIdx + this.column);
        }
        c = this.column;
        while (c < this.maximumLineLength) {
            chars.append(' ');
            hash += 32 * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++c;
        }
        endIdx = this.lineBeginIdx + this.column;
        ** GOTO lbl78
        {
            if ((chr = this.line[this.column++]) == quoteChar) {
                if (this.column == this.lineLength || this.line[this.column] != quoteChar) {
                    token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column - 1;
                    token.hash = hash;
                    token.category = 3;
                    token.text = chars.toString();
                    return true;
                }
                ++this.column;
            }
            chars.append(chr);
            hash += chr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            do {
                if (this.column < this.lineLength) continue block3;
                c = this.column;
                while (c < this.maximumLineLength) {
                    chars.append(' ');
                    hash += 32 * multiplier;
                    multiplier = (multiplier << 5) - multiplier;
                    ++c;
                }
                endIdx = this.lineBeginIdx + this.column;
lbl78:
                // 2 sources

            } while (this.validQuotedTokenContinuationLine(quoteChar));
        }
        token.endIdx = this.lastTokenEndIdx = endIdx;
        token.hash = hash;
        token.category = 3;
        token.text = chars.toString();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validQuotedTokenContinuationLine(char quoteChar) {
        col = TextTokenizer.indicatorColumn;
        if (this.nextSignificantLine()) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            chr = this.line[col];
            if (chr == quoteChar) {
                this.column = col + 1;
                return true;
            }
            if (chr != ' ') break;
lbl9:
            // 2 sources

            ** while (++col < this.lineLength)
        }
lbl10:
        // 2 sources

        this.column = TextTokenizer.indicatorColumn;
        return false;
    }

    protected static int category(char c) {
        return c >= minRegisteredChar && c <= maxRegisteredChar ? charCategory[c - minRegisteredChar] : 0;
    }
}

