/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.util.Strings;

public class TextToken
implements Cloneable {
    protected static final int SPECIAL = 0;
    protected static final int WORD = 1;
    protected static final int QUOTED = 2;
    protected static final int QUOTED_SPECIAL = 3;
    public int beginIdx;
    public int endIdx;
    protected int hash;
    protected int category;
    protected CharSequence text;
    private boolean ignoreCase = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextToken(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    protected int computeHashCode(int category, CharSequence sequence, int begin, int end) {
        return category == 1 ? this.hashCodeIgnoreCase(sequence, begin, end) : TextToken.hashCode(sequence, begin, end);
    }

    protected static int hashCode(CharSequence str, int begin, int end) {
        int hash = 0;
        int multiplier = 1;
        int i = begin;
        while (i < end) {
            hash += str.charAt(i) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++i;
        }
        return hash;
    }

    protected int hashCodeIgnoreCase(CharSequence str, int begin, int end) {
        int hash = 0;
        int multiplier = 1;
        int i = begin;
        while (i < end) {
            hash += this.ignoreCaseHash(str.charAt(i)) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++i;
        }
        return hash;
    }

    protected int ignoreCaseHash(char c) {
        if (!this.ignoreCase) {
            return c;
        }
        return c >= 97 ? c - 97 + 65 : c;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TextToken)) {
            return false;
        }
        TextToken token = (TextToken)other;
        if (token.hash != this.hash) {
            return false;
        }
        switch (this.category) {
            case 0: {
                return token.category == 0 && this.sameText(this, token);
            }
            case 1: {
                return token.category == 1 && this.sameTextIgnoreCase(this, token);
            }
            case 2: 
            case 3: {
                return (token.category == 2 || token.category == 3) && this.sameQuotedLiterals(this, token);
            }
        }
        return false;
    }

    public TextToken clone() {
        try {
            return (TextToken)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        if (this.category == 3) {
            return "'" + this.text.toString() + "'";
        }
        if (this.category == 2) {
            return "'" + this.text.subSequence(this.beginIdx, this.endIdx).toString() + "'";
        }
        return this.text.subSequence(this.beginIdx, this.endIdx).toString();
    }

    protected boolean sameText(TextToken left, TextToken right) {
        int rightIdx = right.beginIdx;
        int leftIdx = left.beginIdx;
        int nbChar = left.endIdx - leftIdx;
        if (right.endIdx - rightIdx != nbChar) {
            return false;
        }
        return Strings.sameSubSequences((CharSequence)left.text, (int)leftIdx, (CharSequence)right.text, (int)rightIdx, (int)nbChar);
    }

    protected boolean sameTextIgnoreCase(TextToken left, TextToken right) {
        int rightIdx = right.beginIdx;
        int leftIdx = left.beginIdx;
        int nbChar = left.endIdx - leftIdx;
        if (right.endIdx - rightIdx != nbChar) {
            return false;
        }
        CharSequence leftText = left.text;
        CharSequence rightText = right.text;
        while (nbChar-- > 0) {
            char rightChar;
            char leftChar;
            if ((leftChar = leftText.charAt(leftIdx++)) == (rightChar = rightText.charAt(rightIdx++)) || this.uppercaseChar(leftChar) == this.uppercaseChar(rightChar)) continue;
            return false;
        }
        return true;
    }

    protected char uppercaseChar(char c) {
        if (!this.ignoreCase) {
            return c;
        }
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        return c;
    }

    protected boolean sameQuotedLiterals(TextToken left, TextToken right) {
        if (this.getQuoteChar(left) != this.getQuoteChar(right)) {
            return false;
        }
        if (left.category == 2 && right.category == 2) {
            return this.sameText(left, right);
        }
        CharSequence leftText = left.category == 2 ? left.text.subSequence(left.beginIdx, left.endIdx) : left.text;
        CharSequence rightText = right.category == 2 ? right.text.subSequence(right.beginIdx, right.endIdx) : right.text;
        return Strings.sameCharSequences((CharSequence)leftText, (CharSequence)rightText);
    }

    protected char getQuoteChar(TextToken token) {
        try {
            if (token.text != null) {
                return token.text.charAt(token.beginIdx - 1);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        return '\'';
    }
}

