/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.CharDiffCursor;
import com.ibm.pdp.compare.text.LinesDiffCursor;
import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.TextTokenizer;
import com.ibm.pdp.util.containers.Appender;
import com.ibm.pdp.util.diff.ArrayDifferencer;
import com.ibm.pdp.util.diff.DefaultArrayDifferencer;
import com.ibm.pdp.util.diff.DiffCursor;

public class TextDifferencer {
    protected String referenceText;
    protected String modifiedText;
    protected int[] referenceLineIndexes;
    protected int[] modifiedLineIndexes;
    protected TextToken[] referenceTokens;
    protected TextToken[] modifiedTokens;
    protected ArrayDifferencer<TextToken> tokenDifferencer;
    protected int textLineLength;
    private boolean ignoreCase = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextDifferencer(String reference, String modified, boolean ignoreCase) {
        this.referenceText = reference;
        this.modifiedText = modified;
        this.textLineLength = TextTokenizer.defaultMaxLineLength;
        this.ignoreCase = ignoreCase;
    }

    public String getReferenceText() {
        return this.referenceText;
    }

    public void setReferenceText(String reference) {
        this.referenceText = reference;
        this.referenceLineIndexes = null;
        this.referenceTokens = null;
        this.tokenDifferencer = null;
    }

    public String getModifiedText() {
        return this.modifiedText;
    }

    public void setModifiedText(String modified) {
        this.modifiedText = modified;
        this.modifiedLineIndexes = null;
        this.modifiedTokens = null;
        this.tokenDifferencer = null;
    }

    public int[] getReferenceLineIndexes() {
        if (this.referenceLineIndexes == null) {
            this.referenceLineIndexes = this.computeLineIndexes(this.referenceText);
        }
        return this.referenceLineIndexes;
    }

    public int referenceLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getReferenceLineIndexes();
        int lineRank = TextDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
        return lineRank >= 0 ? lineRank : ~lineRank - 1;
    }

    public int[] getModifiedLineIndexes() {
        if (this.modifiedLineIndexes == null) {
            this.modifiedLineIndexes = this.computeLineIndexes(this.modifiedText);
        }
        return this.modifiedLineIndexes;
    }

    public int modifiedLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getModifiedLineIndexes();
        int lineRank = TextDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
        return lineRank >= 0 ? lineRank : ~lineRank - 1;
    }

    protected static int lineRankFromIndex(int index, int[] lineStartIndex, int begin, int end) {
        while (begin < end) {
            int middle = begin + end >> 1;
            int value = lineStartIndex[middle];
            if (index > value) {
                begin = middle + 1;
                continue;
            }
            if (index < value) {
                end = middle;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    protected int[] computeLineIndexes(String s) {
        if (s.length() == 0) {
            return new int[0];
        }
        int[] lines = new int[1 + s.length() / 80];
        lines[0] = 0;
        int nbLines = 1;
        int index = this.nextLineStartIndex(s, 0);
        while (index != -1) {
            if (nbLines == lines.length) {
                int[] newLines = new int[nbLines + (nbLines >> 3) + 10];
                System.arraycopy(lines, 0, newLines, 0, nbLines);
                lines = newLines;
            }
            lines[nbLines++] = index;
            index = this.nextLineStartIndex(s, index);
        }
        if (nbLines != lines.length) {
            int[] newLines = new int[nbLines];
            System.arraycopy(lines, 0, newLines, 0, nbLines);
            lines = newLines;
        }
        return lines;
    }

    protected int nextLineStartIndex(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c == '\r') {
                if (++index < length && s.charAt(index) == '\n') {
                    ++index;
                }
                return index;
            }
            if (c == '\n') {
                if (++index < length && s.charAt(index) == '\r') {
                    ++index;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    public TextToken[] getReferenceTokens() {
        if (this.referenceTokens == null) {
            this.referenceTokens = this.buildTokens(this.referenceText);
        }
        return this.referenceTokens;
    }

    public TextToken[] getModifiedTokens() {
        if (this.modifiedTokens == null) {
            this.modifiedTokens = this.buildTokens(this.modifiedText);
        }
        return this.modifiedTokens;
    }

    public boolean sameTexts() {
        TextTokenizer tokenizer1 = new TextTokenizer(this.referenceText, this.textLineLength, this.ignoreCase);
        TextTokenizer tokenizer2 = new TextTokenizer(this.modifiedText, this.textLineLength, this.ignoreCase);
        TextToken token1 = tokenizer1.newToken();
        TextToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (tokenizer2.nextToken(token2) && token1.equals(token2)) continue;
            return false;
        }
        return !tokenizer2.nextToken(token2);
    }

    public int[] firstDifferenceIndexes() {
        TextTokenizer tokenizer1 = new TextTokenizer(this.referenceText, this.textLineLength, this.ignoreCase);
        TextTokenizer tokenizer2 = new TextTokenizer(this.modifiedText, this.textLineLength, this.ignoreCase);
        TextToken token1 = tokenizer1.newToken();
        TextToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (!tokenizer2.nextToken(token2)) {
                return new int[]{token1.beginIdx, this.modifiedText.length()};
            }
            if (token1.equals(token2)) continue;
            return new int[]{token1.beginIdx, token2.beginIdx};
        }
        if (tokenizer2.nextToken(token2)) {
            return new int[]{this.referenceText.length(), token2.beginIdx};
        }
        return null;
    }

    public DiffCursor newTokenDifferencesCursor() {
        return this.getTokenDifferencer().newDiffCursor();
    }

    protected ArrayDifferencer<TextToken> getTokenDifferencer() {
        if (this.tokenDifferencer == null) {
            this.tokenDifferencer = new DefaultArrayDifferencer((Object[])this.getReferenceTokens(), (Object[])this.getModifiedTokens());
        }
        return this.tokenDifferencer;
    }

    public DiffCursor newCharDifferencesCursor() {
        return new CharDiffCursor(this.referenceText, this.getReferenceTokens(), this.modifiedText, this.getModifiedTokens());
    }

    public DiffCursor newLineDifferencesCursor() {
        return new LinesDiffCursor(this.referenceText, this.getReferenceTokens(), this.getReferenceLineIndexes(), this.modifiedText, this.getModifiedTokens(), this.getModifiedLineIndexes());
    }

    protected TextToken[] buildTokens(String text) {
        Appender tokens = new Appender();
        TextTokenizer tokenizer = new TextTokenizer(text, this.textLineLength, this.ignoreCase);
        TextToken token = tokenizer.newToken();
        this.buildTokens(tokenizer, token, (Appender<TextToken>)tokens);
        return this.newTokenArray(tokenizer, token, (Appender<TextToken>)tokens);
    }

    protected void buildTokens(TextTokenizer tokenizer, TextToken token, Appender<TextToken> tokens) {
        while (tokenizer.nextToken(token)) {
            tokens.append((Object)token.clone());
        }
    }

    protected TextToken[] newTokenArray(TextTokenizer tokenizer, TextToken token, Appender<TextToken> tokens) {
        Object[] result = new TextToken[tokens.size()];
        tokens.copyTo(result);
        return result;
    }
}

