/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SingleWordReplacement
extends WordDifference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Word deletedWord;
    protected Word addedWord;

    public SingleWordReplacement(Word deletedWord, Word addedWord) {
        this.deletedWord = deletedWord;
        this.addedWord = addedWord;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Replacement;
    }

    @Override
    public int deletedWordsCount() {
        return 1;
    }

    @Override
    public Word[] deletedWords() {
        return new Word[]{this.deletedWord};
    }

    @Override
    public int addedWordsCount() {
        return 1;
    }

    @Override
    public Word[] addedWords() {
        return new Word[]{this.addedWord};
    }

    @Override
    public boolean sameAs(TextToken[] refTokens, DiffCursor cursor, TextToken[] modTokens) {
        if (cursor.getReferenceEndIndex() - cursor.getReferenceBeginIndex() != 1) {
            return false;
        }
        if (cursor.getModifiedEndIndex() - cursor.getModifiedBeginIndex() != 1) {
            return false;
        }
        TextToken deletedToken = refTokens[cursor.getReferenceBeginIndex()];
        TextToken addedToken = modTokens[cursor.getModifiedBeginIndex()];
        return this.addedWord.sameText(addedToken) && this.deletedWord.sameText(deletedToken);
    }

    public int hashCode() {
        return this.deletedWord.hashCode() + this.addedWord.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpTo(builder);
        return builder.toString();
    }

    @Override
    protected void dumpTo(StringBuilder builder) {
        super.dumpTo(builder);
        builder.append("\n -: ").append(this.deletedWord.toString()).append("\n +: ").append(this.addedWord.toString());
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "SINGLE_WORD_REPLACMENT", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }

    @Override
    public void changeDeletedWord(int i, Word word) {
        this.deletedWord = word;
    }

    @Override
    public void changeAddedWord(int i, Word word) {
        this.addedWord = word;
    }
}

