/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SingleWordInsertion
extends WordDifference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Word insertedWord;

    public SingleWordInsertion(Word insertedWord) {
        this.insertedWord = insertedWord;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Insertion;
    }

    @Override
    public int deletedWordsCount() {
        return 0;
    }

    @Override
    public Word[] deletedWords() {
        return EMPTY_WORDS;
    }

    @Override
    public int addedWordsCount() {
        return 1;
    }

    @Override
    public Word[] addedWords() {
        return new Word[]{this.insertedWord};
    }

    @Override
    public boolean sameAs(TextToken[] refTokens, DiffCursor cursor, TextToken[] modTokens) {
        if (cursor.getReferenceEndIndex() != cursor.getReferenceBeginIndex()) {
            return false;
        }
        if (cursor.getModifiedEndIndex() - cursor.getModifiedBeginIndex() != 1) {
            return false;
        }
        TextToken insertedToken = modTokens[cursor.getModifiedBeginIndex()];
        return this.insertedWord.sameText(insertedToken);
    }

    public int hashCode() {
        return this.insertedWord.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpTo(builder);
        return builder.toString();
    }

    @Override
    protected void dumpTo(StringBuilder builder) {
        super.dumpTo(builder);
        builder.append("\n +: ").append(this.insertedWord.toString());
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "SINGLE_WORD_INSERTION", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }

    @Override
    public void changeAddedWord(int i, Word word) {
        this.insertedWord = word;
    }
}

