/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.util.XmlSerializationTool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SingleCharWord
extends Word {
    protected char chr;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SingleCharWord(char chr) {
        this.chr = chr;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public char firstChar() {
        return this.chr;
    }

    @Override
    public char lastChar() {
        return this.chr;
    }

    @Override
    public char[] chars() {
        return new char[]{this.chr};
    }

    @Override
    public boolean quoted() {
        return false;
    }

    @Override
    public boolean sameText(TextToken token) {
        if (token.category == 1) {
            return false;
        }
        if (token.category == 3) {
            return token.text.length() == 1 && token.text.charAt(0) == this.chr;
        }
        return token.endIdx - token.beginIdx == 1 && this.chr == token.text.charAt(token.beginIdx);
    }

    public int hashCode() {
        return this.chr;
    }

    public String toString() {
        return String.valueOf(this.chr);
    }

    @Override
    public void serialize(XMLStreamWriter writer, int pos, int j) throws XMLStreamException {
        this.serialize(writer, "SINGLE_CHAR_WORD", pos, j);
    }

    @Override
    protected void serialize(XMLStreamWriter writer, String type, int pos, int j) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("POS", pos + "," + j);
        writer.writeCharacters(XmlSerializationTool.encode((char)this.chr));
        writer.writeEndElement();
        super.serialize(writer, type, pos, j);
    }
}

