/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.util.XmlSerializationTool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class RegularWord
extends Word {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int hash;
    protected char[] chars;

    public RegularWord(int hash, char[] chars) {
        this.hash = hash;
        this.chars = chars;
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public char firstChar() {
        return this.chars[0];
    }

    @Override
    public char lastChar() {
        return this.chars[this.chars.length - 1];
    }

    @Override
    public char[] chars() {
        return this.chars;
    }

    @Override
    public boolean quoted() {
        return false;
    }

    @Override
    public boolean sameText(TextToken token) {
        int endIdx;
        int beginIdx;
        if (token.category == 1 || token.hash != this.hash) {
            return false;
        }
        if (token.category == 3) {
            beginIdx = 0;
            endIdx = token.text.length();
        } else {
            beginIdx = token.beginIdx;
            endIdx = token.endIdx;
        }
        if (this.chars.length != endIdx - beginIdx) {
            return false;
        }
        CharSequence text = token.text;
        int i = this.chars.length - 1;
        while (i >= 0) {
            if (this.chars[i] != text.charAt(beginIdx + i)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return String.valueOf(this.chars);
    }

    @Override
    public void serialize(XMLStreamWriter writer, int pos, int j) throws XMLStreamException {
        this.serialize(writer, "REGULAR_WORD", pos, j);
    }

    @Override
    protected void serialize(XMLStreamWriter writer, String type, int pos, int j) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("HASH", "" + this.hash);
        writer.writeAttribute("POS", pos + "," + j);
        String s = String.valueOf(this.chars);
        String encodedString = XmlSerializationTool.encode((CharSequence)s);
        writer.writeCharacters(encodedString);
        writer.writeEndElement();
        super.serialize(writer, type, pos, j);
    }
}

