/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.RegularWord;
import com.ibm.pdp.compare.text.TextToken;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IgnoreCaseWord
extends RegularWord {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IgnoreCaseWord(int hash, char[] chars) {
        super(hash, chars);
    }

    @Override
    public boolean quoted() {
        return false;
    }

    @Override
    public boolean sameText(TextToken token) {
        if (token.category != 1 || token.hash != this.hash) {
            return false;
        }
        int beginIdx = token.beginIdx;
        if (this.chars.length != token.endIdx - beginIdx) {
            return false;
        }
        CharSequence text = token.text;
        int i = this.chars.length - 1;
        while (i >= 0) {
            if (this.chars[i] != IgnoreCaseWord.uppercase(text.charAt(beginIdx + i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public void serialize(XMLStreamWriter writer, int pos, int j) throws XMLStreamException {
        this.serialize(writer, "IGNORE_CASE_WORD", pos, j);
    }

    protected static char uppercase(char chr) {
        return chr >= 'a' && chr <= 'z' ? (char)(chr - 97 + 65) : chr;
    }
}

