/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.DifferenceBank;
import com.ibm.pdp.compare.text.TextDifferencer;
import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.TextTokenizer;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.WordDifference;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.csv.CsvWriter;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;

public class DiffCsv {
    protected static int numberOfFiles = 0;
    protected static int numberOfModifiedFiles = 0;
    protected static DifferenceBank diffBank = null;
    private static PrintStream messages = System.out;
    private static CsvWriter overview;
    private static CsvWriter templates;
    private static CsvWriter diffList;
    protected static final FileFilter TEXT_FILE;
    protected static final FileFilter DIRECTORY;
    protected static String leftFileOrDir;
    protected static String rightFileOrDir;
    protected static String resultDir;
    protected static char cellSeparatorChar;
    protected static char textQuoteChar;
    protected static String[] extensions;
    protected static final String USAGE = "Usage: DiffCsv LeftFileOrDirectory RightFileOrDirectory ResultDirectory [-sep CellSeparatorChar] [-quote TextQuoteChar] [-ext FileExtension1:FileExtension2]\n [-lineStartIndex LineStartIndex] [-lineEndIndex LineEndIndex] [-ignoreFormat true|false] [-singleChars \"()\"]\n [-commentChars \"-\"]  [-onlySpecialChars true|false]\nCompare Text files, reporting difference is CSV files\nExample: \n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext cbl\n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext bms:map:mfs\n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext bms:map:mfs\nDefaut extension is: any extension, Default quote char is:\", Default cell separator is:,\nDefaut start index is: 0, Default end index is:999, Default ignore format is:true,\nDefault onlySpecialChars is:flase (if true all chars except [A-Za-z0-9] are considered as a word)";
    protected static long longestExtraction;
    protected static int fileCount;
    protected static long longestDiff;
    protected static boolean ignoreCase;
    protected static int totalDiffCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        TEXT_FILE = new FileFilter(){

            @Override
            public boolean accept(File path) {
                if (path.isDirectory()) {
                    return false;
                }
                if (extensions == null || extensions.length == 0) {
                    return true;
                }
                String[] stringArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (path.getName().endsWith(String.valueOf('.') + extension)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        DIRECTORY = new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        };
        cellSeparatorChar = (char)44;
        textQuoteChar = (char)34;
        extensions = null;
        longestExtraction = 0L;
        fileCount = 0;
        longestDiff = 0L;
        ignoreCase = true;
        totalDiffCount = 0;
    }

    public static void main(String[] args) throws Exception {
        try {
            numberOfFiles = 0;
            numberOfModifiedFiles = 0;
            overview = null;
            templates = null;
            diffList = null;
            diffBank = new DifferenceBank(true);
            TextTokenizer.indicatorColumn = 0;
            TextTokenizer.defaultMaxLineLength = 999;
            TextTokenizer.fullLinePartitionnerWithFormatControl = false;
            TextTokenizer.onlySpecialChars = false;
            try {
                DiffCsv.analyzeArgs(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return;
            }
            File left = new File(leftFileOrDir);
            if (!left.exists()) {
                throw new RuntimeException("File or directory " + leftFileOrDir + " doesn't exist");
            }
            File right = new File(rightFileOrDir);
            if (!right.exists()) {
                throw new RuntimeException("File or directory " + rightFileOrDir + " doesn't exist");
            }
            try {
                if (!new File(resultDir).exists() && !new File(resultDir).mkdirs()) {
                    throw new RuntimeException("Cannot create directory " + resultDir);
                }
                String overviewFilename = String.valueOf(resultDir) + "\\Overview.csv";
                overview = new CsvWriter((Writer)new FileWriter(overviewFilename), cellSeparatorChar);
                String templatesFilename = String.valueOf(resultDir) + "\\Templates.csv";
                templates = new CsvWriter((Writer)new FileWriter(templatesFilename), cellSeparatorChar);
                String diffListFilename = String.valueOf(resultDir) + "\\DiffList.csv";
                diffList = new CsvWriter((Writer)new FileWriter(diffListFilename), cellSeparatorChar);
            }
            catch (FileNotFoundException fnfe) {
                throw Util.rethrow((Throwable)fnfe);
            }
            messages.print("Compare files : ");
            messages.print(leftFileOrDir.toString());
            messages.print(" <=> ");
            messages.println(rightFileOrDir.toString());
            messages.print("Results in ");
            messages.print(resultDir.toString());
            messages.println(" : Overview.csv, Templates.csv, DiffList.csv");
            long start = System.currentTimeMillis();
            DiffCsv.extractTemplates(left, right);
            long extraction = System.currentTimeMillis() - start;
            messages.print("Total template extraction time = ");
            messages.print(extraction);
            messages.println(" ms");
            start = System.currentTimeMillis();
            DiffCsv.diff(left, right);
            long diff = System.currentTimeMillis() - start;
            messages.print("Total diff time = ");
            messages.print(diff);
            messages.println(" ms");
            messages.print("Number of files = ");
            messages.println(numberOfFiles);
            messages.print("Number of modified files = ");
            messages.println(numberOfModifiedFiles);
            messages.print("Number of templates = ");
            messages.println(diffBank.size());
            messages.print("Number of differences = ");
            messages.println(diffBank.occurrences());
        }
        catch (Exception t) {
            t.printStackTrace(messages);
            messages.close();
            throw t;
        }
    }

    protected static void analyzeArgs(String[] args) {
        if (args.length < 3) {
            DiffCsv.usage();
        }
        leftFileOrDir = args[0];
        rightFileOrDir = args[1];
        resultDir = args[2];
        int i = 3;
        while (i < args.length) {
            if (args[i].equals("-sep")) {
                if (i + 1 == args.length || args[i + 1].length() != 1) {
                    DiffCsv.usage();
                }
                cellSeparatorChar = args[i + 1].charAt(0);
            } else if (args[i].equals("-quote")) {
                if (i + 1 == args.length || args[i + 1].length() != 1) {
                    DiffCsv.usage();
                }
                textQuoteChar = args[i + 1].charAt(0);
            } else if (args[i].equals("-ext")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                extensions = args[i + 1].split(":");
            } else if (args[i].equals("-lineStartIndex")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.indicatorColumn = Integer.parseInt(args[i + 1]);
            } else if (args[i].equals("-lineEndIndex")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.defaultMaxLineLength = Integer.parseInt(args[i + 1]);
            } else if (args[i].equals("-ignoreFormat")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.fullLinePartitionnerWithFormatControl = "false".equals(args[i + 1]);
            } else if (args[i].equals("-onlySpecialChars")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.onlySpecialChars = "true".equals(args[i + 1]);
            } else if (args[i].equals("-singleChars")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.initialize(args[i + 1].toCharArray());
            } else if (args[i].equals("-commentChars")) {
                if (i + 1 == args.length) {
                    DiffCsv.usage();
                }
                TextTokenizer.setCommentsChars(args[i + 1].toCharArray());
            }
            ++i;
        }
    }

    protected static void usage() {
        throw new RuntimeException("Wrong usage.\nUsage: DiffCsv LeftFileOrDirectory RightFileOrDirectory ResultDirectory [-sep CellSeparatorChar] [-quote TextQuoteChar] [-ext FileExtension1:FileExtension2]\n [-lineStartIndex LineStartIndex] [-lineEndIndex LineEndIndex] [-ignoreFormat true|false] [-singleChars \"()\"]\n [-commentChars \"-\"]  [-onlySpecialChars true|false]\nCompare Text files, reporting difference is CSV files\nExample: \n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext cbl\n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext bms:map:mfs\n\tDiffCsv c:\\tmp\\left\\ c:\\tmp\\right c:\\tmp\\results -sep ; -quote ' -ext bms:map:mfs\nDefaut extension is: any extension, Default quote char is:\", Default cell separator is:,\nDefaut start index is: 0, Default end index is:999, Default ignore format is:true,\nDefault onlySpecialChars is:flase (if true all chars except [A-Za-z0-9] are considered as a word)");
    }

    protected static void extractTemplates(File left, File right) {
        boolean dir = left.isDirectory();
        if (dir != right.isDirectory()) {
            throw new RuntimeException("Unable to compare a directory and a file: " + left.toString() + ", " + right.toString());
        }
        String commonPath = DiffCsv.extractCommonPath(left, right);
        if (dir) {
            DiffCsv.directoryExtractTemplates(commonPath, left, right, TEXT_FILE);
        } else {
            DiffCsv.fileExtractTemplates(commonPath.length(), left, right);
        }
        DiffCsv.showHeader(templates, commonPath, left, right);
        templates.addCell("Template").addCell("Occurs").addCell("Nature").addCell("Deleted#").addCell("Added#").addCell("HashCode").addCell("Deleted").addCell("Added").endOfRow();
        WordDifference[] differences = new WordDifference[diffBank.size()];
        diffBank.copyDifferencesTo(differences);
        WordDifference[] wordDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            WordDifference diff = wordDifferenceArray[n2];
            templates.addIntegerCell(1 + diff.getRank()).addIntegerCell(diff.getOccurrenceCount()).addCell(diff.getDifferenceNature().toString()).addIntegerCell(diff.deletedWordsCount()).addIntegerCell(diff.addedWordsCount());
            templates.addIntegerCell(new Integer(diff.getHashCode()).intValue());
            DiffCsv.catenateWords(templates, diff.deletedWords()).endOfCell();
            DiffCsv.catenateWords(templates, diff.addedWords()).endOfRow();
            ++n2;
        }
        templates.close();
    }

    protected static void directoryExtractTemplates(String commonPath, File leftDir, File rightDir, FileFilter filter) {
        DiffCsv.filesExtractTemplates(commonPath, leftDir, rightDir, filter);
        HashMap<String, File> leftSubDirectoriesByName = DiffCsv.filesByName(leftDir, DIRECTORY);
        File[] fileArray = rightDir.listFiles(DIRECTORY);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightSubDir = fileArray[n2];
            File leftSubDir = leftSubDirectoriesByName.get(rightSubDir.getName());
            if (leftSubDir != null) {
                DiffCsv.directoryExtractTemplates(commonPath, leftSubDir, rightSubDir, filter);
            }
            ++n2;
        }
    }

    protected static void filesExtractTemplates(String commonPath, File leftDir, File rightDir, FileFilter filter) {
        int commonPathLength = commonPath.length();
        HashMap<String, File> leftFilesByName = DiffCsv.filesByName(leftDir, filter);
        File[] fileArray = rightDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightFile = fileArray[n2];
            File leftFile = leftFilesByName.get(rightFile.getName());
            if (leftFile != null) {
                DiffCsv.fileExtractTemplates(commonPathLength, leftFile, rightFile);
            }
            ++n2;
        }
    }

    protected static void fileExtractTemplates(int commonPathLength, File left, File right) {
        String rightText;
        ++numberOfFiles;
        String leftFileName = left.toString().substring(commonPathLength);
        String rightFileName = right.toString().substring(commonPathLength);
        long start = System.currentTimeMillis();
        String leftText = Strings.fileToString((File)left);
        TextDifferencer differencer = new TextDifferencer(leftText, rightText = Strings.fileToString((File)right), ignoreCase);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        if (cursor.searchNextDifference()) {
            ++numberOfModifiedFiles;
        }
        diffBank.appendAllDifferences(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
        long extraction = System.currentTimeMillis() - start;
        if (extraction > longestExtraction) {
            messages.print("Extract templates ");
            messages.print(leftFileName);
            messages.print(" <=> ");
            messages.print(rightFileName);
            messages.print(" = ");
            messages.print(extraction);
            messages.println(" ms");
            longestExtraction = extraction;
        }
    }

    protected static CsvWriter catenateWords(CsvWriter csv, Word[] words) {
        int i;
        if (words.length == 0) {
            return csv;
        }
        int leftCut = 0;
        int nbChars = 0;
        while (leftCut < words.length) {
            if ((nbChars += 1 + words[leftCut++].length()) >= 80) break;
        }
        int rightCut = leftCut;
        nbChars = 0;
        int wordCount = leftCut;
        while (wordCount < words.length) {
            nbChars += 1 + words[wordCount].length();
            while (nbChars >= 80) {
                nbChars -= 1 + words[rightCut++].length();
            }
            ++wordCount;
        }
        csv.appendTextToCell('|');
        if (leftCut + 1 >= words.length) {
            i = 0;
            while (i < words.length - 1) {
                DiffCsv.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        } else {
            i = 0;
            while (i < leftCut) {
                DiffCsv.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
            csv.appendTextToCell(" ...\n... ");
            i = rightCut;
            while (i < words.length - 1) {
                DiffCsv.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        }
        return DiffCsv.appendWord(csv, words[words.length - 1]).appendTextToCell('|');
    }

    protected static CsvWriter appendWord(CsvWriter csv, Word word) {
        switch (word.length()) {
            case 1: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell('\'');
            }
            case 2: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar()).appendTextToCell('\'');
            }
        }
        if (!word.quoted()) {
            return csv.appendTextToCell(word.chars());
        }
        return csv.appendTextToCell('\'').appendTextToCell(word.chars()).appendTextToCell('\'');
    }

    protected static void diff(File left, File right) {
        boolean dir = left.isDirectory();
        if (dir != right.isDirectory()) {
            throw new RuntimeException("Unable to compare a directory and a file: " + left.toString() + ", " + right.toString());
        }
        String commonPath = DiffCsv.extractCommonPath(left, right);
        DiffCsv.showHeader(diffList, commonPath, left, right);
        diffList.addCell("Line").addCell("Diff").addCell("Template").addCell("Occurs").addCell("NOTUSED").addCell("Left").addCell("Right").addCell("Left Text").addCell("Right Text").endOfRow();
        DiffCsv.showHeader(overview, commonPath, left, right);
        overview.addCell("Line").addCell("Left").addCell("Right").addCell("Diff#").addCell("NOTUSED").addCell("NOTUSED").addCell("NOTUSED").endOfRow();
        if (dir) {
            DiffCsv.directoryDiff(commonPath.length(), left, right, TEXT_FILE);
        } else {
            DiffCsv.fileDiff(commonPath.length(), left, right);
        }
        diffList.close();
        overview.close();
    }

    protected static void showHeader(CsvWriter csv, String commonPath, File left, File right) {
        csv.appendTextToCell("Root directory = ").appendTextToCell(commonPath).endOfRow();
        String leftDir = left.toString().substring(commonPath.length());
        csv.appendTextToCell("Left directory = ").appendTextToCell(leftDir).endOfRow();
        String rightDir = right.toString().substring(commonPath.length());
        csv.appendTextToCell("Right directory = ").appendTextToCell(rightDir).endOfRow();
        csv.appendTextToCell("Number of files = ").appendIntegerToCell(numberOfFiles).endOfRow();
        csv.appendTextToCell("Number of modified files = ").appendIntegerToCell(numberOfModifiedFiles).endOfRow();
        csv.appendTextToCell("Number of templates = ").appendIntegerToCell(diffBank.size()).endOfRow();
        csv.appendTextToCell("Number of differences = ").appendIntegerToCell(diffBank.occurrences()).endOfRow();
        csv.endOfRow();
    }

    protected static String extractCommonPath(File left, File right) {
        String leftStr = left.toString();
        String rightStr = right.toString();
        int max = Math.min(leftStr.length(), rightStr.length());
        int i = 0;
        while (i < max) {
            if (leftStr.charAt(i) != rightStr.charAt(i)) break;
            ++i;
        }
        while (--i >= 0) {
            char c = leftStr.charAt(i);
            if (c != '/' && c != '\\') continue;
            ++i;
            break;
        }
        if (i == -1) {
            return "";
        }
        return leftStr.substring(0, i);
    }

    protected static void directoryDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        DiffCsv.filesDiff(commonPathLength, leftDir, rightDir, filter);
        HashMap<String, File> leftSubDirectoriesByName = DiffCsv.filesByName(leftDir, DIRECTORY);
        File[] fileArray = rightDir.listFiles(DIRECTORY);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightSubDir = fileArray[n2];
            File leftSubDir = leftSubDirectoriesByName.get(rightSubDir.getName());
            if (leftSubDir != null) {
                DiffCsv.directoryDiff(commonPathLength, leftSubDir, rightSubDir, filter);
            }
            ++n2;
        }
    }

    protected static void filesDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        HashMap<String, File> leftFilesByName = DiffCsv.filesByName(leftDir, filter);
        File[] fileArray = rightDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightFile = fileArray[n2];
            File leftFile = leftFilesByName.get(rightFile.getName());
            if (leftFile != null) {
                DiffCsv.fileDiff(commonPathLength, leftFile, rightFile);
            }
            ++n2;
        }
    }

    protected static HashMap<String, File> filesByName(File directory, FileFilter filter) {
        File[] files = directory.listFiles(filter);
        HashMap<String, File> filesByName = new HashMap<String, File>(files.length << 1);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesByName.put(file.getName(), file);
            ++n2;
        }
        return filesByName;
    }

    protected static void fileDiff(int commonPathLength, File left, File right) {
        ++fileCount;
        String leftFileName = left.toString().substring(commonPathLength);
        String rightFileName = right.toString().substring(commonPathLength);
        long start = System.currentTimeMillis();
        String leftText = Strings.fileToString((File)left);
        String rightText = Strings.fileToString((File)right);
        TextDifferencer differencer = new TextDifferencer(leftText, rightText, ignoreCase);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        int diffCount = 0;
        while (cursor.searchNextDifference()) {
            DiffCsv.showTokenDifference(++diffCount, leftFileName, rightFileName, differencer, cursor);
        }
        long diff = System.currentTimeMillis() - start;
        if (diff > longestDiff) {
            messages.print("Diff ");
            messages.print(leftFileName);
            messages.print(" <=> ");
            messages.print(rightFileName);
            messages.print(" = ");
            messages.flush();
            messages.print(diff);
            messages.println(" ms");
            longestDiff = diff;
        }
        overview.addIntegerCell(fileCount).addCell(leftFileName).addCell(rightFileName).addIntegerCell(diffCount).addIntegerCell(0).addTextCell("NOTUSED").addTextCell("NOTUSED").endOfRow();
    }

    protected static void showTokenDifference(int count, String leftFileName, String rightFileName, TextDifferencer differencer, DiffCursor cursor) {
        ++totalDiffCount;
        String leftText = differencer.getReferenceText();
        int[] leftLineStartIndexes = differencer.getReferenceLineIndexes();
        TextToken[] leftTokens = differencer.getReferenceTokens();
        String rightText = differencer.getModifiedText();
        int[] rightLineStartIndexes = differencer.getModifiedLineIndexes();
        TextToken[] rightTokens = differencer.getModifiedTokens();
        WordDifference template = diffBank.getDifference(leftTokens, cursor, rightTokens);
        String strTemplate = template != null ? String.valueOf(1 + template.getRank()) : "";
        int occurs = template != null ? template.getOccurrenceCount() : 1;
        int leftBeginLineRank = DiffCsv.refBeginLineRank(differencer, cursor);
        int leftEndLineRank = DiffCsv.refEndLineRank(differencer, cursor);
        int rightBeginLineRank = DiffCsv.modBeginLineRank(differencer, cursor);
        int rightEndLineRank = DiffCsv.modEndLineRank(differencer, cursor);
        diffList.addIntegerCell(totalDiffCount).addIntegerCell(count).addCell(strTemplate).addIntegerCell(occurs).addCell("").addCell(leftFileName).addCell(rightFileName);
        DiffCsv.appendText(diffList, leftFileName, leftText, leftLineStartIndexes, leftBeginLineRank, leftEndLineRank).endOfCell();
        DiffCsv.appendText(diffList, rightFileName, rightText, rightLineStartIndexes, rightBeginLineRank, rightEndLineRank).endOfRow();
    }

    protected static CsvWriter appendText(CsvWriter csv, String name, String text, int[] lineStartIndexes, int lineBeginRank, int lineEndRank) {
        int beginIdx = DiffCsv.beginingOfLine(text, lineStartIndexes, lineBeginRank);
        int endIdx = DiffCsv.beforeLineFeed(text, DiffCsv.endOfLine(text, lineStartIndexes, lineEndRank));
        csv.appendTextToCell(name).appendTextToCell('[').appendIntegerToCell(1 + lineBeginRank).appendTextToCell(',').appendIntegerToCell(1 + lineEndRank).appendTextToCell("]:").appendEolToCell();
        int nbOfLines = lineEndRank - lineBeginRank;
        if (nbOfLines <= 10) {
            csv.appendTextToCell(text, beginIdx, endIdx);
        } else {
            int endOfFirst5Idx = DiffCsv.endOfLine(text, lineStartIndexes, lineBeginRank + 5);
            int beginOfLast5Idx = DiffCsv.beginingOfLine(text, lineStartIndexes, lineEndRank - 5);
            csv.appendTextToCell(text, beginIdx, endOfFirst5Idx);
            csv.appendTextToCell("       ... + ").appendIntegerToCell(nbOfLines - 10).appendTextToCell(" lines").appendEolToCell();
            csv.appendTextToCell(text, beginOfLast5Idx, endIdx);
        }
        return csv;
    }

    protected static int beforeLineFeed(String text, int idx) {
        if (idx == 0) {
            return 0;
        }
        char previousChar = text.charAt(idx - 1);
        if (previousChar == '\n') {
            return idx - 1 != 0 && text.charAt(idx - 2) == '\r' ? idx - 2 : idx - 1;
        }
        if (previousChar == '\r') {
            return idx - 1 != 0 && text.charAt(idx - 2) == '\n' ? idx - 2 : idx - 1;
        }
        return idx;
    }

    protected static int refBeginLineRank(TextDifferencer differencer, DiffCursor cursor) {
        int refBeginTokenRank = cursor.getReferenceBeginIndex();
        if (refBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getReferenceTokens()[refBeginTokenRank - 1].endIdx;
        return differencer.referenceLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int refEndLineRank(TextDifferencer differencer, DiffCursor cursor) {
        TextToken[] refTokens = differencer.getReferenceTokens();
        int refEndTokenRank = cursor.getReferenceEndIndex();
        if (refEndTokenRank == refTokens.length) {
            return differencer.getReferenceLineIndexes().length;
        }
        int nextTokenBeginIdx = refTokens[refEndTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static int modBeginLineRank(TextDifferencer differencer, DiffCursor cursor) {
        int modBeginTokenRank = cursor.getModifiedBeginIndex();
        if (modBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getModifiedTokens()[modBeginTokenRank - 1].endIdx;
        return differencer.modifiedLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int modEndLineRank(TextDifferencer differencer, DiffCursor cursor) {
        TextToken[] modTokens = differencer.getModifiedTokens();
        int modEndTokenRank = cursor.getModifiedEndIndex();
        if (modEndTokenRank == modTokens.length) {
            return differencer.getModifiedLineIndexes().length;
        }
        int nextTokenBeginIdx = modTokens[modEndTokenRank].beginIdx;
        return differencer.modifiedLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static int beginingOfLine(String text, int[] linesStartIndexes, int lineRank) {
        return linesStartIndexes[lineRank];
    }

    protected static int endOfLine(String text, int[] linesStartIndexes, int lineRank) {
        return lineRank >= linesStartIndexes.length - 1 ? text.length() : linesStartIndexes[lineRank + 1];
    }
}

