/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.text;

import com.ibm.pdp.compare.text.DifferenceBank;
import com.ibm.pdp.compare.text.TextDifferencer;
import com.ibm.pdp.compare.text.TextToken;
import com.ibm.pdp.compare.text.TextTokenizer;
import com.ibm.pdp.compare.text.Word;
import com.ibm.pdp.compare.text.WordDifference;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.csv.CsvWriter;
import com.ibm.pdp.util.diff.AbstractDiffAppenderCsv;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DiffAppenderCsv
extends AbstractDiffAppenderCsv {
    private int numberOfFiles = 0;
    private int numberOfModifiedFiles = 0;
    private DifferenceBank diffBank = null;
    private CsvWriter overview;
    private CsvWriter templates;
    private CsvWriter diffList;
    private boolean ignoreCase = true;
    private char cellSeparatorChar = (char)59;
    private Map<File, File> filesMap = null;
    private Set<String> patterns;
    private static final String EOL = System.getProperty("line.separator");
    private int totalDiffCount = 0;
    public final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DiffAppenderCsv(int lineStartIndex, int lineEndIndex, String singleChars, String commentChars, boolean ignoreFormatting, boolean ignoreCase) {
        this(lineStartIndex, lineEndIndex, singleChars, commentChars, ignoreFormatting, ignoreCase, null);
    }

    public DiffAppenderCsv(int lineStartIndex, int lineEndIndex, String singleChars, String commentChars, boolean ignoreFormatting, boolean ignoreCase, Set<String> patterns) {
        TextTokenizer.indicatorColumn = lineStartIndex;
        TextTokenizer.defaultMaxLineLength = lineEndIndex;
        boolean bl = TextTokenizer.fullLinePartitionnerWithFormatControl = !ignoreFormatting;
        if (singleChars != null) {
            TextTokenizer.initialize(singleChars.toCharArray());
        }
        if (commentChars != null) {
            TextTokenizer.setCommentsChars(commentChars.toCharArray());
        }
        this.ignoreCase = ignoreCase;
        this.patterns = patterns;
    }

    private void reset() {
        this.numberOfFiles = 0;
        this.numberOfModifiedFiles = 0;
        this.overview = null;
        this.templates = null;
        this.diffList = null;
        this.diffBank = null;
        this.filesMap = new HashMap<File, File>();
    }

    public void end() throws Exception {
        this.extractTemplates();
        this.extractDiffs();
        this.templates.close();
        this.overview.close();
        this.diffList.close();
        this.reset();
    }

    public void start(String resultDir) throws Exception {
        this.reset();
        try {
            if (!new File(resultDir).exists() && !new File(resultDir).mkdirs()) {
                throw new RuntimeException("Cannot create directory " + resultDir);
            }
            String overviewFilename = String.valueOf(resultDir) + "/Overview.csv";
            this.overview = new CsvWriter((Writer)new FileWriter(overviewFilename), this.cellSeparatorChar);
            String templatesFilename = String.valueOf(resultDir) + "/Templates.csv";
            this.templates = new CsvWriter((Writer)new FileWriter(templatesFilename), this.cellSeparatorChar);
            String diffListFilename = String.valueOf(resultDir) + "/DiffList.csv";
            this.diffList = new CsvWriter((Writer)new FileWriter(diffListFilename), this.cellSeparatorChar);
        }
        catch (FileNotFoundException fnfe) {
            throw Util.rethrow((Throwable)fnfe);
        }
        this.diffList.addCell("Line").addCell("Diff").addCell("Template").addCell("Occurs").addCell("NOTUSED").addCell("Left").addCell("Right").addCell("Left Text").addCell("Right Text").endOfRow();
        this.overview.addCell("Line").addCell("Left").addCell("Right").addCell("Diff#").addCell("NOTUSED").addCell("NOTUSED").addCell("NOTUSED").endOfRow();
        this.diffBank = new DifferenceBank(this.ignoreCase);
    }

    private void extractTemplates() {
        for (File left : this.filesMap.keySet()) {
            this.fileExtractTemplates(left, this.filesMap.get(left));
        }
        this.showHeader(this.templates);
        this.templates.addCell("Template").addCell("Occurs").addCell("Nature").addCell("Deleted#").addCell("Added#").addCell("HashCode").addCell("Deleted").addCell("Added").endOfRow();
        WordDifference[] differences = new WordDifference[this.diffBank.size()];
        this.diffBank.copyDifferencesTo(differences);
        WordDifference[] wordDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            WordDifference diff = wordDifferenceArray[n2];
            this.templates.addIntegerCell(1 + diff.getRank()).addIntegerCell(diff.getOccurrenceCount()).addCell(diff.getDifferenceNature().toString()).addIntegerCell(diff.deletedWordsCount()).addIntegerCell(diff.addedWordsCount());
            this.templates.addIntegerCell(new Integer(diff.getHashCode()).intValue());
            this.catenateWords(this.templates, diff.deletedWords()).endOfCell();
            this.catenateWords(this.templates, diff.addedWords()).endOfRow();
            ++n2;
        }
        this.templates.close();
    }

    private void extractDiffs() {
        for (File left : this.filesMap.keySet()) {
            this.extractDiff(left, this.filesMap.get(left));
        }
    }

    private CsvWriter catenateWords(CsvWriter csv, Word[] words) {
        int i;
        if (words.length == 0) {
            return csv;
        }
        int leftCut = 0;
        int nbChars = 0;
        while (leftCut < words.length) {
            if ((nbChars += 1 + words[leftCut++].length()) >= 80) break;
        }
        int rightCut = leftCut;
        nbChars = 0;
        int wordCount = leftCut;
        while (wordCount < words.length) {
            nbChars += 1 + words[wordCount].length();
            while (nbChars >= 80) {
                nbChars -= 1 + words[rightCut++].length();
            }
            ++wordCount;
        }
        csv.appendTextToCell('|');
        if (leftCut + 1 >= words.length) {
            i = 0;
            while (i < words.length - 1) {
                this.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        } else {
            i = 0;
            while (i < leftCut) {
                this.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
            csv.appendTextToCell(" ...\n... ");
            i = rightCut;
            while (i < words.length - 1) {
                this.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        }
        return this.appendWord(csv, words[words.length - 1]).appendTextToCell('|');
    }

    private CsvWriter appendWord(CsvWriter csv, Word word) {
        switch (word.length()) {
            case 1: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell('\'');
            }
            case 2: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar()).appendTextToCell('\'');
            }
        }
        if (!word.quoted()) {
            return csv.appendTextToCell(word.chars());
        }
        return csv.appendTextToCell('\'').appendTextToCell(word.chars()).appendTextToCell('\'');
    }

    private void showHeader(CsvWriter csv) {
        csv.appendTextToCell("Summary").endOfRow();
        csv.appendTextToCell("-------").endOfRow();
        csv.appendTextToCell("").endOfRow();
        csv.appendTextToCell("Number of files = ").appendIntegerToCell(this.numberOfFiles).endOfRow();
        csv.appendTextToCell("Number of modified files = ").appendIntegerToCell(this.numberOfModifiedFiles).endOfRow();
        csv.appendTextToCell("Number of templates = ").appendIntegerToCell(this.diffBank.size()).endOfRow();
        csv.appendTextToCell("Number of differences = ").appendIntegerToCell(this.diffBank.occurrences()).endOfRow();
        csv.endOfRow();
    }

    protected void fileExtractTemplates(File left, File right) {
        String rightText;
        String leftText = this.getFileContent(left);
        TextDifferencer differencer = new TextDifferencer(leftText, rightText = this.getFileContent(right), this.ignoreCase);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        if (cursor.searchNextDifference()) {
            this.diffBank.appendAllDifferences(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
        }
    }

    public boolean findDiff(File left, File right) {
        String leftText = this.getFileContent(left);
        String rightText = this.getFileContent(right);
        this.filesMap.put(left, right);
        ++this.numberOfFiles;
        TextDifferencer differencer = new TextDifferencer(leftText, rightText, this.ignoreCase);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        if (cursor.searchNextDifference()) {
            ++this.numberOfModifiedFiles;
            return true;
        }
        return false;
    }

    private boolean extractDiff(File left, File right) {
        String leftText = this.getFileContent(left);
        String rightText = this.getFileContent(right);
        if (rightText.length() == 0) {
            rightText = " ";
        }
        if (leftText.length() == 0) {
            leftText = " ";
        }
        boolean result = false;
        String leftFileName = left.toString();
        String rightFileName = right.toString();
        TextDifferencer differencer = new TextDifferencer(leftText, rightText, this.ignoreCase);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        int diffCount = 0;
        while (cursor.searchNextDifference()) {
            this.showTokenDifference(++diffCount, leftFileName, rightFileName, differencer, cursor);
        }
        this.overview.addIntegerCell(1).addCell(leftFileName).addCell(rightFileName).addIntegerCell(diffCount).addIntegerCell(0).addTextCell("NOTUSED").addTextCell("NOTUSED").endOfRow();
        return result;
    }

    private String getFileContent(File file) {
        String text = Strings.fileToString((File)file);
        if (this.patterns != null) {
            List lines = Util.splitTextIntoLines((String)text);
            StringBuilder builder = new StringBuilder(text.length());
            for (String line : lines) {
                boolean found = false;
                for (String pattern : this.patterns) {
                    if (!Pattern.matches(pattern, line)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                builder.append(line).append(EOL);
            }
            text = builder.toString();
        }
        return text;
    }

    private void showTokenDifference(int count, String leftFileName, String rightFileName, TextDifferencer differencer, DiffCursor cursor) {
        ++this.totalDiffCount;
        String leftText = differencer.getReferenceText();
        int[] leftLineStartIndexes = differencer.getReferenceLineIndexes();
        TextToken[] leftTokens = differencer.getReferenceTokens();
        String rightText = differencer.getModifiedText();
        int[] rightLineStartIndexes = differencer.getModifiedLineIndexes();
        TextToken[] rightTokens = differencer.getModifiedTokens();
        WordDifference template = this.diffBank.getDifference(leftTokens, cursor, rightTokens);
        String strTemplate = template != null ? String.valueOf(1 + template.getRank()) : "";
        int occurs = template != null ? template.getOccurrenceCount() : 1;
        int leftBeginLineRank = this.refBeginLineRank(differencer, cursor);
        int leftEndLineRank = this.refEndLineRank(differencer, cursor);
        int rightBeginLineRank = this.modBeginLineRank(differencer, cursor);
        int rightEndLineRank = this.modEndLineRank(differencer, cursor);
        this.diffList.addIntegerCell(this.totalDiffCount).addIntegerCell(count).addCell(strTemplate).addIntegerCell(occurs).addCell("").addCell(leftFileName).addCell(rightFileName);
        this.appendText(this.diffList, leftFileName, leftText, leftLineStartIndexes, leftBeginLineRank, leftEndLineRank).endOfCell();
        this.appendText(this.diffList, rightFileName, rightText, rightLineStartIndexes, rightBeginLineRank, rightEndLineRank).endOfRow();
    }

    private CsvWriter appendText(CsvWriter csv, String name, String text, int[] lineStartIndexes, int lineBeginRank, int lineEndRank) {
        int beginIdx = this.beginingOfLine(text, lineStartIndexes, lineBeginRank);
        int endIdx = this.beforeLineFeed(text, this.endOfLine(text, lineStartIndexes, lineEndRank));
        csv.appendTextToCell(name).appendTextToCell('[').appendIntegerToCell(1 + lineBeginRank).appendTextToCell(',').appendIntegerToCell(1 + lineEndRank).appendTextToCell("]:").appendEolToCell();
        int nbOfLines = lineEndRank - lineBeginRank;
        if (nbOfLines <= 10) {
            csv.appendTextToCell(text, beginIdx, endIdx);
        } else {
            int endOfFirst5Idx = this.endOfLine(text, lineStartIndexes, lineBeginRank + 5);
            int beginOfLast5Idx = this.beginingOfLine(text, lineStartIndexes, lineEndRank - 5);
            csv.appendTextToCell(text, beginIdx, endOfFirst5Idx);
            csv.appendTextToCell("       ... + ").appendIntegerToCell(nbOfLines - 10).appendTextToCell(" lines").appendEolToCell();
            csv.appendTextToCell(text, beginOfLast5Idx, endIdx);
        }
        return csv;
    }

    private int beforeLineFeed(String text, int idx) {
        if (idx == 0) {
            return 0;
        }
        char previousChar = text.charAt(idx - 1);
        if (previousChar == '\n') {
            return idx - 1 != 0 && text.charAt(idx - 2) == '\r' ? idx - 2 : idx - 1;
        }
        if (previousChar == '\r') {
            return idx - 1 != 0 && text.charAt(idx - 2) == '\n' ? idx - 2 : idx - 1;
        }
        return idx;
    }

    private int refBeginLineRank(TextDifferencer differencer, DiffCursor cursor) {
        int refBeginTokenRank = cursor.getReferenceBeginIndex();
        if (refBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getReferenceTokens()[refBeginTokenRank - 1].endIdx;
        return differencer.referenceLineRankFromCharIndex(previousTokenEndIdx);
    }

    private int refEndLineRank(TextDifferencer differencer, DiffCursor cursor) {
        TextToken[] refTokens = differencer.getReferenceTokens();
        int refEndTokenRank = cursor.getReferenceEndIndex();
        if (refEndTokenRank == refTokens.length) {
            return differencer.getReferenceLineIndexes().length;
        }
        int nextTokenBeginIdx = refTokens[refEndTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(nextTokenBeginIdx);
    }

    private int modBeginLineRank(TextDifferencer differencer, DiffCursor cursor) {
        int modBeginTokenRank = cursor.getModifiedBeginIndex();
        if (modBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getModifiedTokens()[modBeginTokenRank - 1].endIdx;
        return differencer.modifiedLineRankFromCharIndex(previousTokenEndIdx);
    }

    private int modEndLineRank(TextDifferencer differencer, DiffCursor cursor) {
        TextToken[] modTokens = differencer.getModifiedTokens();
        int modEndTokenRank = cursor.getModifiedEndIndex();
        if (modEndTokenRank == modTokens.length) {
            return differencer.getModifiedLineIndexes().length;
        }
        int nextTokenBeginIdx = modTokens[modEndTokenRank].beginIdx;
        return differencer.modifiedLineRankFromCharIndex(nextTokenBeginIdx);
    }

    private int beginingOfLine(String text, int[] linesStartIndexes, int lineRank) {
        return linesStartIndexes[lineRank];
    }

    private int endOfLine(String text, int[] linesStartIndexes, int lineRank) {
        return lineRank >= linesStartIndexes.length - 1 ? text.length() : linesStartIndexes[lineRank + 1];
    }

    public static void main(String[] args) {
        DiffAppenderCsv appenderCsv = new DiffAppenderCsv(0, 999, null, null, true, true);
        try {
            appenderCsv.start("c:/temp/AAApender");
            appenderCsv.findDiff(new File("C:/temp/folder1/A0P002_A0P002.cbl"), new File("C:/temp/folder2/A0P002_A0P002.cbl"));
            appenderCsv.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

