/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.source.configuration;

import com.ibm.pdp.compare.cobol.ui.PartSide;
import com.ibm.pdp.compare.cobol.ui.action.GenerateAction;
import com.ibm.pdp.compare.cobol.ui.editor.CompareEditor;
import com.ibm.pdp.compare.cobol.ui.viewer.SourceMergeViewer;
import com.ibm.pdp.compare.source.configuration.IPdpSourceViewerConfiguration;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.pacbase.generator.compare.ControllerSourceInput;
import com.ibm.pdp.pdpeditor.editor.PdpPresentationReconciler;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.systemz.cobol.editor.jface.editor.CobolSourceViewerConfiguration;
import com.ibm.systemz.common.jface.editor.ColorManager;
import com.ibm.systemz.common.jface.editor.parse.Reconciler;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;

public class PdpCblSourceViewerConfiguration
extends CobolSourceViewerConfiguration
implements IPdpSourceViewerConfiguration {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SourceMergeViewer _sourceMergeViewer;
    private PartSide _partSide;
    private PdpPresentationReconciler _reconciler = null;
    private Object _input;
    private IController _controller;
    private CompareEditor _compareEditor;

    public PdpCblSourceViewerConfiguration(ColorManager colorManager, SourceMergeViewer sourceMergeViewer, PartSide partSide) {
        super(colorManager);
        this._sourceMergeViewer = sourceMergeViewer;
        this._partSide = partSide;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this._reconciler == null) {
            this._reconciler = new PdpPresentationReconciler((Reconciler)this.getReconciler(sourceViewer), sourceViewer, this._controller);
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner(sourceViewer));
            this._reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            this._reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        }
        return this._reconciler;
    }

    @Override
    public boolean configureViewer(SourceViewer sourceViewer, Object input, Object sharedInput) {
        if (input == this._input) {
            return true;
        }
        this._input = input;
        if (input instanceof IResourceProvider) {
            IResource resource = ((IResourceProvider)input).getResource();
            this._controller = ControllerFactory.getInstance().getController(resource.getFullPath().toPortableString());
            this._compareEditor = new CompareEditor(this._sourceMergeViewer, this._partSide, this.getController());
            if (this._reconciler != null) {
                this._reconciler.setController(this.getController());
            }
            sourceViewer.addTextInputListener(new ITextInputListener(){

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    if (PdpCblSourceViewerConfiguration.this.getCompareEditor() != null) {
                        PdpCblSourceViewerConfiguration.this.getCompareEditor().setDocument(newInput);
                    }
                    if (PdpCblSourceViewerConfiguration.this.getController() != null && PdpCblSourceViewerConfiguration.this.getCompareEditor().getDocument() != null) {
                        Iterator iter = PdpCblSourceViewerConfiguration.this.getController().getEditorLink().editors();
                        CompareEditor compEdit = PdpCblSourceViewerConfiguration.this.getCompareEditor();
                        while (iter.hasNext()) {
                            IEditor iEditor = (IEditor)iter.next();
                            if (iEditor != compEdit) continue;
                            return;
                        }
                        PdpCblSourceViewerConfiguration.this.getController().getEditorLink().addEditor((IEditor)PdpCblSourceViewerConfiguration.this.getCompareEditor());
                    }
                }
            });
            Object data = sourceViewer.getTextWidget().getMenu().getData();
            if (data instanceof MenuManager) {
                MenuManager menuMgr = (MenuManager)data;
                menuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager menu) {
                        if (PdpCblSourceViewerConfiguration.this.getController() != null) {
                            menu.add((IContributionItem)new Separator("com.ibm.pdp.compare.cobol.ui.action.generate"));
                            menu.add((IAction)new GenerateAction(PdpCblSourceViewerConfiguration.this));
                            menu.add((IContributionItem)new Separator("additions"));
                        }
                    }
                });
            }
            return true;
        }
        if (input instanceof InputStreamProviderTypedElement) {
            if (sharedInput instanceof IResourceProvider) {
                IResource resource = ((IResourceProvider)sharedInput).getResource();
                IFile genFile = (IFile)resource;
                String pdpFileName = PdpTool.computePdpFileLocationFromSourceFileLocation((String)genFile.getFullPath().toPortableString());
                IFile pdpFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pdpFileName));
                if (!pdpFile.exists()) {
                    return false;
                }
                try {
                    InputStream inputStream = ((InputStreamProviderTypedElement)input).getContents();
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int count = inputStream.read(bytes, 0, bytes.length);
                    while (count != -1) {
                        outputStream.write(bytes, 0, count);
                        count = inputStream.read(bytes, 0, bytes.length);
                    }
                    byte[] content = outputStream.toByteArray();
                    byte[] pdpContent = PTRepositoryManager.getServerContents((IResource)pdpFile);
                    this._controller = ControllerFactory.getInstance().getController(content, pdpContent);
                    if (this._reconciler != null) {
                        this._reconciler.setController(this.getController());
                    }
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
            return true;
        }
        if (input instanceof ControllerSourceInput) {
            this._controller = ((ControllerSourceInput)input).getController();
            if (this._reconciler != null) {
                this._reconciler.setController(this.getController());
            }
            this._compareEditor = new CompareEditor(this._sourceMergeViewer, this._partSide, this.getController());
            sourceViewer.addTextInputListener(new ITextInputListener(){

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    if (PdpCblSourceViewerConfiguration.this.getCompareEditor() != null) {
                        PdpCblSourceViewerConfiguration.this.getCompareEditor().setDocument(newInput);
                    }
                    if (PdpCblSourceViewerConfiguration.this.getController() != null && PdpCblSourceViewerConfiguration.this.getCompareEditor().getDocument() != null) {
                        Iterator iter = PdpCblSourceViewerConfiguration.this.getController().getEditorLink().editors();
                        CompareEditor compEdit = PdpCblSourceViewerConfiguration.this.getCompareEditor();
                        while (iter.hasNext()) {
                            IEditor iEditor = (IEditor)iter.next();
                            if (iEditor != compEdit) continue;
                            return;
                        }
                        if (!compEdit.isMacroVirtual()) {
                            PdpCblSourceViewerConfiguration.this.getController().getEditorLink().addEditor((IEditor)PdpCblSourceViewerConfiguration.this.getCompareEditor());
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public IController getController() {
        return this._controller;
    }

    @Override
    public CompareEditor getCompareEditor() {
        return this._compareEditor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return null;
    }

    public PartSide getPartSide() {
        return this._partSide;
    }
}

