/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.cobol.ui.viewer;

import com.ibm.pdp.compare.cobol.ui.PartSide;
import com.ibm.pdp.compare.cobol.ui.editor.CompareEditor;
import com.ibm.pdp.compare.cobol.ui.viewer.SourceViewerLabel;
import com.ibm.pdp.compare.source.configuration.IPdpSourceViewerConfiguration;
import com.ibm.pdp.compare.source.configuration.PdpCblSourceViewerConfiguration;
import com.ibm.pdp.compare.source.configuration.PdpSdkSourceViewerConfiguration;
import com.ibm.pdp.explorer.associate.IPTAssociate;
import com.ibm.pdp.explorer.associate.service.PTAssociationService;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.pattern.GenericMicroPatternsAndUsagesParser;
import com.ibm.pdp.framework.pattern.GenericMicroPatternsAndUsagesResults;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.references.associate.DesignGeneratedAssocManager;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import com.ibm.systemz.common.jface.editor.ColorManager;
import com.ibm.team.filesystem.client.IShareable;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class SourceMergeViewer
extends TextMergeViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object _ancestorInput = null;
    private Object _leftInput = null;
    private Object _rightInput = null;
    private SourceViewerConfiguration _ancestorConfiguration = null;
    private SourceViewerConfiguration _leftConfiguration = null;
    private SourceViewerConfiguration _rightConfiguration = null;
    private int _nbConfiguredViewers;
    public boolean isMacroVirtualProcess;

    public SourceMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        if (!configuration.isLeftEditable() && !configuration.isRightEditable()) {
            this.isMacroVirtualProcess = true;
        }
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        });
    }

    private SourceViewerConfiguration getAncestorConfiguration() {
        if (this._ancestorConfiguration == null) {
            this._ancestorConfiguration = new PdpCblSourceViewerConfiguration(new ColorManager(), this, PartSide.Ancestor);
        }
        return this._ancestorConfiguration;
    }

    private SourceViewerConfiguration getLeftConfiguration() {
        if (this._leftConfiguration == null) {
            this._leftConfiguration = new PdpCblSourceViewerConfiguration(new ColorManager(), this, PartSide.Left);
        }
        return this._leftConfiguration;
    }

    private SourceViewerConfiguration getRightConfiguration() {
        if (this._rightConfiguration == null) {
            this._rightConfiguration = new PdpCblSourceViewerConfiguration(new ColorManager(), this, PartSide.Right);
        }
        return this._rightConfiguration;
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this._ancestorInput = ancestor;
        this._leftInput = left;
        this._rightInput = right;
        if (this._leftInput instanceof IResourceProvider) {
            IResource resource = ((IResourceProvider)this._leftInput).getResource();
            IShareable cfr_ignored_0 = (IShareable)resource.getAdapter(IShareable.class);
        }
        super.updateContent(ancestor, left, right);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)textViewer;
            SourceViewerConfiguration configuration = null;
            if (this._nbConfiguredViewers == 0) {
                configuration = this.getAncestorConfiguration();
                if (configuration instanceof IPdpSourceViewerConfiguration) {
                    IPdpSourceViewerConfiguration pdpViewerConfiguration = (IPdpSourceViewerConfiguration)configuration;
                    pdpViewerConfiguration.configureViewer(sourceViewer, this._ancestorInput, null);
                } else {
                    boolean cfr_ignored_0 = configuration instanceof PdpSdkSourceViewerConfiguration;
                }
                ++this._nbConfiguredViewers;
            } else if (this._nbConfiguredViewers == 1) {
                configuration = this.getLeftConfiguration();
                if (configuration instanceof IPdpSourceViewerConfiguration) {
                    IPdpSourceViewerConfiguration pdpViewerConfiguration = (IPdpSourceViewerConfiguration)configuration;
                    pdpViewerConfiguration.configureViewer(sourceViewer, this._leftInput, null);
                } else {
                    boolean cfr_ignored_1 = configuration instanceof PdpSdkSourceViewerConfiguration;
                }
                ++this._nbConfiguredViewers;
            } else if (this._nbConfiguredViewers == 2) {
                configuration = this.getRightConfiguration();
                if (configuration instanceof IPdpSourceViewerConfiguration) {
                    IPdpSourceViewerConfiguration pdpViewerConfiguration = (IPdpSourceViewerConfiguration)configuration;
                    pdpViewerConfiguration.configureViewer(sourceViewer, this._rightInput, this._leftInput);
                } else {
                    boolean cfr_ignored_2 = configuration instanceof PdpSdkSourceViewerConfiguration;
                }
                ++this._nbConfiguredViewers;
            }
            sourceViewer.configure(configuration);
        }
    }

    public String getTitle() {
        return SourceViewerLabel.getString(SourceViewerLabel._SourceViewerTitle);
    }

    private void flush(IController controller, boolean left, IProgressMonitor monitor) {
        if (controller == null) {
            return;
        }
        String logicalFileName = controller.getGenerationLink().getGenerationOutput().getLogicalFileName();
        ControllerFactory.getInstance().removeResourceChangeListener();
        this.dealWithCrossReferences(logicalFileName, controller);
        String sourceFileName = GenerationManager.getFullPathFromGenerationOutput((IController)controller);
        controller.getDesignLink().saveDesign();
        if (left) {
            super.flushLeft(monitor);
        } else {
            super.flushRight(monitor);
        }
        controller.getResourceLink().saveResource();
        IFile sourcefile = PdpTool.getFile((String)sourceFileName);
        String pdpFileName = PdpTool.computePdpFileLocationFromSourceFileLocation((String)sourceFileName);
        try {
            IMarker[] existingMarkers = sourcefile.findMarkers("com.ibm.pdp.desynchro_between_sourcefile_and_pdpfile_marker", false, 2);
            if (existingMarkers.length > 0) {
                String bakFileName = String.valueOf(pdpFileName) + "." + "BAK";
                IFile bakFile = PdpTool.getFile((String)bakFileName);
                if (bakFile.exists()) {
                    bakFile.delete(true, null);
                }
                sourcefile.deleteMarkers("com.ibm.pdp.desynchro_between_sourcefile_and_pdpfile_marker", false, 2);
            }
        }
        catch (CoreException e) {
            Util.rethrow((Throwable)e);
        }
        PdpResourcesMgr.getInstance().registerResource(pdpFileName);
        ControllerFactory.getInstance().addResourceChangeListener();
        SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration((String)logicalFileName, (String)sourceFileName);
        controller.getDesignLink().sourceFileSavingCompletelyTerminated();
        IPath path = PTModelService.getPath((String)controller.getDesignLink().getFileId());
        DesignGeneratedAssocManager associate = DesignGeneratedAssocManager.getInstance();
        PTAssociationService.getInstance().fireAssociationChangeEvent(path, (IPTAssociate)associate);
    }

    private void dealWithCrossReferences(String logicalFileName, IController controller) {
        GenericMicroPatternsAndUsagesParser drf = new GenericMicroPatternsAndUsagesParser();
        GenericMicroPatternsAndUsagesResults drr = null;
        try {
            drr = drf.parse(logicalFileName, controller, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("PdpCobolEditor2.dealWithCrossReferences()" + e.getMessage());
        }
        if (drr != null) {
            controller.getDesignLink().setMicroPatternReferences(drr.getMicroPatternRefs());
            controller.getDesignLink().setRubriquesUsagesReferences(drr.getDetailedUsages());
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    protected void setActionsActivated(SourceViewer sourceViewer, boolean state) {
        super.setActionsActivated(sourceViewer, state);
    }

    protected void createToolItems(ToolBarManager tbm) {
        super.createToolItems(tbm);
    }

    protected void updateHeader() {
        super.updateHeader();
    }

    protected void updateToolItems() {
        super.updateToolItems();
    }

    protected IToolBarManager getToolBarManager(Composite parent) {
        IToolBarManager tbm = super.getToolBarManager(parent);
        return tbm;
    }

    protected void copy(boolean leftToRight) {
        super.copy(leftToRight);
    }

    protected byte[] getContents(boolean left) {
        return super.getContents(left);
    }

    public void refresh() {
        super.refresh();
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return super.doSave(newInput, oldInput);
    }

    public void flushLeft(IProgressMonitor monitor) {
        if (this._leftConfiguration instanceof IPdpSourceViewerConfiguration) {
            IPdpSourceViewerConfiguration pdpViewerConfiguration = (IPdpSourceViewerConfiguration)this._leftConfiguration;
            this.flush(pdpViewerConfiguration.getController(), true, monitor);
        } else {
            super.flushLeft(monitor);
        }
    }

    public void flushRight(IProgressMonitor monitor) {
        if (this._rightConfiguration instanceof IPdpSourceViewerConfiguration) {
            IPdpSourceViewerConfiguration pdpViewerConfiguration = (IPdpSourceViewerConfiguration)this._rightConfiguration;
            this.flush(pdpViewerConfiguration.getController(), false, monitor);
        } else {
            super.flushRight(monitor);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        CompareEditor compareEditor;
        IController controller;
        IPdpSourceViewerConfiguration pdpViewerConfiguration;
        if (this._leftConfiguration instanceof IPdpSourceViewerConfiguration) {
            pdpViewerConfiguration = (IPdpSourceViewerConfiguration)this._leftConfiguration;
            controller = pdpViewerConfiguration.getController();
            compareEditor = pdpViewerConfiguration.getCompareEditor();
            if (controller != null && !this.isMacroVirtualProcess) {
                controller.getEditorLink().removeEditor((IEditor)compareEditor);
                ControllerFactory.getInstance().dispose(controller);
            }
        }
        if (this._rightConfiguration instanceof IPdpSourceViewerConfiguration) {
            pdpViewerConfiguration = (IPdpSourceViewerConfiguration)this._rightConfiguration;
            controller = pdpViewerConfiguration.getController();
            compareEditor = pdpViewerConfiguration.getCompareEditor();
            if (controller != null && !this.isMacroVirtualProcess) {
                controller.getEditorLink().removeEditor((IEditor)compareEditor);
                ControllerFactory.getInstance().dispose(controller);
            }
        }
        super.handleDispose(event);
    }

    protected ITokenComparator createTokenComparator(String line) {
        ITokenComparator tokenComparator = new ITokenComparator(){

            public int getRangeCount() {
                return 0;
            }

            public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
                return false;
            }

            public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
                return false;
            }

            public int getTokenStart(int index) {
                return 0;
            }

            public int getTokenLength(int index) {
                return 0;
            }
        };
        return tokenComparator;
    }
}

