/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.cobol.ui.viewer;

import com.ibm.pdp.compare.cobol.ui.PartSide;
import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.sourcecode.editor.preferences.PdpSourceCodeEditorPreferencesTool;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class SourceDamagerRepairer
extends DefaultDamagerRepairer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Color _GEN_CODE_FOREGROUND_COLOR = PdpSourceCodeEditorPreferencesTool.getForegroundGeneratedCodeColor();
    private static Color _GEN_CODE_BACKGROUND_COLOR = PdpSourceCodeEditorPreferencesTool.getBackgroundGeneratedCodeColor();
    private static Color _MP_CODE_FOREGROUND_COLOR = PdpSourceCodeEditorPreferencesTool.getForegroundMpCodeColor();
    private static Color _MP_CODE_BACKGROUND_COLOR = PdpSourceCodeEditorPreferencesTool.getBackgroundMpCodeColor();
    private PartSide _partSide;
    private IController _controller;
    private IDocumentListener _documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent e) {
            System.out.println("AboutToBeChanged: " + e.toString());
        }

        public void documentChanged(DocumentEvent e) {
            System.out.println("Changed: " + e.toString());
            try {
                try {
                    e.fDocument.removeDocumentListener(SourceDamagerRepairer.this._documentListener);
                    String separator = System.getProperty("line.separator");
                    int end = e.fText.indexOf(separator);
                    if (end > 0) {
                        e.fDocument.replace(e.fOffset, e.fText.length(), String.valueOf(e.fText.substring(0, end)) + separator);
                    }
                }
                catch (BadLocationException badLocationException) {
                    e.fDocument.addDocumentListener(SourceDamagerRepairer.this._documentListener);
                }
            }
            finally {
                e.fDocument.addDocumentListener(SourceDamagerRepairer.this._documentListener);
            }
        }
    };
    private static Set<String> propertyNames = new HashSet<String>();

    static {
        propertyNames.add("mp");
    }

    public SourceDamagerRepairer(ITokenScanner scanner, PartSide partSide, IController controller) {
        super(scanner);
        this._partSide = partSide;
        this._controller = controller;
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        document.addDocumentListener(this._documentListener);
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        int beginIdx = region.getOffset();
        int endIdx = region.getOffset() + region.getLength();
        TextProcessor textProcessor = (TextProcessor)this._controller.getTextProcessor();
        Iterator iterator = textProcessor.segments(beginIdx, endIdx, propertyNames);
        while (iterator.hasNext()) {
            ITextSegment segment = (ITextSegment)iterator.next();
            int start = segment.beginIndex();
            int length = segment.endIndex() - segment.beginIndex();
            int fontStyle = this.fDefaultTextAttribute.getStyle();
            if (segment.isGenerated()) {
                IEditTree editTree = this._controller.getTextProcessor().getEditTree();
                ITextNode textNode = editTree.includingNode(segment.beginIndex(), segment.endIndex());
                if (textNode != null && textNode.getProperties() != null && textNode.getProperties().getProperty("mp") != null) {
                    presentation.addStyleRange(new StyleRange(start, length, _MP_CODE_FOREGROUND_COLOR, _MP_CODE_BACKGROUND_COLOR, fontStyle));
                    continue;
                }
                presentation.addStyleRange(new StyleRange(start, length, _GEN_CODE_FOREGROUND_COLOR, _GEN_CODE_BACKGROUND_COLOR, fontStyle));
                continue;
            }
            presentation.addStyleRange(new StyleRange(start, length, null, null, fontStyle));
        }
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        return super.getDamageRegion(partition, e, documentPartitioningChanged);
    }
}

