/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.cobol.ui.editor;

import com.ibm.pdp.compare.cobol.ui.PartSide;
import com.ibm.pdp.compare.cobol.ui.viewer.SourceMergeViewer;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.RegenerationStatus;
import com.ibm.pdp.sourcecode.editor.PdpSourceCodeEditorPlugin;
import com.ibm.pdp.util.Util;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;

public class CompareEditor
implements IEditor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SourceMergeViewer _sourceMergeViewer;
    private PartSide _partSide;
    private IController _controller;
    private boolean _isPdpFrameworkEnabled = true;
    private IDocument _document;
    private boolean _dirty = false;

    public CompareEditor(SourceMergeViewer sourceMergeViewer, PartSide partSide, IController controller) {
        this._sourceMergeViewer = sourceMergeViewer;
        this._partSide = partSide;
        this._controller = controller;
    }

    public void setDocument(IDocument document) {
        this._document = document;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public IController getController() {
        return this._controller;
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public IDocument getDocument() {
        return this._document;
    }

    public void grayGeneratedCode(int offset, int length) {
    }

    public void doRevertToSaved() {
    }

    public void setDirty() {
        if (this.isDirty()) {
            return;
        }
        this._dirty = true;
        try {
            if (this.getDocument() != null && this.getDocument().getLength() > 0) {
                this.replace(0, 0, "");
            }
        }
        catch (Exception e) {
            String mess = "Unexpected error.";
            PdpTool.logErr((Plugin)PdpSourceCodeEditorPlugin.getDefault(), (String)"com.ibm.pdp.sourcecode.editor", (String)mess, (Throwable)e);
        }
    }

    public void replace(final int startIndex, final int length, final String text) throws Exception {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CompareEditor.this.getDocument().replace(startIndex, length, text);
                    CompareEditor.this._sourceMergeViewer.refresh();
                }
                catch (Exception e) {
                    Util.rethrow((Throwable)e);
                }
            }
        });
    }

    public void updatePdpFoldingRegions(List<Position> positions, boolean markCollapsed) {
    }

    public IAnnotationModel getAnnotationModel() {
        return null;
    }

    public void doSave(IProgressMonitor pm) {
    }

    public void setRegenerationStatus(RegenerationStatus regenerationStatus, boolean refresh) {
    }

    public boolean replaceCurrentControllerWith(IController newController) {
        return false;
    }

    public boolean isMacroVirtual() {
        return this._sourceMergeViewer.isMacroVirtualProcess;
    }
}

