/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.compare.cobol.ui.action;

import com.ibm.pdp.compare.source.configuration.PdpCblSourceViewerConfiguration;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.designview.Messages;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IGenerationContext;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class GenerateAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(GenerateAction.class.getName()) + "_ID";
    private PdpCblSourceViewerConfiguration _configuration;

    public GenerateAction(PdpCblSourceViewerConfiguration configuration) {
        this._configuration = configuration;
        this.setText(Messages.PdpDesignView_GENERATE_AND_SAVE_ACTION_LABEL);
        this.setToolTipText(Messages.PdpDesignView_GENERATE_AND_SAVE_ACTION_TOOLTIP);
    }

    public void run() {
        if (this._configuration == null || this._configuration.getController() == null) {
            return;
        }
        Iterator referencesIterator = this._configuration.getController().getGenerationLink().getSubReferences();
        String logicalDesignName = MigrationHelpTool.getLogicalDesignName((Iterator)referencesIterator);
        String realFileName = PdpTool.addRPPFolderToFileName((String)logicalDesignName);
        ComparatorGenerationOptions context = new ComparatorGenerationOptions();
        IGenStatus genStatus = GenerationManager.generate((String)realFileName, (String)this._configuration.getController().getPattern().getName(), null, (IGenerationContext)context).getGenStatus();
        if (genStatus != null && genStatus.getState() == 1) {
            Iterator it = genStatus.getMessages();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                IStatusMessage message = (IStatusMessage)it.next();
                sb.append(message.getText());
                sb.append("\n");
            }
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)parent, (String)"Generation failed", (String)sb.toString());
            PdpTool.openErrorLog();
        } else {
            IWorkbenchPage worbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (worbenchPage != null && worbenchPage.getActiveEditor() != null) {
                worbenchPage.saveEditor(worbenchPage.getActiveEditor(), false);
            }
            GenerationManager.saveController((boolean)true, (IController)this._configuration.getController());
        }
    }

    private static class ComparatorGenerationOptions
    implements IGenerationContext {
        Map<String, Object> properties = new HashMap<String, Object>();

        public Map<String, Object> getGenerationProperties() {
            return this.properties;
        }

        public ComparatorGenerationOptions() {
            this.properties.put("DOUBLE_ON_MICRO_PATTERN", "true");
        }
    }
}

