/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.test;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencer;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencerWithSignificantDots;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.File;

public class TestPacbaseCobolDifferencer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        File file1 = new File("C:\\Users\\IBM_ADMIN\\Documents\\data\\WI 10177\\AJ4083K.cbl");
        File file2 = new File("C:\\Users\\IBM_ADMIN\\Documents\\data\\WI 10177\\AJ4083K.mia.cbl");
        String reference = Strings.fileToString((File)file1);
        String modified = Strings.fileToString((File)file2);
        PacbaseCobolDifferencerWithSignificantDots differencer = new PacbaseCobolDifferencerWithSignificantDots(reference, modified);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        while (cursor.searchNextDifference()) {
            System.out.println(cursor.getDifferenceNature());
            switch (cursor.getDifferenceNature()) {
                case Deletion: {
                    TestPacbaseCobolDifferencer.showRefLineInterval(cursor, differencer);
                    TestPacbaseCobolDifferencer.showRefTokens(cursor, differencer);
                    System.out.println();
                    TestPacbaseCobolDifferencer.showModLineInterval(cursor, differencer);
                    break;
                }
                case Insertion: {
                    TestPacbaseCobolDifferencer.showRefLineInterval(cursor, differencer);
                    System.out.println();
                    TestPacbaseCobolDifferencer.showModLineInterval(cursor, differencer);
                    TestPacbaseCobolDifferencer.showModTokens(cursor, differencer);
                    break;
                }
                case Replacement: {
                    TestPacbaseCobolDifferencer.showRefLineInterval(cursor, differencer);
                    TestPacbaseCobolDifferencer.showRefTokens(cursor, differencer);
                    System.out.println();
                    TestPacbaseCobolDifferencer.showModLineInterval(cursor, differencer);
                    TestPacbaseCobolDifferencer.showModTokens(cursor, differencer);
                }
            }
            System.out.println();
            System.out.println();
        }
    }

    public static void showRefLineInterval(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int refBeginTokenRank = cursor.getReferenceBeginIndex();
        int refEndTokenRank = cursor.getReferenceEndIndex();
        CobolToken[] tokens = differencer.getReferenceTokens();
        int refBeginLine = differencer.referenceLineRankFromCharIndex(tokens[refBeginTokenRank].beginIdx);
        int refEndLine = refEndTokenRank == tokens.length ? differencer.getReferenceLineIndexes().length : differencer.referenceLineRankFromCharIndex(tokens[refEndTokenRank].beginIdx);
        System.out.print("<[");
        System.out.print(refBeginLine);
        System.out.print(",");
        System.out.print(refEndLine);
        System.out.print("]");
    }

    public static void showModLineInterval(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int modBeginTokenRank = cursor.getModifiedBeginIndex();
        int modEndTokenRank = cursor.getModifiedEndIndex();
        CobolToken[] tokens = differencer.getModifiedTokens();
        int modBeginLine = differencer.modifiedLineRankFromCharIndex(tokens[modBeginTokenRank].beginIdx);
        int modEndLine = modEndTokenRank == tokens.length ? differencer.getModifiedLineIndexes().length : differencer.modifiedLineRankFromCharIndex(tokens[modEndTokenRank].beginIdx);
        System.out.print(">[");
        System.out.print(modBeginLine);
        System.out.print(",");
        System.out.print(modEndLine);
        System.out.print("]");
    }

    public static void showRefTokens(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int tokenRank = cursor.getReferenceBeginIndex();
        while (tokenRank < cursor.getReferenceEndIndex()) {
            System.out.print(differencer.getReferenceTokens()[tokenRank]);
            System.out.print(" ");
            ++tokenRank;
        }
    }

    public static void showModTokens(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int tokenRank = cursor.getModifiedBeginIndex();
        while (tokenRank < cursor.getModifiedEndIndex()) {
            System.out.print(differencer.getModifiedTokens()[tokenRank]);
            System.out.print(" ");
            ++tokenRank;
        }
    }

    public static int refLineBegin(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int beginTokenRank = cursor.getReferenceBeginIndex();
        int beginIdx = differencer.getReferenceTokens()[beginTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(beginIdx);
    }

    public static int refLineEnd(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int endTokenRank = cursor.getReferenceEndIndex();
        if (endTokenRank == differencer.getReferenceTokens().length) {
            return differencer.getReferenceLineIndexes().length;
        }
        int endIdx = differencer.getReferenceTokens()[endTokenRank].endIdx;
        return differencer.referenceLineRankFromCharIndex(endIdx);
    }

    public static int modLineBegin(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int beginTokenRank = cursor.getReferenceBeginIndex();
        int beginIdx = differencer.getReferenceTokens()[beginTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(beginIdx);
    }

    public static int modLineEnd(DiffCursor cursor, PacbaseCobolDifferencer differencer) {
        int beginTokenRank = cursor.getReferenceBeginIndex();
        int beginIdx = differencer.getReferenceTokens()[beginTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(beginIdx);
    }
}

