/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.test;

import com.ibm.pdp.cobolcompare.CobolDifferencer;

public class BasicTest {
    private static String[] identicalCobols1 = new String[]{"       MOVE 'Hello world' TO XXX-123.", "123456      move      'Hello world'      to      XXX-123    .           AAAAAAAA", "      * Comment 1\n      / Comment 2                                                               \n654321      MOVE      'Hello world'      to      XXX-123               .BBBBBBBB\n      * Comment 3                                                       CCCCCCCC\n      / Comment 4\n", "          MOVE\n          'Hello world'\n          TO\n          XXX-123\n          .", "\n    \n                                                  \n                                                                        AAAAAAAA\n          MOVE\n\n123456                   'Hello world'                                  BBBBBBBB\n    \n\n      * Comment 8\n      / Comment 454\n          TO\n                                                                                \n654321                   XXX-123\n      * Comment 87979\n      / Comment 0+87\n                                                                       .CCCCCCCC\n                                                  \n\n                          \n      * Comment 970606\n      / Comment 987096", "          MOVE                                                   'Hello \n      -                              'world'\n          TO\n          XXX-123\n          .", "          MOVE                                                        'H\n      -                                                               'e\n123456-                                                               'l        \n    \n                                                                        AAAAAAAA\n      -                                                               'l\n      * Comment 979807\n      -                                                               'oXXXXXXXX\n      / Comment 979879874                                                    \n      -                                                               '   \n654321-                                                               'w\n      -                                                               'o X Y Z \n      * Comment 979807\n      -                                                               'r\n                                                  \n      -                                                               'l\n    \n                                                  \n                                                                        AAAAAAAA\n      -             'd'\n          TO\n          XXX-123\n          .", "      * Comment 98709879\n          MOVE\n                                                                      'H\n      -                                                               'e\n                          \n      -                                                               'l\n      -                                                               'l\n      -                                                               'o        \n123456* Comment 979807\n      -                                                               '   \n\n      -                                                               'w\n      -                                                               'oCOUCOU\n123456-                                                               'rrrrrrr\n      / Comment 57664                                                   \n      -                                                               'l\n    \n                                                  \n                                                                        UUUUUUU\n654321-             'd' TO XXX-123.\n"};
    private static String[] identicalCobols2 = new String[]{"       DISPLAY '[L''ami \"ricor\u00e9\"]'                                      XXXXXXXX", "123456              Display                 \"[L'ami \"\"ricor\u00e9\"\"]\"", "       Display                                                 '[L''ami \n      -                                 '\"ricor\u00e9\"]'", "       DISPLAY                                                  \"[L'ami \n      -                           \"\"\"ricor\u00e9\"\"]\"", "       Display                                                          AAAAAAA\n                                                               '[L''ami YYYYYYYY\n654321-                                 '\"ricor\u00e9\"]'", "       Display\n123456* Comment 979807\n                                                                \"[L'ami \n      / Comment 57664                                                   \n                          \n      -                           \"\"\"ricor\u00e9\"\"]\""};
    private static String identical = "------*------------------------ IDENTICAL ------------------------------|-------";
    private static String different = "!!!!!!*!!!!!!!!!!!!!!!!!!!!!!!! DIFFERENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!|!!!!!!!";
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        BasicTest.testIdenticalCobols(identicalCobols1);
        BasicTest.testIdenticalCobols(identicalCobols2);
    }

    public static void testIdenticalCobols(String[] cobols) {
        CobolDifferencer differencer = new CobolDifferencer();
        int i = 0;
        while (i < cobols.length) {
            int j = i;
            while (j < cobols.length) {
                differencer.setReferenceCobol(cobols[i]);
                differencer.setModifiedCobol(cobols[j]);
                BasicTest.show(differencer.getReferenceCobol(), differencer.getModifiedCobol(), differencer.sameCobols());
                ++j;
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            ++i;
        }
    }

    protected static void checkIdenticalCobols(CobolDifferencer differencer) {
        if (!differencer.sameCobols()) {
            BasicTest.show(differencer.getReferenceCobol(), differencer.getModifiedCobol(), false);
            throw new RuntimeException("Different COBOLs");
        }
    }

    protected static void show(CharSequence cobol1, CharSequence cobol2, boolean identicalCobols) {
        System.out.println("================================================================================");
        System.out.println("      *  1         2         3         4         5         6         7  |      8");
        System.out.println(cobol1);
        if (identicalCobols) {
            System.out.println(identical);
        } else {
            System.out.println(different);
        }
        System.out.println(cobol2);
    }
}

