/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.serialization;

import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.serialization.Position;
import com.ibm.pdp.util.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DifferenceBankSerializer {
    public static HashMap<Word, Position> words;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void addWord(Word word, int posList, int posLinked) {
        words.put(word, new Position(posList, posLinked));
    }

    public static void serializeWordReference(XMLStreamWriter xmlWriter, Word reference) throws XMLStreamException {
        xmlWriter.writeStartElement("WORD_REFERENCE");
        Position pos = words.get(reference);
        if (pos != null) {
            xmlWriter.writeAttribute("POS", pos.toString());
        }
        xmlWriter.writeEndElement();
    }

    public boolean serialize(DifferenceBank db, String fileName) {
        block30: {
            FileWriter fw;
            block31: {
                if (words != null) {
                    words.clear();
                } else {
                    words = new HashMap();
                }
                XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                XMLStreamWriter xmlWriter = null;
                fw = null;
                try {
                    fw = new FileWriter(fileName);
                    BufferedWriter bf = new BufferedWriter(fw);
                    xmlWriter = outputFactory.createXMLStreamWriter(bf);
                    xmlWriter.writeStartDocument("ISO-8859-1", "1.0");
                    xmlWriter.writeStartElement("DIFFERENCE_BANK");
                    xmlWriter.writeAttribute("version", "1.1");
                    db.serialize(xmlWriter);
                    xmlWriter.writeEndElement();
                }
                catch (XMLStreamException e) {
                    Util.rethrow((Throwable)e);
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.flush();
                            xmlWriter.close();
                        }
                        catch (XMLStreamException e2) {
                            Util.rethrow((Throwable)e2);
                        }
                    }
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block30;
                    }
                    catch (IOException e3) {
                        Util.rethrow((Throwable)e3);
                    }
                    break block30;
                }
                catch (IOException e) {
                    try {
                        System.out.println("File " + fileName + " could not be saved. Error mess : " + e.getMessage());
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (xmlWriter != null) {
                            try {
                                xmlWriter.flush();
                                xmlWriter.close();
                            }
                            catch (XMLStreamException e4) {
                                Util.rethrow((Throwable)e4);
                            }
                        }
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (IOException e5) {
                            Util.rethrow((Throwable)e5);
                        }
                    }
                }
                if (xmlWriter == null) break block31;
                try {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    Util.rethrow((Throwable)e);
                }
            }
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
        words.clear();
        words = null;
        return true;
    }
}

