/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WordInsertion
extends WordDifference {
    protected int hash;
    protected Word[] insertedWords;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WordInsertion(int hash, Word[] insertedWords) {
        this.hash = hash;
        this.insertedWords = insertedWords;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Insertion;
    }

    @Override
    public int deletedWordsCount() {
        return 0;
    }

    @Override
    public Word[] deletedWords() {
        return EMPTY_WORDS;
    }

    @Override
    public int addedWordsCount() {
        return this.insertedWords.length;
    }

    @Override
    public Word[] addedWords() {
        return this.insertedWords;
    }

    @Override
    public boolean sameAs(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        if (cursor.getReferenceEndIndex() != cursor.getReferenceBeginIndex()) {
            return false;
        }
        if (cursor.getModifiedEndIndex() - cursor.getModifiedBeginIndex() != this.insertedWords.length) {
            return false;
        }
        int tokenRank = cursor.getModifiedBeginIndex();
        int wordRank = 0;
        while (wordRank < this.insertedWords.length) {
            if (!this.insertedWords[wordRank].sameText(modTokens[tokenRank])) {
                return false;
            }
            ++tokenRank;
            ++wordRank;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpTo(builder);
        return builder.toString();
    }

    @Override
    protected void dumpTo(StringBuilder builder) {
        super.dumpTo(builder);
        builder.append("\n +: ");
        Word[] wordArray = this.insertedWords;
        int n = this.insertedWords.length;
        int n2 = 0;
        while (n2 < n) {
            Word word = wordArray[n2];
            builder.append(word).append(' ');
            ++n2;
        }
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "WORD_INSERTION", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("HASH", "" + this.hash);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }
}

