/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WordDeletion
extends WordDifference {
    protected int hash;
    protected Word[] deletedWords;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WordDeletion(int hash, Word[] deletedWords) {
        this.hash = hash;
        this.deletedWords = deletedWords;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Deletion;
    }

    @Override
    public int deletedWordsCount() {
        return this.deletedWords.length;
    }

    @Override
    public Word[] deletedWords() {
        return this.deletedWords;
    }

    @Override
    public int addedWordsCount() {
        return 0;
    }

    @Override
    public Word[] addedWords() {
        return EMPTY_WORDS;
    }

    @Override
    public boolean sameAs(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        if (cursor.getModifiedEndIndex() != cursor.getModifiedBeginIndex()) {
            return false;
        }
        if (cursor.getReferenceEndIndex() - cursor.getReferenceBeginIndex() != this.deletedWords.length) {
            return false;
        }
        int tokenRank = cursor.getReferenceBeginIndex();
        int wordRank = 0;
        while (wordRank < this.deletedWords.length) {
            if (!this.deletedWords[wordRank].sameText(refTokens[tokenRank])) {
                return false;
            }
            ++tokenRank;
            ++wordRank;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpTo(builder);
        return builder.toString();
    }

    @Override
    protected void dumpTo(StringBuilder builder) {
        super.dumpTo(builder);
        builder.append("\n -: ");
        Word[] wordArray = this.deletedWords;
        int n = this.deletedWords.length;
        int n2 = 0;
        while (n2 < n) {
            Word word = wordArray[n2];
            builder.append(word).append(' ');
            ++n2;
        }
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "WORD_DELETION", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("HASH", "" + this.hash);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }
}

