/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.serialization.DifferenceBankSerializer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class Word {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Word next;

    public abstract boolean sameText(CobolToken var1);

    public abstract int length();

    public abstract char firstChar();

    public abstract char lastChar();

    public abstract char[] chars();

    public abstract boolean quoted();

    public abstract void serialize(XMLStreamWriter var1, int var2, int var3) throws XMLStreamException;

    public boolean sameWord(Word otherWord) {
        char[] otherCh;
        if (this.getClass() != otherWord.getClass()) {
            return false;
        }
        char[] ch = this.chars();
        if (ch.length != (otherCh = otherWord.chars()).length) {
            return false;
        }
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != otherCh[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void serialize(XMLStreamWriter writer, String type, int pos, int j) throws XMLStreamException {
        DifferenceBankSerializer.addWord(this, pos, j);
        if (this.next != null) {
            this.next.serialize(writer, pos, ++j);
        }
    }

    protected static char uppercase(char chr) {
        return chr >= 'a' && chr <= 'z' ? (char)(chr - 97 + 65) : chr;
    }
}

