/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SingleWordDeletion
extends WordDifference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Word deletedWord;

    public SingleWordDeletion(Word deletedWord) {
        this.deletedWord = deletedWord;
    }

    @Override
    public DifferenceNature getDifferenceNature() {
        return DifferenceNature.Deletion;
    }

    @Override
    public int deletedWordsCount() {
        return 1;
    }

    @Override
    public Word[] deletedWords() {
        return new Word[]{this.deletedWord};
    }

    @Override
    public int addedWordsCount() {
        return 0;
    }

    @Override
    public Word[] addedWords() {
        return EMPTY_WORDS;
    }

    @Override
    public boolean sameAs(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        if (cursor.getModifiedEndIndex() != cursor.getModifiedBeginIndex()) {
            return false;
        }
        if (cursor.getReferenceEndIndex() - cursor.getReferenceBeginIndex() != 1) {
            return false;
        }
        CobolToken deletedToken = refTokens[cursor.getReferenceBeginIndex()];
        return this.deletedWord.sameText(deletedToken);
    }

    public int hashCode() {
        return this.deletedWord.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpTo(builder);
        return builder.toString();
    }

    @Override
    protected void dumpTo(StringBuilder builder) {
        super.dumpTo(builder);
        builder.append("\n -: ").append(this.deletedWord.toString());
    }

    @Override
    public void serialize(XMLStreamWriter writer, int posArray, int posList) throws XMLStreamException {
        this.serialize(writer, "SINGLE_WORD_DELETION", posArray, posList);
    }

    protected void serialize(XMLStreamWriter writer, String type, int posArray, int posList) throws XMLStreamException {
        writer.writeStartElement(type);
        this.serializeDifferences(writer, type, posArray, posList);
        writer.writeEndElement();
        this.serializeNext(writer, type, posArray, posList);
    }

    @Override
    public void changeDeletedWord(int i, Word word) {
        this.deletedWord = word;
    }
}

