/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.CobolTokenizer;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencer;
import com.ibm.pdp.util.containers.Appender;

public class PacbaseCobolDifferencerWithSignificantDots
extends PacbaseCobolDifferencer {
    public static int maximumCobolLineLength = 72;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        String compMaxCobolLineLength = System.getProperty("compMaxCobolLineLength");
        if (compMaxCobolLineLength != null) {
            maximumCobolLineLength = Integer.parseInt(compMaxCobolLineLength);
        }
    }

    public PacbaseCobolDifferencerWithSignificantDots() {
        this.cobolLineLength = maximumCobolLineLength;
    }

    public PacbaseCobolDifferencerWithSignificantDots(String reference, String modified) {
        super(reference, modified);
        this.cobolLineLength = maximumCobolLineLength;
    }

    @Override
    protected boolean buildTokensToProcedure(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        boolean active = true;
        while (tokenizer.nextToken(token)) {
            if (active && token.equals(PICTURE_TOKEN)) {
                if (!this.appendPicture(tokenizer, token, tokens)) {
                    return false;
                }
            } else {
                active = this.appendTokenIgnorePacConstants(active, token, tokens, tokenizer);
            }
            if (!token.equals(PROCEDURE_TOKEN)) continue;
            if (CobolTokenizer.handleCommentChars) {
                return true;
            }
            return tokenizer.line[CobolTokenizer.indicatorColumn] != '*' && tokenizer.line[CobolTokenizer.indicatorColumn + 1] != '*';
        }
        return false;
    }

    @Override
    protected boolean appendPicture(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        CharSequence text = token.text;
        tokens.append((Object)token.clone());
        if (!tokenizer.nextToken(token) || token.equals(IS_TOKEN) && !tokenizer.nextToken(token)) {
            return false;
        }
        if (token.category >= 2) {
            tokens.append((Object)token.clone());
            return true;
        }
        int beginIdx = token.beginIdx;
        int endIdx = token.endIdx;
        boolean endOfText = false;
        CobolToken savedToken = null;
        while (true) {
            if (!tokenizer.nextToken(token)) {
                endOfText = true;
                break;
            }
            if (token.category >= 2 || token.beginIdx != endIdx) break;
            endIdx = token.endIdx;
            if (token.equals(DOT_TOKEN)) {
                savedToken = token.clone();
                continue;
            }
            savedToken = null;
        }
        if (savedToken != null) {
            --endIdx;
        }
        CobolToken collated = new CobolToken(beginIdx, endIdx, 1, text);
        tokens.append((Object)collated);
        if (savedToken != null) {
            tokens.append((Object)savedToken);
        }
        if (endOfText) {
            return false;
        }
        tokens.append((Object)token.clone());
        return true;
    }

    @Override
    protected int appendTokenSkipExitDot(int ifCount, CobolToken token, Appender<CobolToken> tokens) {
        tokens.append((Object)token.clone());
        return ifCount;
    }

    @Override
    protected CobolToken[] buildTokens(String cobol) {
        boolean hasEnvironmentToken;
        Appender tokens = new Appender();
        CobolTokenizer tokenizer = new CobolTokenizer(cobol, this.cobolLineLength);
        CobolToken token = tokenizer.newToken();
        boolean bl = hasEnvironmentToken = cobol.indexOf("ENVIRONMENT") != -1;
        if (hasEnvironmentToken && !this.skipToEnvironment(tokenizer, token, (Appender<CobolToken>)tokens)) {
            return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
        }
        if (!this.buildTokensToProcedure(tokenizer, token, (Appender<CobolToken>)tokens)) {
            return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
        }
        this.buildTokensForProcedure(tokenizer, token, (Appender<CobolToken>)tokens);
        return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
    }
}

