/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CharDiffCursor;
import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.CobolTokenizer;
import com.ibm.pdp.cobolcompare.LinesDiffCursor;
import com.ibm.pdp.util.containers.Appender;
import com.ibm.pdp.util.diff.ArrayDifferencer;
import com.ibm.pdp.util.diff.DefaultArrayDifferencer;
import com.ibm.pdp.util.diff.DiffCursor;

public class PacbaseCobolDifferencer {
    protected String referenceCobol;
    protected String modifiedCobol;
    protected int[] referenceLineIndexes;
    protected int[] modifiedLineIndexes;
    protected CobolToken[] referenceTokens;
    protected CobolToken[] modifiedTokens;
    protected String referencePacbaseConstants;
    protected String modifiedPacbaseConstants;
    protected ArrayDifferencer<CobolToken> tokenDifferencer;
    protected int cobolLineLength;
    protected static final String CONSTANTES_PAC = "CONSTANTES-PAC";
    protected static final String PAC_CONSTANTES = "PAC-CONSTANTES";
    protected static final String PACBASE_CONSTANTS = "PACBASE-CONSTANTS";
    protected static final String CONSTANTS_PACBASE = "CONSTANTS-PACBASE";
    protected static final String EXIT = "EXIT";
    protected static final String DOT = ".";
    protected static final String IF = "IF";
    protected static final String ENVIRONMENT = "ENVIRONMENT";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String PICTURE = "PICTURE";
    protected static final String IS = "IS";
    protected static final CobolToken CONSTANTES_PAC_TOKEN = new CobolToken(1, "CONSTANTES-PAC");
    protected static final CobolToken PAC_CONSTANTES_TOKEN = new CobolToken(1, "PAC-CONSTANTES");
    protected static final CobolToken PACBASE_CONSTANTS_TOKEN = new CobolToken(1, "PACBASE-CONSTANTS");
    protected static final CobolToken CONSTANTS_PACBASE_TOKEN = new CobolToken(1, "CONSTANTS-PACBASE");
    protected static final CobolToken EXIT_TOKEN = new CobolToken(1, "EXIT");
    protected static final CobolToken DOT_TOKEN = new CobolToken(0, ".");
    protected static final CobolToken IF_TOKEN = new CobolToken(1, "IF");
    protected static final CobolToken ENVIRONMENT_TOKEN = new CobolToken(1, "ENVIRONMENT");
    protected static final CobolToken PROCEDURE_TOKEN = new CobolToken(1, "PROCEDURE");
    protected static final CobolToken LEVEL01_TOKEN = new CobolToken(1, "01");
    protected static final CobolToken PICTURE_TOKEN = new CobolToken(1, "PICTURE");
    protected static final CobolToken IS_TOKEN = new CobolToken(1, "IS");
    protected String pacbaseConstantsValue;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacbaseCobolDifferencer() {
        this(null, null);
    }

    public PacbaseCobolDifferencer(String reference, String modified) {
        this.referenceCobol = reference;
        this.modifiedCobol = modified;
    }

    public String getReferenceCobol() {
        return this.referenceCobol;
    }

    public void setReferenceCobol(String reference) {
        this.referenceCobol = reference;
        this.referenceLineIndexes = null;
        this.referenceTokens = null;
        this.tokenDifferencer = null;
        this.pacbaseConstantsValue = null;
    }

    public String getModifiedCobol() {
        return this.modifiedCobol;
    }

    public void setModifiedCobol(String modified) {
        this.modifiedCobol = modified;
        this.modifiedLineIndexes = null;
        this.modifiedTokens = null;
        this.tokenDifferencer = null;
        this.pacbaseConstantsValue = null;
    }

    public int[] getReferenceLineIndexes() {
        if (this.referenceLineIndexes == null) {
            this.referenceLineIndexes = this.computeLineIndexes(this.referenceCobol);
        }
        return this.referenceLineIndexes;
    }

    public int referenceLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getReferenceLineIndexes();
        int lineRank = PacbaseCobolDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
        return lineRank >= 0 ? lineRank : ~lineRank - 1;
    }

    public int[] getModifiedLineIndexes() {
        if (this.modifiedLineIndexes == null) {
            this.modifiedLineIndexes = this.computeLineIndexes(this.modifiedCobol);
        }
        return this.modifiedLineIndexes;
    }

    public int modifiedLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getModifiedLineIndexes();
        int lineRank = PacbaseCobolDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
        return lineRank >= 0 ? lineRank : ~lineRank - 1;
    }

    protected static int lineRankFromIndex(int index, int[] lineStartIndex, int begin, int end) {
        while (begin < end) {
            int middle = begin + end >> 1;
            int value = lineStartIndex[middle];
            if (index > value) {
                begin = middle + 1;
                continue;
            }
            if (index < value) {
                end = middle;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    protected int[] computeLineIndexes(String s) {
        if (s.length() == 0) {
            return new int[0];
        }
        int[] lines = new int[1 + s.length() / 80];
        lines[0] = 0;
        int nbLines = 1;
        int index = this.nextLineStartIndex(s, 0);
        while (index != -1) {
            if (nbLines == lines.length) {
                int[] newLines = new int[nbLines + (nbLines >> 3) + 10];
                System.arraycopy(lines, 0, newLines, 0, nbLines);
                lines = newLines;
            }
            lines[nbLines++] = index;
            index = this.nextLineStartIndex(s, index);
        }
        if (nbLines != lines.length) {
            int[] newLines = new int[nbLines];
            System.arraycopy(lines, 0, newLines, 0, nbLines);
            lines = newLines;
        }
        return lines;
    }

    protected int nextLineStartIndex(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c == '\r') {
                if (++index < length && s.charAt(index) == '\n') {
                    ++index;
                }
                return index;
            }
            if (c == '\n') {
                if (++index < length && s.charAt(index) == '\r') {
                    ++index;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    public CobolToken[] getReferenceTokens() {
        if (this.referenceTokens == null) {
            this.referenceTokens = this.buildTokens(this.referenceCobol);
            this.referencePacbaseConstants = this.pacbaseConstantsValue;
            this.pacbaseConstantsValue = null;
        }
        return this.referenceTokens;
    }

    public CobolToken[] getModifiedTokens() {
        if (this.modifiedTokens == null) {
            this.modifiedTokens = this.buildTokens(this.modifiedCobol);
            this.modifiedPacbaseConstants = this.pacbaseConstantsValue;
            this.pacbaseConstantsValue = null;
        }
        return this.modifiedTokens;
    }

    public String getReferencePacbaseConstants() {
        return this.referencePacbaseConstants != null ? this.referencePacbaseConstants : "";
    }

    public String getModifiedPacbaseConstants() {
        return this.modifiedPacbaseConstants != null ? this.modifiedPacbaseConstants : "";
    }

    public boolean sameCobols() {
        CobolTokenizer tokenizer1 = new CobolTokenizer(this.referenceCobol, this.cobolLineLength);
        CobolTokenizer tokenizer2 = new CobolTokenizer(this.modifiedCobol, this.cobolLineLength);
        CobolToken token1 = tokenizer1.newToken();
        CobolToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (tokenizer2.nextToken(token2) && token1.equals(token2)) continue;
            return false;
        }
        return !tokenizer2.nextToken(token2);
    }

    public int[] firstDifferenceIndexes() {
        CobolTokenizer tokenizer1 = new CobolTokenizer(this.referenceCobol, this.cobolLineLength);
        CobolTokenizer tokenizer2 = new CobolTokenizer(this.modifiedCobol, this.cobolLineLength);
        CobolToken token1 = tokenizer1.newToken();
        CobolToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (!tokenizer2.nextToken(token2)) {
                return new int[]{token1.beginIdx, this.modifiedCobol.length()};
            }
            if (token1.equals(token2)) continue;
            return new int[]{token1.beginIdx, token2.beginIdx};
        }
        if (tokenizer2.nextToken(token2)) {
            return new int[]{this.referenceCobol.length(), token2.beginIdx};
        }
        return null;
    }

    public DiffCursor newTokenDifferencesCursor() {
        return this.getTokenDifferencer().newDiffCursor();
    }

    protected ArrayDifferencer<CobolToken> getTokenDifferencer() {
        if (this.tokenDifferencer == null) {
            this.tokenDifferencer = new DefaultArrayDifferencer((Object[])this.getReferenceTokens(), (Object[])this.getModifiedTokens());
        }
        return this.tokenDifferencer;
    }

    public DiffCursor newCharDifferencesCursor() {
        return new CharDiffCursor(this.referenceCobol, this.getReferenceTokens(), this.modifiedCobol, this.getModifiedTokens());
    }

    public DiffCursor newLineDifferencesCursor() {
        return new LinesDiffCursor(this.referenceCobol, this.getReferenceTokens(), this.getReferenceLineIndexes(), this.modifiedCobol, this.getModifiedTokens(), this.getModifiedLineIndexes());
    }

    protected CobolToken[] buildTokens(String cobol) {
        Appender tokens = new Appender();
        CobolTokenizer tokenizer = new CobolTokenizer(cobol, this.cobolLineLength);
        CobolToken token = tokenizer.newToken();
        if (!this.skipToEnvironment(tokenizer, token, (Appender<CobolToken>)tokens)) {
            return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
        }
        if (!this.buildTokensToProcedure(tokenizer, token, (Appender<CobolToken>)tokens)) {
            return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
        }
        this.buildTokensForProcedure(tokenizer, token, (Appender<CobolToken>)tokens);
        return this.newTokenArray(tokenizer, token, (Appender<CobolToken>)tokens);
    }

    protected boolean skipToEnvironment(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        while (tokenizer.nextToken(token)) {
            if (!token.equals(ENVIRONMENT_TOKEN)) continue;
            tokens.append((Object)token.clone());
            return true;
        }
        return false;
    }

    protected boolean buildTokensToProcedure(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        boolean active = true;
        while (tokenizer.nextToken(token)) {
            if (token.equals(DOT_TOKEN)) continue;
            if (active && token.equals(PICTURE_TOKEN)) {
                if (!this.appendPicture(tokenizer, token, tokens)) {
                    return false;
                }
            } else {
                active = this.appendTokenIgnorePacConstants(active, token, tokens, tokenizer);
            }
            if (!token.equals(PROCEDURE_TOKEN)) continue;
            return true;
        }
        return false;
    }

    protected boolean appendPicture(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        CharSequence text = token.text;
        tokens.append((Object)token.clone());
        if (!tokenizer.nextToken(token) || token.equals(IS_TOKEN) && !tokenizer.nextToken(token)) {
            return false;
        }
        if (token.category >= 2) {
            tokens.append((Object)token.clone());
            return true;
        }
        int beginIdx = token.beginIdx;
        int endIdx = token.endIdx;
        boolean endOfText = false;
        while (true) {
            if (!tokenizer.nextToken(token)) {
                endOfText = true;
                break;
            }
            if (token.category >= 2 || token.beginIdx != endIdx) break;
            endIdx = token.endIdx;
        }
        if (text.charAt(endIdx - 1) == '.') {
            --endIdx;
        }
        CobolToken collated = new CobolToken(beginIdx, endIdx, 1, text);
        tokens.append((Object)collated);
        if (endOfText) {
            return false;
        }
        tokens.append((Object)token.clone());
        return true;
    }

    protected boolean appendTokenIgnorePacConstants(boolean active, CobolToken token, Appender<CobolToken> tokens, CobolTokenizer tokenizer) {
        if (active) {
            tokens.append((Object)token.clone());
            return !token.equals(CONSTANTES_PAC_TOKEN) && !token.equals(PACBASE_CONSTANTS_TOKEN);
        }
        if (token.category >= 2) {
            this.pacbaseConstantsValue = this.pacbaseConstantsValue == null ? token.toString() : String.valueOf(this.pacbaseConstantsValue.substring(0, this.pacbaseConstantsValue.length() - 1)) + token.toString().substring(1);
        }
        if (token.equals(LEVEL01_TOKEN)) {
            if (CobolTokenizer.handleCommentChars) {
                tokens.append((Object)token.clone());
                return true;
            }
            if (tokenizer.line[CobolTokenizer.indicatorColumn] != '*' && tokenizer.line[CobolTokenizer.indicatorColumn + 1] != '*') {
                tokens.append((Object)token.clone());
                return true;
            }
        }
        return false;
    }

    protected void buildTokensForProcedure(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        int ifCount = 0;
        while (tokenizer.nextToken(token)) {
            ifCount = this.appendTokenSkipExitDot(ifCount, token, tokens);
        }
    }

    protected CobolToken[] newTokenArray(CobolTokenizer tokenizer, CobolToken token, Appender<CobolToken> tokens) {
        Object[] result = new CobolToken[tokens.size()];
        tokens.copyTo(result);
        return result;
    }

    protected int appendTokenSkipExitDot(int ifCount, CobolToken token, Appender<CobolToken> tokens) {
        if (token.equals(EXIT_TOKEN)) {
            return ifCount;
        }
        if (token.equals(DOT_TOKEN)) {
            if (ifCount <= 0) {
                return 0;
            }
            tokens.append((Object)token.clone());
            return ifCount - 1;
        }
        tokens.append((Object)token.clone());
        if (token.equals(IF_TOKEN)) {
            return ifCount + 1;
        }
        return ifCount;
    }
}

