/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CharDiffCursor;
import com.ibm.pdp.cobolcompare.CobolDifferencer;
import com.ibm.pdp.cobolcompare.CobolToken;

class LinesDiffCursor
extends CharDiffCursor {
    protected int[] refLinesIndexes;
    protected int[] modLinesIndexes;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected LinesDiffCursor(CharSequence reference, CobolToken[] referenceTokens, int[] refLinesIndexes, CharSequence modified, CobolToken[] modifiedTokens, int[] modLinesIndexes) {
        super(reference, referenceTokens, modified, modifiedTokens);
        this.refLinesIndexes = refLinesIndexes;
        this.modLinesIndexes = modLinesIndexes;
    }

    @Override
    protected void computeIndexes() {
        super.computeIndexes();
        int refBeginLineRank = CobolDifferencer.lineRankFromIndex(this.refBeginIdx, this.refLinesIndexes, 0, this.refLinesIndexes.length);
        int refEndLineRank = CobolDifferencer.lineRankFromIndex(this.refEndIdx, this.refLinesIndexes, 0, this.refLinesIndexes.length);
        this.refBeginIdx = refBeginLineRank >= 0 ? refBeginLineRank : ~refBeginLineRank - 1;
        this.refEndIdx = refEndLineRank >= 0 ? refEndLineRank : ~refEndLineRank;
        int modBeginLineRank = CobolDifferencer.lineRankFromIndex(this.modBeginIdx, this.modLinesIndexes, 0, this.modLinesIndexes.length);
        int modEndLineRank = CobolDifferencer.lineRankFromIndex(this.modEndIdx, this.modLinesIndexes, 0, this.modLinesIndexes.length);
        this.modBeginIdx = modBeginLineRank >= 0 ? modBeginLineRank : ~modBeginLineRank - 1;
        this.modEndIdx = modEndLineRank >= 0 ? modEndLineRank : ~modEndLineRank;
    }
}

